# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...engine.types.option_value import OptionValue
from .remote_field_type_id import RemoteFieldTypeId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class RemoteFieldSchema(pydantic.BaseModel):
    field_type_id: RemoteFieldTypeId
    field_type: typing.Optional[str] = pydantic.Field(alias="field_Type", default=None)
    enum_values: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Display names for possible values the enum can take on.
    """

    enum_option_values: typing.Optional[typing.List[OptionValue]] = pydantic.Field(default=None)
    """
    Possible values the enum can take on. For providers which don't distinguish between ID and display name, the ID and display name should be set to the same value.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
