# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class VulnerabilityStateFilterValue(str, enum.Enum):
    """
    The normalized state identifier of a security finding
    """

    UNKNOWN = "Unknown"
    NEW = "New"
    IN_PROGRESS = "InProgress"
    RESOLVED = "Resolved"
    OTHER = "Other"

    def visit(
        self,
        unknown: typing.Callable[[], T_Result],
        new: typing.Callable[[], T_Result],
        in_progress: typing.Callable[[], T_Result],
        resolved: typing.Callable[[], T_Result],
        other: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is VulnerabilityStateFilterValue.UNKNOWN:
            return unknown()
        if self is VulnerabilityStateFilterValue.NEW:
            return new()
        if self is VulnerabilityStateFilterValue.IN_PROGRESS:
            return in_progress()
        if self is VulnerabilityStateFilterValue.RESOLVED:
            return resolved()
        if self is VulnerabilityStateFilterValue.OTHER:
            return other()
