# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...capabilities_base.types.category_id import CategoryId
from .additional_mapping_template import AdditionalMappingTemplate
from .integration_environments import IntegrationEnvironments
from .mapping_chain_template import MappingChainTemplate

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CreateIntegrationPointRequest(pydantic.BaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique short name for this Integration Point (lowercase [a-z0-9_-], can be used in URLs). Also used for case insensitive duplicate name detection and default sort order. Defaults to IntegrationPointId if both name and fullname are not specified.
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of integration point, will be shown to end-users in the Connect UI. Defaults to the same value as the 'name' field if not specified.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional description of the Integration Point. Will not be displayed to end-users of Connect UI.
    """

    connector: CategoryId = pydantic.Field()
    """
    Connector to use for the Integration Point.
    """

    environments: IntegrationEnvironments = pydantic.Field()
    """
    Selects providers to use for account environments.
    """

    mappings: typing.Optional[typing.List[MappingChainTemplate]] = pydantic.Field(default=None)
    """
    A list of mapping chains to apply to integrations using this integration point. Each mapping chain is a list of mappings to apply to the integration in the order they should be applied. Mappings are applied by operation ID. If an integration is created that declares its own mappings for an operation, they will override this list of mappings. Leave this empty to use the default default mappings.
    """

    additional_mappings: typing.Optional[typing.List[AdditionalMappingTemplate]] = pydantic.Field(default=None)
    """
    Additional data mappings for integrations added to this integration point. This allows for custom data to be mapped to the custom_fields portion of the response.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
