# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class WebhookEvent(str, enum.Enum):
    TICKET_CREATED = "TicketCreated"
    TICKET_UPDATED = "TicketUpdated"
    TICKET_DELETED = "TicketDeleted"
    TICKET_COMMENT_CREATED = "TicketCommentCreated"
    TICKET_COMMENT_DELETED = "TicketCommentDeleted"

    def visit(
        self,
        ticket_created: typing.Callable[[], T_Result],
        ticket_updated: typing.Callable[[], T_Result],
        ticket_deleted: typing.Callable[[], T_Result],
        ticket_comment_created: typing.Callable[[], T_Result],
        ticket_comment_deleted: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is WebhookEvent.TICKET_CREATED:
            return ticket_created()
        if self is WebhookEvent.TICKET_UPDATED:
            return ticket_updated()
        if self is WebhookEvent.TICKET_DELETED:
            return ticket_deleted()
        if self is WebhookEvent.TICKET_COMMENT_CREATED:
            return ticket_comment_created()
        if self is WebhookEvent.TICKET_COMMENT_DELETED:
            return ticket_comment_deleted()
