# Generated by Django 4.2.21 on 2025-06-14 18:39

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveuniverse", "0010_alter_eveindustryactivityduration_eve_type_and_more"),
        ("eveonline", "0017_alliance_and_corp_names_are_not_unique"),
        ("authentication", "0024_alter_userprofile_language"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("basic_access", "Can create snapshots and see own snapshots"),
                    (
                        "view_all",
                        "Can view all recorded fleets and snapshot other people fleets",
                    ),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="FleetCommander",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "character_ownership",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="authentication.characterownership",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="FleetSnapshot",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("fleet_id", models.BigIntegerField(help_text="EVE online fleet id")),
                (
                    "timestamp",
                    models.DateTimeField(
                        auto_now_add=True, help_text="Time of the snapshot"
                    ),
                ),
                (
                    "commander",
                    models.ForeignKey(
                        help_text="Fleet commander at the time of the snapshot",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="fleetcomp.fleetcommander",
                    ),
                ),
            ],
            options={
                "ordering": ["-timestamp"],
            },
        ),
        migrations.CreateModel(
            name="FleetMember",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "character",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveonline.evecharacter",
                    ),
                ),
                (
                    "fleet",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="members",
                        to="fleetcomp.fleetsnapshot",
                    ),
                ),
                (
                    "ship_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.evetype",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="CustomGrouping",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "display_name",
                    models.CharField(
                        help_text="Name of the grouping in the UI", max_length=50
                    ),
                ),
                (
                    "associated_groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Eve ship groups associated to this grouping",
                        to="eveuniverse.evegroup",
                    ),
                ),
                (
                    "associated_types",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Ship types associated to this grouping",
                        to="eveuniverse.evetype",
                    ),
                ),
            ],
        ),
    ]
