# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ..types.return_chat import ReturnChat
from ..types.return_chat_audio_reconstruction import ReturnChatAudioReconstruction
from ..types.return_chat_event import ReturnChatEvent
from .raw_client import AsyncRawChatsClient, RawChatsClient


class ChatsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawChatsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawChatsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawChatsClient
        """
        return self._raw_client

    def list_chats(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        config_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ReturnChat]:
        """
        Fetches a paginated list of **Chats**.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        config_id : typing.Optional[str]
            Filter to only include chats that used this config.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ReturnChat]
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        response = client.empathic_voice.chats.list_chats(
            page_number=0,
            page_size=1,
            ascending_order=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_chats(
            page_number=page_number,
            page_size=page_size,
            ascending_order=ascending_order,
            config_id=config_id,
            request_options=request_options,
        )

    def list_chat_events(
        self,
        id: str,
        *,
        page_size: typing.Optional[int] = None,
        page_number: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ReturnChatEvent]:
        """
        Fetches a paginated list of **Chat** events.

        Parameters
        ----------
        id : str
            Identifier for a Chat. Formatted as a UUID.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ReturnChatEvent]
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        response = client.empathic_voice.chats.list_chat_events(
            id="470a49f6-1dec-4afe-8b61-035d3b2d63b0",
            page_number=0,
            page_size=3,
            ascending_order=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_chat_events(
            id,
            page_size=page_size,
            page_number=page_number,
            ascending_order=ascending_order,
            request_options=request_options,
        )

    def get_audio(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReturnChatAudioReconstruction:
        """
        Fetches the audio of a previous **Chat**. For more details, see our guide on audio reconstruction [here](/docs/speech-to-speech-evi/faq#can-i-access-the-audio-of-previous-conversations-with-evi).

        Parameters
        ----------
        id : str
            Identifier for a chat. Formatted as a UUID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnChatAudioReconstruction
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.chats.get_audio(
            id="470a49f6-1dec-4afe-8b61-035d3b2d63b0",
        )
        """
        _response = self._raw_client.get_audio(id, request_options=request_options)
        return _response.data


class AsyncChatsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawChatsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawChatsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawChatsClient
        """
        return self._raw_client

    async def list_chats(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        config_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ReturnChat]:
        """
        Fetches a paginated list of **Chats**.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        config_id : typing.Optional[str]
            Filter to only include chats that used this config.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ReturnChat]
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.empathic_voice.chats.list_chats(
                page_number=0,
                page_size=1,
                ascending_order=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list_chats(
            page_number=page_number,
            page_size=page_size,
            ascending_order=ascending_order,
            config_id=config_id,
            request_options=request_options,
        )

    async def list_chat_events(
        self,
        id: str,
        *,
        page_size: typing.Optional[int] = None,
        page_number: typing.Optional[int] = None,
        ascending_order: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ReturnChatEvent]:
        """
        Fetches a paginated list of **Chat** events.

        Parameters
        ----------
        id : str
            Identifier for a Chat. Formatted as a UUID.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        ascending_order : typing.Optional[bool]
            Specifies the sorting order of the results based on their creation date. Set to true for ascending order (chronological, with the oldest records first) and false for descending order (reverse-chronological, with the newest records first). Defaults to true.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ReturnChatEvent]
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.empathic_voice.chats.list_chat_events(
                id="470a49f6-1dec-4afe-8b61-035d3b2d63b0",
                page_number=0,
                page_size=3,
                ascending_order=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list_chat_events(
            id,
            page_size=page_size,
            page_number=page_number,
            ascending_order=ascending_order,
            request_options=request_options,
        )

    async def get_audio(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReturnChatAudioReconstruction:
        """
        Fetches the audio of a previous **Chat**. For more details, see our guide on audio reconstruction [here](/docs/speech-to-speech-evi/faq#can-i-access-the-audio-of-previous-conversations-with-evi).

        Parameters
        ----------
        id : str
            Identifier for a chat. Formatted as a UUID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnChatAudioReconstruction
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.chats.get_audio(
                id="470a49f6-1dec-4afe-8b61-035d3b2d63b0",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_audio(id, request_options=request_options)
        return _response.data
