# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..types.error_response import ErrorResponse
from ..types.posted_builtin_tool import PostedBuiltinTool
from ..types.posted_config_prompt_spec import PostedConfigPromptSpec
from ..types.posted_ellm_model import PostedEllmModel
from ..types.posted_event_message_specs import PostedEventMessageSpecs
from ..types.posted_language_model import PostedLanguageModel
from ..types.posted_nudge_spec import PostedNudgeSpec
from ..types.posted_timeout_specs import PostedTimeoutSpecs
from ..types.posted_user_defined_tool_spec import PostedUserDefinedToolSpec
from ..types.posted_webhook_spec import PostedWebhookSpec
from ..types.return_config import ReturnConfig
from ..types.return_paged_configs import ReturnPagedConfigs
from ..types.voice_ref import VoiceRef

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawConfigsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_configs(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ReturnConfig]:
        """
        Fetches a paginated list of **Configs**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            By default, `restrict_to_most_recent` is set to true, returning only the latest version of each tool. To include all versions of each tool in the list, set `restrict_to_most_recent` to false.

        name : typing.Optional[str]
            Filter to only include configs with this name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ReturnConfig]
            Success
        """
        page_number = page_number if page_number is not None else 0

        _response = self._client_wrapper.httpx_client.request(
            "v0/evi/configs",
            method="GET",
            params={
                "page_number": page_number,
                "page_size": page_size,
                "restrict_to_most_recent": restrict_to_most_recent,
                "name": name,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ReturnPagedConfigs,
                    parse_obj_as(
                        type_=ReturnPagedConfigs,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.configs_page
                _has_next = True
                _get_next = lambda: self.list_configs(
                    page_number=page_number + 1,
                    page_size=page_size,
                    restrict_to_most_recent=restrict_to_most_recent,
                    name=name,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_config(
        self,
        *,
        evi_version: str,
        name: str,
        version_description: typing.Optional[str] = OMIT,
        prompt: typing.Optional[PostedConfigPromptSpec] = OMIT,
        voice: typing.Optional[VoiceRef] = OMIT,
        language_model: typing.Optional[PostedLanguageModel] = OMIT,
        ellm_model: typing.Optional[PostedEllmModel] = OMIT,
        tools: typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]] = OMIT,
        builtin_tools: typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]] = OMIT,
        event_messages: typing.Optional[PostedEventMessageSpecs] = OMIT,
        nudges: typing.Optional[PostedNudgeSpec] = OMIT,
        timeouts: typing.Optional[PostedTimeoutSpecs] = OMIT,
        webhooks: typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ReturnConfig]:
        """
        Creates a **Config** which can be applied to EVI.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        evi_version : str
            Specifies the EVI version to use. Use `"1"` for version 1, or `"2"` for the latest enhanced version. For a detailed comparison of the two versions, refer to our [guide](/docs/speech-to-speech-evi/configuration/evi-version).

        name : str
            Name applied to all versions of a particular Config.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        prompt : typing.Optional[PostedConfigPromptSpec]

        voice : typing.Optional[VoiceRef]
            A voice specification associated with this Config.

        language_model : typing.Optional[PostedLanguageModel]
            The supplemental language model associated with this Config.

            This model is used to generate longer, more detailed responses from EVI. Choosing an appropriate supplemental language model for your use case is crucial for generating fast, high-quality responses from EVI.

        ellm_model : typing.Optional[PostedEllmModel]
            The eLLM setup associated with this Config.

            Hume's eLLM (empathic Large Language Model) is a multimodal language model that takes into account both expression measures and language. The eLLM generates short, empathic language responses and guides text-to-speech (TTS) prosody.

        tools : typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]]
            List of user-defined tools associated with this Config.

        builtin_tools : typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]]
            List of built-in tools associated with this Config.

        event_messages : typing.Optional[PostedEventMessageSpecs]

        nudges : typing.Optional[PostedNudgeSpec]
            Configures nudges, brief audio prompts that can guide conversations when users pause or need encouragement to continue speaking. Nudges help create more natural, flowing interactions by providing gentle conversational cues.

        timeouts : typing.Optional[PostedTimeoutSpecs]

        webhooks : typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]]
            Webhook config specifications for each subscriber.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ReturnConfig]
            Created
        """
        _response = self._client_wrapper.httpx_client.request(
            "v0/evi/configs",
            method="POST",
            json={
                "evi_version": evi_version,
                "name": name,
                "version_description": version_description,
                "prompt": convert_and_respect_annotation_metadata(
                    object_=prompt, annotation=PostedConfigPromptSpec, direction="write"
                ),
                "voice": convert_and_respect_annotation_metadata(object_=voice, annotation=VoiceRef, direction="write"),
                "language_model": convert_and_respect_annotation_metadata(
                    object_=language_model, annotation=PostedLanguageModel, direction="write"
                ),
                "ellm_model": convert_and_respect_annotation_metadata(
                    object_=ellm_model, annotation=PostedEllmModel, direction="write"
                ),
                "tools": convert_and_respect_annotation_metadata(
                    object_=tools,
                    annotation=typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]],
                    direction="write",
                ),
                "builtin_tools": convert_and_respect_annotation_metadata(
                    object_=builtin_tools,
                    annotation=typing.Sequence[typing.Optional[PostedBuiltinTool]],
                    direction="write",
                ),
                "event_messages": convert_and_respect_annotation_metadata(
                    object_=event_messages, annotation=PostedEventMessageSpecs, direction="write"
                ),
                "nudges": convert_and_respect_annotation_metadata(
                    object_=nudges, annotation=PostedNudgeSpec, direction="write"
                ),
                "timeouts": convert_and_respect_annotation_metadata(
                    object_=timeouts, annotation=PostedTimeoutSpecs, direction="write"
                ),
                "webhooks": convert_and_respect_annotation_metadata(
                    object_=webhooks, annotation=typing.Sequence[typing.Optional[PostedWebhookSpec]], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReturnConfig,
                    parse_obj_as(
                        type_=ReturnConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_config_versions(
        self,
        id: str,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ReturnConfig]:
        """
        Fetches a list of a **Config's** versions.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            By default, `restrict_to_most_recent` is set to true, returning only the latest version of each config. To include all versions of each config in the list, set `restrict_to_most_recent` to false.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ReturnConfig]
            Success
        """
        page_number = page_number if page_number is not None else 0

        _response = self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}",
            method="GET",
            params={
                "page_number": page_number,
                "page_size": page_size,
                "restrict_to_most_recent": restrict_to_most_recent,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ReturnPagedConfigs,
                    parse_obj_as(
                        type_=ReturnPagedConfigs,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.configs_page
                _has_next = True
                _get_next = lambda: self.list_config_versions(
                    id,
                    page_number=page_number + 1,
                    page_size=page_size,
                    restrict_to_most_recent=restrict_to_most_recent,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_config_version(
        self,
        id: str,
        *,
        evi_version: str,
        version_description: typing.Optional[str] = OMIT,
        prompt: typing.Optional[PostedConfigPromptSpec] = OMIT,
        voice: typing.Optional[VoiceRef] = OMIT,
        language_model: typing.Optional[PostedLanguageModel] = OMIT,
        ellm_model: typing.Optional[PostedEllmModel] = OMIT,
        tools: typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]] = OMIT,
        builtin_tools: typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]] = OMIT,
        event_messages: typing.Optional[PostedEventMessageSpecs] = OMIT,
        timeouts: typing.Optional[PostedTimeoutSpecs] = OMIT,
        nudges: typing.Optional[PostedNudgeSpec] = OMIT,
        webhooks: typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ReturnConfig]:
        """
        Updates a **Config** by creating a new version of the **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        evi_version : str
            The version of the EVI used with this config.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        prompt : typing.Optional[PostedConfigPromptSpec]

        voice : typing.Optional[VoiceRef]
            A voice specification associated with this Config version.

        language_model : typing.Optional[PostedLanguageModel]
            The supplemental language model associated with this Config version.

            This model is used to generate longer, more detailed responses from EVI. Choosing an appropriate supplemental language model for your use case is crucial for generating fast, high-quality responses from EVI.

        ellm_model : typing.Optional[PostedEllmModel]
            The eLLM setup associated with this Config version.

            Hume's eLLM (empathic Large Language Model) is a multimodal language model that takes into account both expression measures and language. The eLLM generates short, empathic language responses and guides text-to-speech (TTS) prosody.

        tools : typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]]
            List of user-defined tools associated with this Config version.

        builtin_tools : typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]]
            List of built-in tools associated with this Config version.

        event_messages : typing.Optional[PostedEventMessageSpecs]

        timeouts : typing.Optional[PostedTimeoutSpecs]

        nudges : typing.Optional[PostedNudgeSpec]

        webhooks : typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]]
            Webhook config specifications for each subscriber.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ReturnConfig]
            Created
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}",
            method="POST",
            json={
                "evi_version": evi_version,
                "version_description": version_description,
                "prompt": convert_and_respect_annotation_metadata(
                    object_=prompt, annotation=PostedConfigPromptSpec, direction="write"
                ),
                "voice": convert_and_respect_annotation_metadata(object_=voice, annotation=VoiceRef, direction="write"),
                "language_model": convert_and_respect_annotation_metadata(
                    object_=language_model, annotation=PostedLanguageModel, direction="write"
                ),
                "ellm_model": convert_and_respect_annotation_metadata(
                    object_=ellm_model, annotation=PostedEllmModel, direction="write"
                ),
                "tools": convert_and_respect_annotation_metadata(
                    object_=tools,
                    annotation=typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]],
                    direction="write",
                ),
                "builtin_tools": convert_and_respect_annotation_metadata(
                    object_=builtin_tools,
                    annotation=typing.Sequence[typing.Optional[PostedBuiltinTool]],
                    direction="write",
                ),
                "event_messages": convert_and_respect_annotation_metadata(
                    object_=event_messages, annotation=PostedEventMessageSpecs, direction="write"
                ),
                "timeouts": convert_and_respect_annotation_metadata(
                    object_=timeouts, annotation=PostedTimeoutSpecs, direction="write"
                ),
                "nudges": convert_and_respect_annotation_metadata(
                    object_=nudges, annotation=PostedNudgeSpec, direction="write"
                ),
                "webhooks": convert_and_respect_annotation_metadata(
                    object_=webhooks, annotation=typing.Sequence[typing.Optional[PostedWebhookSpec]], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReturnConfig,
                    parse_obj_as(
                        type_=ReturnConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_config(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Deletes a **Config** and its versions.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_config_name(
        self, id: str, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[str]:
        """
        Updates the name of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        name : str
            Name applied to all versions of a particular Config.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[str]
            Success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=_response.text)  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_config_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ReturnConfig]:
        """
        Fetches a specified version of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ReturnConfig]
            Success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}/version/{jsonable_encoder(version)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReturnConfig,
                    parse_obj_as(
                        type_=ReturnConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_config_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Deletes a specified version of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}/version/{jsonable_encoder(version)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_config_description(
        self,
        id: str,
        version: int,
        *,
        version_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ReturnConfig]:
        """
        Updates the description of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ReturnConfig]
            Success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}/version/{jsonable_encoder(version)}",
            method="PATCH",
            json={
                "version_description": version_description,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReturnConfig,
                    parse_obj_as(
                        type_=ReturnConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawConfigsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_configs(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ReturnConfig]:
        """
        Fetches a paginated list of **Configs**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            By default, `restrict_to_most_recent` is set to true, returning only the latest version of each tool. To include all versions of each tool in the list, set `restrict_to_most_recent` to false.

        name : typing.Optional[str]
            Filter to only include configs with this name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ReturnConfig]
            Success
        """
        page_number = page_number if page_number is not None else 0

        _response = await self._client_wrapper.httpx_client.request(
            "v0/evi/configs",
            method="GET",
            params={
                "page_number": page_number,
                "page_size": page_size,
                "restrict_to_most_recent": restrict_to_most_recent,
                "name": name,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ReturnPagedConfigs,
                    parse_obj_as(
                        type_=ReturnPagedConfigs,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.configs_page
                _has_next = True

                async def _get_next():
                    return await self.list_configs(
                        page_number=page_number + 1,
                        page_size=page_size,
                        restrict_to_most_recent=restrict_to_most_recent,
                        name=name,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_config(
        self,
        *,
        evi_version: str,
        name: str,
        version_description: typing.Optional[str] = OMIT,
        prompt: typing.Optional[PostedConfigPromptSpec] = OMIT,
        voice: typing.Optional[VoiceRef] = OMIT,
        language_model: typing.Optional[PostedLanguageModel] = OMIT,
        ellm_model: typing.Optional[PostedEllmModel] = OMIT,
        tools: typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]] = OMIT,
        builtin_tools: typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]] = OMIT,
        event_messages: typing.Optional[PostedEventMessageSpecs] = OMIT,
        nudges: typing.Optional[PostedNudgeSpec] = OMIT,
        timeouts: typing.Optional[PostedTimeoutSpecs] = OMIT,
        webhooks: typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ReturnConfig]:
        """
        Creates a **Config** which can be applied to EVI.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        evi_version : str
            Specifies the EVI version to use. Use `"1"` for version 1, or `"2"` for the latest enhanced version. For a detailed comparison of the two versions, refer to our [guide](/docs/speech-to-speech-evi/configuration/evi-version).

        name : str
            Name applied to all versions of a particular Config.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        prompt : typing.Optional[PostedConfigPromptSpec]

        voice : typing.Optional[VoiceRef]
            A voice specification associated with this Config.

        language_model : typing.Optional[PostedLanguageModel]
            The supplemental language model associated with this Config.

            This model is used to generate longer, more detailed responses from EVI. Choosing an appropriate supplemental language model for your use case is crucial for generating fast, high-quality responses from EVI.

        ellm_model : typing.Optional[PostedEllmModel]
            The eLLM setup associated with this Config.

            Hume's eLLM (empathic Large Language Model) is a multimodal language model that takes into account both expression measures and language. The eLLM generates short, empathic language responses and guides text-to-speech (TTS) prosody.

        tools : typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]]
            List of user-defined tools associated with this Config.

        builtin_tools : typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]]
            List of built-in tools associated with this Config.

        event_messages : typing.Optional[PostedEventMessageSpecs]

        nudges : typing.Optional[PostedNudgeSpec]
            Configures nudges, brief audio prompts that can guide conversations when users pause or need encouragement to continue speaking. Nudges help create more natural, flowing interactions by providing gentle conversational cues.

        timeouts : typing.Optional[PostedTimeoutSpecs]

        webhooks : typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]]
            Webhook config specifications for each subscriber.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ReturnConfig]
            Created
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v0/evi/configs",
            method="POST",
            json={
                "evi_version": evi_version,
                "name": name,
                "version_description": version_description,
                "prompt": convert_and_respect_annotation_metadata(
                    object_=prompt, annotation=PostedConfigPromptSpec, direction="write"
                ),
                "voice": convert_and_respect_annotation_metadata(object_=voice, annotation=VoiceRef, direction="write"),
                "language_model": convert_and_respect_annotation_metadata(
                    object_=language_model, annotation=PostedLanguageModel, direction="write"
                ),
                "ellm_model": convert_and_respect_annotation_metadata(
                    object_=ellm_model, annotation=PostedEllmModel, direction="write"
                ),
                "tools": convert_and_respect_annotation_metadata(
                    object_=tools,
                    annotation=typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]],
                    direction="write",
                ),
                "builtin_tools": convert_and_respect_annotation_metadata(
                    object_=builtin_tools,
                    annotation=typing.Sequence[typing.Optional[PostedBuiltinTool]],
                    direction="write",
                ),
                "event_messages": convert_and_respect_annotation_metadata(
                    object_=event_messages, annotation=PostedEventMessageSpecs, direction="write"
                ),
                "nudges": convert_and_respect_annotation_metadata(
                    object_=nudges, annotation=PostedNudgeSpec, direction="write"
                ),
                "timeouts": convert_and_respect_annotation_metadata(
                    object_=timeouts, annotation=PostedTimeoutSpecs, direction="write"
                ),
                "webhooks": convert_and_respect_annotation_metadata(
                    object_=webhooks, annotation=typing.Sequence[typing.Optional[PostedWebhookSpec]], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReturnConfig,
                    parse_obj_as(
                        type_=ReturnConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_config_versions(
        self,
        id: str,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ReturnConfig]:
        """
        Fetches a list of a **Config's** versions.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            By default, `restrict_to_most_recent` is set to true, returning only the latest version of each config. To include all versions of each config in the list, set `restrict_to_most_recent` to false.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ReturnConfig]
            Success
        """
        page_number = page_number if page_number is not None else 0

        _response = await self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}",
            method="GET",
            params={
                "page_number": page_number,
                "page_size": page_size,
                "restrict_to_most_recent": restrict_to_most_recent,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ReturnPagedConfigs,
                    parse_obj_as(
                        type_=ReturnPagedConfigs,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.configs_page
                _has_next = True

                async def _get_next():
                    return await self.list_config_versions(
                        id,
                        page_number=page_number + 1,
                        page_size=page_size,
                        restrict_to_most_recent=restrict_to_most_recent,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_config_version(
        self,
        id: str,
        *,
        evi_version: str,
        version_description: typing.Optional[str] = OMIT,
        prompt: typing.Optional[PostedConfigPromptSpec] = OMIT,
        voice: typing.Optional[VoiceRef] = OMIT,
        language_model: typing.Optional[PostedLanguageModel] = OMIT,
        ellm_model: typing.Optional[PostedEllmModel] = OMIT,
        tools: typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]] = OMIT,
        builtin_tools: typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]] = OMIT,
        event_messages: typing.Optional[PostedEventMessageSpecs] = OMIT,
        timeouts: typing.Optional[PostedTimeoutSpecs] = OMIT,
        nudges: typing.Optional[PostedNudgeSpec] = OMIT,
        webhooks: typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ReturnConfig]:
        """
        Updates a **Config** by creating a new version of the **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        evi_version : str
            The version of the EVI used with this config.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        prompt : typing.Optional[PostedConfigPromptSpec]

        voice : typing.Optional[VoiceRef]
            A voice specification associated with this Config version.

        language_model : typing.Optional[PostedLanguageModel]
            The supplemental language model associated with this Config version.

            This model is used to generate longer, more detailed responses from EVI. Choosing an appropriate supplemental language model for your use case is crucial for generating fast, high-quality responses from EVI.

        ellm_model : typing.Optional[PostedEllmModel]
            The eLLM setup associated with this Config version.

            Hume's eLLM (empathic Large Language Model) is a multimodal language model that takes into account both expression measures and language. The eLLM generates short, empathic language responses and guides text-to-speech (TTS) prosody.

        tools : typing.Optional[typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]]]
            List of user-defined tools associated with this Config version.

        builtin_tools : typing.Optional[typing.Sequence[typing.Optional[PostedBuiltinTool]]]
            List of built-in tools associated with this Config version.

        event_messages : typing.Optional[PostedEventMessageSpecs]

        timeouts : typing.Optional[PostedTimeoutSpecs]

        nudges : typing.Optional[PostedNudgeSpec]

        webhooks : typing.Optional[typing.Sequence[typing.Optional[PostedWebhookSpec]]]
            Webhook config specifications for each subscriber.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ReturnConfig]
            Created
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}",
            method="POST",
            json={
                "evi_version": evi_version,
                "version_description": version_description,
                "prompt": convert_and_respect_annotation_metadata(
                    object_=prompt, annotation=PostedConfigPromptSpec, direction="write"
                ),
                "voice": convert_and_respect_annotation_metadata(object_=voice, annotation=VoiceRef, direction="write"),
                "language_model": convert_and_respect_annotation_metadata(
                    object_=language_model, annotation=PostedLanguageModel, direction="write"
                ),
                "ellm_model": convert_and_respect_annotation_metadata(
                    object_=ellm_model, annotation=PostedEllmModel, direction="write"
                ),
                "tools": convert_and_respect_annotation_metadata(
                    object_=tools,
                    annotation=typing.Sequence[typing.Optional[PostedUserDefinedToolSpec]],
                    direction="write",
                ),
                "builtin_tools": convert_and_respect_annotation_metadata(
                    object_=builtin_tools,
                    annotation=typing.Sequence[typing.Optional[PostedBuiltinTool]],
                    direction="write",
                ),
                "event_messages": convert_and_respect_annotation_metadata(
                    object_=event_messages, annotation=PostedEventMessageSpecs, direction="write"
                ),
                "timeouts": convert_and_respect_annotation_metadata(
                    object_=timeouts, annotation=PostedTimeoutSpecs, direction="write"
                ),
                "nudges": convert_and_respect_annotation_metadata(
                    object_=nudges, annotation=PostedNudgeSpec, direction="write"
                ),
                "webhooks": convert_and_respect_annotation_metadata(
                    object_=webhooks, annotation=typing.Sequence[typing.Optional[PostedWebhookSpec]], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReturnConfig,
                    parse_obj_as(
                        type_=ReturnConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_config(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Deletes a **Config** and its versions.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_config_name(
        self, id: str, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[str]:
        """
        Updates the name of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        name : str
            Name applied to all versions of a particular Config.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[str]
            Success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=_response.text)  # type: ignore
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_config_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ReturnConfig]:
        """
        Fetches a specified version of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ReturnConfig]
            Success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}/version/{jsonable_encoder(version)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReturnConfig,
                    parse_obj_as(
                        type_=ReturnConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_config_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Deletes a specified version of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}/version/{jsonable_encoder(version)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_config_description(
        self,
        id: str,
        version: int,
        *,
        version_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ReturnConfig]:
        """
        Updates the description of a **Config**.

        For more details on configuration options and how to configure EVI, see our [configuration guide](/docs/speech-to-speech-evi/configuration).

        Parameters
        ----------
        id : str
            Identifier for a Config. Formatted as a UUID.

        version : int
            Version number for a Config.

            Configs, Prompts, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine configurations and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Config. Each update to the Config increments its version number.

        version_description : typing.Optional[str]
            An optional description of the Config version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ReturnConfig]
            Success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/evi/configs/{jsonable_encoder(id)}/version/{jsonable_encoder(version)}",
            method="PATCH",
            json={
                "version_description": version_description,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReturnConfig,
                    parse_obj_as(
                        type_=ReturnConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
