# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ..types.return_paged_prompts import ReturnPagedPrompts
from ..types.return_prompt import ReturnPrompt
from .raw_client import AsyncRawPromptsClient, RawPromptsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PromptsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPromptsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPromptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPromptsClient
        """
        return self._raw_client

    def list_prompts(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[typing.Optional[ReturnPrompt]]:
        """
        Fetches a paginated list of **Prompts**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            Only include the most recent version of each prompt in the list.

        name : typing.Optional[str]
            Filter to only include prompts with name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[typing.Optional[ReturnPrompt]]
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        response = client.empathic_voice.prompts.list_prompts(
            page_number=0,
            page_size=2,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list_prompts(
            page_number=page_number,
            page_size=page_size,
            restrict_to_most_recent=restrict_to_most_recent,
            name=name,
            request_options=request_options,
        )

    def create_prompt(
        self,
        *,
        name: str,
        text: str,
        version_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[ReturnPrompt]:
        """
        Creates a **Prompt** that can be added to an [EVI configuration](/reference/speech-to-speech-evi/configs/create-config).

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        name : str
            Name applied to all versions of a particular Prompt.

        text : str
            Instructions used to shape EVI’s behavior, responses, and style.

            You can use the Prompt to define a specific goal or role for EVI, specifying how it should act or what it should focus on during the conversation. For example, EVI can be instructed to act as a customer support representative, a fitness coach, or a travel advisor, each with its own set of behaviors and response styles.

            For help writing a system prompt, see our [Prompting Guide](/docs/speech-to-speech-evi/guides/prompting).

        version_description : typing.Optional[str]
            An optional description of the Prompt version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[ReturnPrompt]
            Created

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.prompts.create_prompt(
            name="Weather Assistant Prompt",
            text="<role>You are an AI weather assistant providing users with accurate and up-to-date weather information. Respond to user queries concisely and clearly. Use simple language and avoid technical jargon. Provide temperature, precipitation, wind conditions, and any weather alerts. Include helpful tips if severe weather is expected.</role>",
        )
        """
        _response = self._raw_client.create_prompt(
            name=name, text=text, version_description=version_description, request_options=request_options
        )
        return _response.data

    def list_prompt_versions(
        self,
        id: str,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnPagedPrompts:
        """
        Fetches a list of a **Prompt's** versions.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            By default, `restrict_to_most_recent` is set to true, returning only the latest version of each prompt. To include all versions of each prompt in the list, set `restrict_to_most_recent` to false.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnPagedPrompts
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.prompts.list_prompt_versions(
            id="af699d45-2985-42cc-91b9-af9e5da3bac5",
        )
        """
        _response = self._raw_client.list_prompt_versions(
            id,
            page_number=page_number,
            page_size=page_size,
            restrict_to_most_recent=restrict_to_most_recent,
            request_options=request_options,
        )
        return _response.data

    def create_prompt_version(
        self,
        id: str,
        *,
        text: str,
        version_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[ReturnPrompt]:
        """
        Updates a **Prompt** by creating a new version of the **Prompt**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        text : str
            Instructions used to shape EVI’s behavior, responses, and style for this version of the Prompt.

            You can use the Prompt to define a specific goal or role for EVI, specifying how it should act or what it should focus on during the conversation. For example, EVI can be instructed to act as a customer support representative, a fitness coach, or a travel advisor, each with its own set of behaviors and response styles.

            For help writing a system prompt, see our [Prompting Guide](/docs/speech-to-speech-evi/guides/prompting).

        version_description : typing.Optional[str]
            An optional description of the Prompt version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[ReturnPrompt]
            Created

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.prompts.create_prompt_version(
            id="af699d45-2985-42cc-91b9-af9e5da3bac5",
            text="<role>You are an updated version of an AI weather assistant providing users with accurate and up-to-date weather information. Respond to user queries concisely and clearly. Use simple language and avoid technical jargon. Provide temperature, precipitation, wind conditions, and any weather alerts. Include helpful tips if severe weather is expected.</role>",
            version_description="This is an updated version of the Weather Assistant Prompt.",
        )
        """
        _response = self._raw_client.create_prompt_version(
            id, text=text, version_description=version_description, request_options=request_options
        )
        return _response.data

    def delete_prompt(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a **Prompt** and its versions.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.prompts.delete_prompt(
            id="af699d45-2985-42cc-91b9-af9e5da3bac5",
        )
        """
        _response = self._raw_client.delete_prompt(id, request_options=request_options)
        return _response.data

    def update_prompt_name(self, id: str, *, name: str, request_options: typing.Optional[RequestOptions] = None) -> str:
        """
        Updates the name of a **Prompt**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        name : str
            Name applied to all versions of a particular Prompt.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.prompts.update_prompt_name(
            id="af699d45-2985-42cc-91b9-af9e5da3bac5",
            name="Updated Weather Assistant Prompt Name",
        )
        """
        _response = self._raw_client.update_prompt_name(id, name=name, request_options=request_options)
        return _response.data

    def get_prompt_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[ReturnPrompt]:
        """
        Fetches a specified version of a **Prompt**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        version : int
            Version number for a Prompt.

            Prompts, Configs, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine prompts and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Prompt. Each update to the Prompt increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[ReturnPrompt]
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.prompts.get_prompt_version(
            id="af699d45-2985-42cc-91b9-af9e5da3bac5",
            version=0,
        )
        """
        _response = self._raw_client.get_prompt_version(id, version, request_options=request_options)
        return _response.data

    def delete_prompt_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes a specified version of a **Prompt**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        version : int
            Version number for a Prompt.

            Prompts, Configs, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine prompts and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Prompt. Each update to the Prompt increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.prompts.delete_prompt_version(
            id="af699d45-2985-42cc-91b9-af9e5da3bac5",
            version=1,
        )
        """
        _response = self._raw_client.delete_prompt_version(id, version, request_options=request_options)
        return _response.data

    def update_prompt_description(
        self,
        id: str,
        version: int,
        *,
        version_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[ReturnPrompt]:
        """
        Updates the description of a **Prompt**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        version : int
            Version number for a Prompt.

            Prompts, Configs, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine prompts and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Prompt. Each update to the Prompt increments its version number.

        version_description : typing.Optional[str]
            An optional description of the Prompt version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[ReturnPrompt]
            Success

        Examples
        --------
        from hume import HumeClient

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.empathic_voice.prompts.update_prompt_description(
            id="af699d45-2985-42cc-91b9-af9e5da3bac5",
            version=1,
            version_description="This is an updated version_description.",
        )
        """
        _response = self._raw_client.update_prompt_description(
            id, version, version_description=version_description, request_options=request_options
        )
        return _response.data


class AsyncPromptsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPromptsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPromptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPromptsClient
        """
        return self._raw_client

    async def list_prompts(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        name: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[typing.Optional[ReturnPrompt]]:
        """
        Fetches a paginated list of **Prompts**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            Only include the most recent version of each prompt in the list.

        name : typing.Optional[str]
            Filter to only include prompts with name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[typing.Optional[ReturnPrompt]]
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.empathic_voice.prompts.list_prompts(
                page_number=0,
                page_size=2,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list_prompts(
            page_number=page_number,
            page_size=page_size,
            restrict_to_most_recent=restrict_to_most_recent,
            name=name,
            request_options=request_options,
        )

    async def create_prompt(
        self,
        *,
        name: str,
        text: str,
        version_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[ReturnPrompt]:
        """
        Creates a **Prompt** that can be added to an [EVI configuration](/reference/speech-to-speech-evi/configs/create-config).

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        name : str
            Name applied to all versions of a particular Prompt.

        text : str
            Instructions used to shape EVI’s behavior, responses, and style.

            You can use the Prompt to define a specific goal or role for EVI, specifying how it should act or what it should focus on during the conversation. For example, EVI can be instructed to act as a customer support representative, a fitness coach, or a travel advisor, each with its own set of behaviors and response styles.

            For help writing a system prompt, see our [Prompting Guide](/docs/speech-to-speech-evi/guides/prompting).

        version_description : typing.Optional[str]
            An optional description of the Prompt version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[ReturnPrompt]
            Created

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.prompts.create_prompt(
                name="Weather Assistant Prompt",
                text="<role>You are an AI weather assistant providing users with accurate and up-to-date weather information. Respond to user queries concisely and clearly. Use simple language and avoid technical jargon. Provide temperature, precipitation, wind conditions, and any weather alerts. Include helpful tips if severe weather is expected.</role>",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_prompt(
            name=name, text=text, version_description=version_description, request_options=request_options
        )
        return _response.data

    async def list_prompt_versions(
        self,
        id: str,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        restrict_to_most_recent: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnPagedPrompts:
        """
        Fetches a list of a **Prompt's** versions.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        page_number : typing.Optional[int]
            Specifies the page number to retrieve, enabling pagination.

            This parameter uses zero-based indexing. For example, setting `page_number` to 0 retrieves the first page of results (items 0-9 if `page_size` is 10), setting `page_number` to 1 retrieves the second page (items 10-19), and so on. Defaults to 0, which retrieves the first page.

        page_size : typing.Optional[int]
            Specifies the maximum number of results to include per page, enabling pagination. The value must be between 1 and 100, inclusive.

            For example, if `page_size` is set to 10, each page will include up to 10 items. Defaults to 10.

        restrict_to_most_recent : typing.Optional[bool]
            By default, `restrict_to_most_recent` is set to true, returning only the latest version of each prompt. To include all versions of each prompt in the list, set `restrict_to_most_recent` to false.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnPagedPrompts
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.prompts.list_prompt_versions(
                id="af699d45-2985-42cc-91b9-af9e5da3bac5",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_prompt_versions(
            id,
            page_number=page_number,
            page_size=page_size,
            restrict_to_most_recent=restrict_to_most_recent,
            request_options=request_options,
        )
        return _response.data

    async def create_prompt_version(
        self,
        id: str,
        *,
        text: str,
        version_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[ReturnPrompt]:
        """
        Updates a **Prompt** by creating a new version of the **Prompt**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        text : str
            Instructions used to shape EVI’s behavior, responses, and style for this version of the Prompt.

            You can use the Prompt to define a specific goal or role for EVI, specifying how it should act or what it should focus on during the conversation. For example, EVI can be instructed to act as a customer support representative, a fitness coach, or a travel advisor, each with its own set of behaviors and response styles.

            For help writing a system prompt, see our [Prompting Guide](/docs/speech-to-speech-evi/guides/prompting).

        version_description : typing.Optional[str]
            An optional description of the Prompt version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[ReturnPrompt]
            Created

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.prompts.create_prompt_version(
                id="af699d45-2985-42cc-91b9-af9e5da3bac5",
                text="<role>You are an updated version of an AI weather assistant providing users with accurate and up-to-date weather information. Respond to user queries concisely and clearly. Use simple language and avoid technical jargon. Provide temperature, precipitation, wind conditions, and any weather alerts. Include helpful tips if severe weather is expected.</role>",
                version_description="This is an updated version of the Weather Assistant Prompt.",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_prompt_version(
            id, text=text, version_description=version_description, request_options=request_options
        )
        return _response.data

    async def delete_prompt(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a **Prompt** and its versions.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.prompts.delete_prompt(
                id="af699d45-2985-42cc-91b9-af9e5da3bac5",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_prompt(id, request_options=request_options)
        return _response.data

    async def update_prompt_name(
        self, id: str, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> str:
        """
        Updates the name of a **Prompt**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        name : str
            Name applied to all versions of a particular Prompt.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.prompts.update_prompt_name(
                id="af699d45-2985-42cc-91b9-af9e5da3bac5",
                name="Updated Weather Assistant Prompt Name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_prompt_name(id, name=name, request_options=request_options)
        return _response.data

    async def get_prompt_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[ReturnPrompt]:
        """
        Fetches a specified version of a **Prompt**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        version : int
            Version number for a Prompt.

            Prompts, Configs, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine prompts and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Prompt. Each update to the Prompt increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[ReturnPrompt]
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.prompts.get_prompt_version(
                id="af699d45-2985-42cc-91b9-af9e5da3bac5",
                version=0,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_prompt_version(id, version, request_options=request_options)
        return _response.data

    async def delete_prompt_version(
        self, id: str, version: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes a specified version of a **Prompt**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        version : int
            Version number for a Prompt.

            Prompts, Configs, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine prompts and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Prompt. Each update to the Prompt increments its version number.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.prompts.delete_prompt_version(
                id="af699d45-2985-42cc-91b9-af9e5da3bac5",
                version=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_prompt_version(id, version, request_options=request_options)
        return _response.data

    async def update_prompt_description(
        self,
        id: str,
        version: int,
        *,
        version_description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[ReturnPrompt]:
        """
        Updates the description of a **Prompt**.

        See our [prompting guide](/docs/speech-to-speech-evi/guides/phone-calling) for tips on crafting your system prompt.

        Parameters
        ----------
        id : str
            Identifier for a Prompt. Formatted as a UUID.

        version : int
            Version number for a Prompt.

            Prompts, Configs, Custom Voices, and Tools are versioned. This versioning system supports iterative development, allowing you to progressively refine prompts and revert to previous versions if needed.

            Version numbers are integer values representing different iterations of the Prompt. Each update to the Prompt increments its version number.

        version_description : typing.Optional[str]
            An optional description of the Prompt version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[ReturnPrompt]
            Success

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.empathic_voice.prompts.update_prompt_description(
                id="af699d45-2985-42cc-91b9-af9e5da3bac5",
                version=1,
                version_description="This is an updated version_description.",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_prompt_description(
            id, version, version_description=version_description, request_options=request_options
        )
        return _response.data
