# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .chat_message_tool_result import ChatMessageToolResult
from .role import Role
from .tool_call_message import ToolCallMessage


class ChatMessage(UniversalBaseModel):
    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Transcript of the message.
    """

    role: Role = pydantic.Field()
    """
    Role of who is providing the message.
    """

    tool_call: typing.Optional[ToolCallMessage] = pydantic.Field(default=None)
    """
    Function call name and arguments.
    """

    tool_result: typing.Optional[ChatMessageToolResult] = pydantic.Field(default=None)
    """
    Function call response from client.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
