# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .return_config import ReturnConfig


class ReturnPagedConfigs(UniversalBaseModel):
    """
    A paginated list of config versions returned from the server
    """

    page_number: typing.Optional[int] = pydantic.Field(default=None)
    """
    The page number of the returned list.
    
    This value corresponds to the `page_number` parameter specified in the request. Pagination uses zero-based indexing.
    """

    page_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum number of items returned per page.
    
    This value corresponds to the `page_size` parameter specified in the request.
    """

    total_pages: int = pydantic.Field()
    """
    The total number of pages in the collection.
    """

    configs_page: typing.Optional[typing.List[ReturnConfig]] = pydantic.Field(default=None)
    """
    List of configs returned for the specified `page_number` and `page_size`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
