# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .tool_type import ToolType


class Tool(UniversalBaseModel):
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    An optional description of what the tool does, used by the supplemental LLM to choose when and how to call the function.
    """

    fallback_content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional text passed to the supplemental LLM if the tool call fails. The LLM then uses this text to generate a response back to the user, ensuring continuity in the conversation.
    """

    name: str = pydantic.Field()
    """
    Name of the user-defined tool to be enabled.
    """

    parameters: str = pydantic.Field()
    """
    Parameters of the tool. Is a stringified JSON schema.
    
    These parameters define the inputs needed for the tool’s execution, including the expected data type and description for each input field. Structured as a JSON schema, this format ensures the tool receives data in the expected format.
    """

    type: ToolType = pydantic.Field()
    """
    Type of tool. Set to `function` for user-defined tools.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
