# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .tool_type import ToolType


class ToolResponseMessage(UniversalBaseModel):
    """
    When provided, the output is a function call response.
    """

    content: str = pydantic.Field()
    """
    Return value of the tool call. Contains the output generated by the tool to pass back to EVI.
    """

    custom_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Used to manage conversational state, correlate frontend and backend data, and persist conversations across EVI sessions.
    """

    tool_call_id: str = pydantic.Field()
    """
    The unique identifier for a specific tool call instance.
    
    This ID is used to track the request and response of a particular tool invocation, ensuring that the correct response is linked to the appropriate request. The specified `tool_call_id` must match the one received in the [Tool Call message](/reference/empathic-voice-interface-evi/chat/chat#receive.ToolCallMessage.tool_call_id).
    """

    tool_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the tool.
    
    Include this optional field to help the supplemental LLM identify which tool generated the response. The specified `tool_name` must match the one received in the [Tool Call message](/reference/empathic-voice-interface-evi/chat/chat#receive.ToolCallMessage.type).
    """

    tool_type: typing.Optional[ToolType] = pydantic.Field(default=None)
    """
    Type of tool called. Either `builtin` for natively implemented tools, like web search, or `function` for user-defined tools.
    """

    type: typing.Literal["tool_response"] = pydantic.Field(default="tool_response")
    """
    The type of message sent through the socket; for a Tool Response message, this must be `tool_response`.
    
    Upon receiving a [Tool Call message](/reference/empathic-voice-interface-evi/chat/chat#receive.ToolCallMessage.type) and successfully invoking the function, this message is sent to convey the result of the function call back to EVI.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
