# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class UserInput(UniversalBaseModel):
    """
    User text to insert into the conversation. Text sent through a User Input message is treated as the user's speech to EVI. EVI processes this input and provides a corresponding response.

    Expression measurement results are not available for User Input messages, as the prosody model relies on audio input and cannot process text alone.
    """

    custom_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Used to manage conversational state, correlate frontend and backend data, and persist conversations across EVI sessions.
    """

    text: str = pydantic.Field()
    """
    User text to insert into the conversation. Text sent through a User Input message is treated as the user’s speech to EVI. EVI processes this input and provides a corresponding response.
    
    Expression measurement results are not available for User Input messages, as the prosody model relies on audio input and cannot process text alone.
    """

    type: typing.Literal["user_input"] = pydantic.Field(default="user_input")
    """
    The type of message sent through the socket; must be `user_input` for our server to correctly identify and process it as a User Input message.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
