# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class WebSocketError(UniversalBaseModel):
    """
    When provided, the output is an error message.
    """

    code: str = pydantic.Field()
    """
    Error code. Identifies the type of error encountered.
    """

    custom_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Used to manage conversational state, correlate frontend and backend data, and persist conversations across EVI sessions.
    """

    message: str = pydantic.Field()
    """
    Detailed description of the error.
    """

    request_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the initiating request.
    """

    slug: str = pydantic.Field()
    """
    Short, human-readable identifier and description for the error. See a complete list of error slugs on the [Errors page](/docs/resources/errors).
    """

    type: typing.Literal["error"] = pydantic.Field(default="error")
    """
    The type of message sent through the socket; for a Web Socket Error message, this must be `error`.
    
    This message indicates a disruption in the WebSocket connection, such as an unexpected disconnection, protocol error, or data transmission issue.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
