# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from .webhook_event_base import WebhookEventBase
from .webhook_event_chat_start_type import WebhookEventChatStartType


class WebhookEventChatStarted(WebhookEventBase):
    caller_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Phone number of the caller in E.164 format (e.g., `+12223333333`). This field is included only if the Chat was created via the [Twilio phone calling](/docs/empathic-voice-interface-evi/phone-calling) integration.
    """

    chat_start_type: WebhookEventChatStartType = pydantic.Field()
    """
    Indicates whether the chat is the first in a new Chat Group (`new_chat_group`) or the continuation of an existing chat group (`resumed_chat_group`).
    """

    custom_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    User-defined session ID. Relevant only when employing a [custom language model](/docs/empathic-voice-interface-evi/custom-language-model) in the EVI Config.
    """

    event_name: typing.Optional[typing.Literal["chat_started"]] = pydantic.Field(default=None)
    """
    Always `chat_started`.
    """

    start_time: int = pydantic.Field()
    """
    Unix timestamp (in milliseconds) indicating when the session started.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
