# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .emotion_score import EmotionScore
from .position_interval import PositionInterval
from .sentiment_score import SentimentScore
from .time_interval import TimeInterval
from .toxicity_score import ToxicityScore


class LanguagePrediction(UniversalBaseModel):
    text: str = pydantic.Field()
    """
    A segment of text (like a word or a sentence).
    """

    position: PositionInterval
    time: typing.Optional[TimeInterval] = None
    confidence: typing.Optional[float] = pydantic.Field(default=None)
    """
    Value between `0.0` and `1.0` that indicates our transcription model's relative confidence in this text.
    """

    speaker_confidence: typing.Optional[float] = pydantic.Field(default=None)
    """
    Value between `0.0` and `1.0` that indicates our transcription model's relative confidence that this text was spoken by this speaker.
    """

    emotions: typing.List[EmotionScore] = pydantic.Field()
    """
    A high-dimensional embedding in emotion space.
    """

    sentiment: typing.Optional[typing.List[SentimentScore]] = pydantic.Field(default=None)
    """
    Sentiment predictions returned as a distribution. This model predicts the probability that a given text could be interpreted as having each sentiment level from `1` (negative) to `9` (positive).
    
    Compared to returning one estimate of sentiment, this enables a more nuanced analysis of a text's meaning. For example, a text with very neutral sentiment would have an average rating of `5`. But also a text that could be interpreted as having very positive sentiment or very negative sentiment would also have an average rating of `5`. The average sentiment is less informative than the distribution over sentiment, so this API returns a value for each sentiment level.
    """

    toxicity: typing.Optional[typing.List[ToxicityScore]] = pydantic.Field(default=None)
    """
    Toxicity predictions returned as probabilities that the text can be classified into the following categories: `toxic`, `severe_toxic`, `obscene`, `threat`, `insult`, and `identity_hate`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
