# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawTtsClient, RawTtsClient
from .types.format import Format
from .types.posted_context import PostedContext
from .types.posted_utterance import PostedUtterance
from .types.return_tts import ReturnTts
from .types.snippet_audio_chunk import SnippetAudioChunk
from .voices.client import AsyncVoicesClient, VoicesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TtsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTtsClient(client_wrapper=client_wrapper)
        self.voices = VoicesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTtsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTtsClient
        """
        return self._raw_client

    def synthesize_json(
        self,
        *,
        utterances: typing.Sequence[PostedUtterance],
        access_token: typing.Optional[str] = None,
        context: typing.Optional[PostedContext] = OMIT,
        format: typing.Optional[Format] = OMIT,
        num_generations: typing.Optional[int] = OMIT,
        split_utterances: typing.Optional[bool] = OMIT,
        strip_headers: typing.Optional[bool] = OMIT,
        instant_mode: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnTts:
        """
        Synthesizes one or more input texts into speech using the specified voice. If no voice is provided, a novel voice will be generated dynamically. Optionally, additional context can be included to influence the speech's style and prosody.

        The response includes the base64-encoded audio and metadata in JSON format.

        Parameters
        ----------
        utterances : typing.Sequence[PostedUtterance]
            A list of **Utterances** to be converted to speech output.

            An **Utterance** is a unit of input for [Octave](/docs/text-to-speech-tts/overview), and includes input `text`, an optional `description` to serve as the prompt for how the speech should be delivered, an optional `voice` specification, and additional controls to guide delivery for `speed` and `trailing_silence`.

        access_token : typing.Optional[str]
            Access token used for authenticating the client. If not provided, an `api_key` must be provided to authenticate.

            The access token is generated using both an API key and a Secret key, which provides an additional layer of security compared to using just an API key.

            For more details, refer to the [Authentication Strategies Guide](/docs/introduction/api-key#authentication-strategies).

        context : typing.Optional[PostedContext]
            Utterances to use as context for generating consistent speech style and prosody across multiple requests. These will not be converted to speech output.

        format : typing.Optional[Format]
            Specifies the output audio file format.

        num_generations : typing.Optional[int]
            Number of generations of the audio to produce.

        split_utterances : typing.Optional[bool]
            Controls how audio output is segmented in the response.

            - When **enabled** (`true`), input utterances are automatically split into natural-sounding speech segments.

            - When **disabled** (`false`), the response maintains a strict one-to-one mapping between input utterances and output snippets.

            This setting affects how the `snippets` array is structured in the response, which may be important for applications that need to track the relationship between input text and generated audio segments. When setting to `false`, avoid including utterances with long `text`, as this can result in distorted output.

        strip_headers : typing.Optional[bool]
            If enabled, the audio for all the chunks of a generation, once concatenated together, will constitute a single audio file. Otherwise, if disabled, each chunk's audio will be its own audio file, each with its own headers (if applicable).

        instant_mode : typing.Optional[bool]
            Enables ultra-low latency streaming, significantly reducing the time until the first audio chunk is received. Recommended for real-time applications requiring immediate audio playback. For further details, see our documentation on [instant mode](/docs/text-to-speech-tts/overview#ultra-low-latency-streaming-instant-mode).
            - A [voice](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.utterances.voice) must be specified when instant mode is enabled. Dynamic voice generation is not supported with this mode.
            - Instant mode is only supported for streaming endpoints (e.g., [/v0/tts/stream/json](/reference/text-to-speech-tts/synthesize-json-streaming), [/v0/tts/stream/file](/reference/text-to-speech-tts/synthesize-file-streaming)).
            - Ensure only a single generation is requested ([num_generations](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.num_generations) must be `1` or omitted).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnTts
            Successful Response

        Examples
        --------
        from hume import HumeClient
        from hume.tts import FormatMp3, PostedContextWithUtterances, PostedUtterance

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.tts.synthesize_json(
            utterances=[
                PostedUtterance(
                    text="Beauty is no quality in things themselves: It exists merely in the mind which contemplates them.",
                    description="Middle-aged masculine voice with a clear, rhythmic Scots lilt, rounded vowels, and a warm, steady tone with an articulate, academic quality.",
                )
            ],
            context=PostedContextWithUtterances(
                utterances=[
                    PostedUtterance(
                        text="How can people see beauty so differently?",
                        description="A curious student with a clear and respectful tone, seeking clarification on Hume's ideas with a straightforward question.",
                    )
                ],
            ),
            format=FormatMp3(),
            num_generations=1,
        )
        """
        _response = self._raw_client.synthesize_json(
            utterances=utterances,
            access_token=access_token,
            context=context,
            format=format,
            num_generations=num_generations,
            split_utterances=split_utterances,
            strip_headers=strip_headers,
            instant_mode=instant_mode,
            request_options=request_options,
        )
        return _response.data

    def synthesize_file(
        self,
        *,
        utterances: typing.Sequence[PostedUtterance],
        context: typing.Optional[PostedContext] = OMIT,
        format: typing.Optional[Format] = OMIT,
        num_generations: typing.Optional[int] = OMIT,
        split_utterances: typing.Optional[bool] = OMIT,
        strip_headers: typing.Optional[bool] = OMIT,
        instant_mode: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Synthesizes one or more input texts into speech using the specified voice. If no voice is provided, a novel voice will be generated dynamically. Optionally, additional context can be included to influence the speech's style and prosody.

        The response contains the generated audio file in the requested format.

        Parameters
        ----------
        utterances : typing.Sequence[PostedUtterance]
            A list of **Utterances** to be converted to speech output.

            An **Utterance** is a unit of input for [Octave](/docs/text-to-speech-tts/overview), and includes input `text`, an optional `description` to serve as the prompt for how the speech should be delivered, an optional `voice` specification, and additional controls to guide delivery for `speed` and `trailing_silence`.

        context : typing.Optional[PostedContext]
            Utterances to use as context for generating consistent speech style and prosody across multiple requests. These will not be converted to speech output.

        format : typing.Optional[Format]
            Specifies the output audio file format.

        num_generations : typing.Optional[int]
            Number of generations of the audio to produce.

        split_utterances : typing.Optional[bool]
            Controls how audio output is segmented in the response.

            - When **enabled** (`true`), input utterances are automatically split into natural-sounding speech segments.

            - When **disabled** (`false`), the response maintains a strict one-to-one mapping between input utterances and output snippets.

            This setting affects how the `snippets` array is structured in the response, which may be important for applications that need to track the relationship between input text and generated audio segments. When setting to `false`, avoid including utterances with long `text`, as this can result in distorted output.

        strip_headers : typing.Optional[bool]
            If enabled, the audio for all the chunks of a generation, once concatenated together, will constitute a single audio file. Otherwise, if disabled, each chunk's audio will be its own audio file, each with its own headers (if applicable).

        instant_mode : typing.Optional[bool]
            Enables ultra-low latency streaming, significantly reducing the time until the first audio chunk is received. Recommended for real-time applications requiring immediate audio playback. For further details, see our documentation on [instant mode](/docs/text-to-speech-tts/overview#ultra-low-latency-streaming-instant-mode).
            - A [voice](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.utterances.voice) must be specified when instant mode is enabled. Dynamic voice generation is not supported with this mode.
            - Instant mode is only supported for streaming endpoints (e.g., [/v0/tts/stream/json](/reference/text-to-speech-tts/synthesize-json-streaming), [/v0/tts/stream/file](/reference/text-to-speech-tts/synthesize-file-streaming)).
            - Ensure only a single generation is requested ([num_generations](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.num_generations) must be `1` or omitted).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            OK

        Examples
        --------
        from hume import HumeClient
        from hume.tts import FormatMp3, PostedContextWithGenerationId, PostedUtterance

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.tts.synthesize_file(
            utterances=[
                PostedUtterance(
                    text="Beauty is no quality in things themselves: It exists merely in the mind which contemplates them.",
                    description="Middle-aged masculine voice with a clear, rhythmic Scots lilt, rounded vowels, and a warm, steady tone with an articulate, academic quality.",
                )
            ],
            context=PostedContextWithGenerationId(
                generation_id="09ad914d-8e7f-40f8-a279-e34f07f7dab2",
            ),
            format=FormatMp3(),
            num_generations=1,
        )
        """
        with self._raw_client.synthesize_file(
            utterances=utterances,
            context=context,
            format=format,
            num_generations=num_generations,
            split_utterances=split_utterances,
            strip_headers=strip_headers,
            instant_mode=instant_mode,
            request_options=request_options,
        ) as r:
            yield from r.data

    def synthesize_file_streaming(
        self,
        *,
        utterances: typing.Sequence[PostedUtterance],
        context: typing.Optional[PostedContext] = OMIT,
        format: typing.Optional[Format] = OMIT,
        num_generations: typing.Optional[int] = OMIT,
        split_utterances: typing.Optional[bool] = OMIT,
        strip_headers: typing.Optional[bool] = OMIT,
        instant_mode: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[bytes]:
        """
        Streams synthesized speech using the specified voice. If no voice is provided, a novel voice will be generated dynamically. Optionally, additional context can be included to influence the speech's style and prosody.

        Parameters
        ----------
        utterances : typing.Sequence[PostedUtterance]
            A list of **Utterances** to be converted to speech output.

            An **Utterance** is a unit of input for [Octave](/docs/text-to-speech-tts/overview), and includes input `text`, an optional `description` to serve as the prompt for how the speech should be delivered, an optional `voice` specification, and additional controls to guide delivery for `speed` and `trailing_silence`.

        context : typing.Optional[PostedContext]
            Utterances to use as context for generating consistent speech style and prosody across multiple requests. These will not be converted to speech output.

        format : typing.Optional[Format]
            Specifies the output audio file format.

        num_generations : typing.Optional[int]
            Number of generations of the audio to produce.

        split_utterances : typing.Optional[bool]
            Controls how audio output is segmented in the response.

            - When **enabled** (`true`), input utterances are automatically split into natural-sounding speech segments.

            - When **disabled** (`false`), the response maintains a strict one-to-one mapping between input utterances and output snippets.

            This setting affects how the `snippets` array is structured in the response, which may be important for applications that need to track the relationship between input text and generated audio segments. When setting to `false`, avoid including utterances with long `text`, as this can result in distorted output.

        strip_headers : typing.Optional[bool]
            If enabled, the audio for all the chunks of a generation, once concatenated together, will constitute a single audio file. Otherwise, if disabled, each chunk's audio will be its own audio file, each with its own headers (if applicable).

        instant_mode : typing.Optional[bool]
            Enables ultra-low latency streaming, significantly reducing the time until the first audio chunk is received. Recommended for real-time applications requiring immediate audio playback. For further details, see our documentation on [instant mode](/docs/text-to-speech-tts/overview#ultra-low-latency-streaming-instant-mode).
            - A [voice](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.utterances.voice) must be specified when instant mode is enabled. Dynamic voice generation is not supported with this mode.
            - Instant mode is only supported for streaming endpoints (e.g., [/v0/tts/stream/json](/reference/text-to-speech-tts/synthesize-json-streaming), [/v0/tts/stream/file](/reference/text-to-speech-tts/synthesize-file-streaming)).
            - Ensure only a single generation is requested ([num_generations](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.num_generations) must be `1` or omitted).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            OK

        Examples
        --------
        from hume import HumeClient
        from hume.tts import PostedUtterance, PostedUtteranceVoiceWithName

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        client.tts.synthesize_file_streaming(
            utterances=[
                PostedUtterance(
                    text="Beauty is no quality in things themselves: It exists merely in the mind which contemplates them.",
                    voice=PostedUtteranceVoiceWithName(
                        name="Male English Actor",
                        provider="HUME_AI",
                    ),
                )
            ],
        )
        """
        with self._raw_client.synthesize_file_streaming(
            utterances=utterances,
            context=context,
            format=format,
            num_generations=num_generations,
            split_utterances=split_utterances,
            strip_headers=strip_headers,
            instant_mode=instant_mode,
            request_options=request_options,
        ) as r:
            yield from r.data

    def synthesize_json_streaming(
        self,
        *,
        utterances: typing.Sequence[PostedUtterance],
        context: typing.Optional[PostedContext] = OMIT,
        format: typing.Optional[Format] = OMIT,
        num_generations: typing.Optional[int] = OMIT,
        split_utterances: typing.Optional[bool] = OMIT,
        strip_headers: typing.Optional[bool] = OMIT,
        instant_mode: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[SnippetAudioChunk]:
        """
        Streams synthesized speech using the specified voice. If no voice is provided, a novel voice will be generated dynamically. Optionally, additional context can be included to influence the speech's style and prosody.

        The response is a stream of JSON objects including audio encoded in base64.

        Parameters
        ----------
        utterances : typing.Sequence[PostedUtterance]
            A list of **Utterances** to be converted to speech output.

            An **Utterance** is a unit of input for [Octave](/docs/text-to-speech-tts/overview), and includes input `text`, an optional `description` to serve as the prompt for how the speech should be delivered, an optional `voice` specification, and additional controls to guide delivery for `speed` and `trailing_silence`.

        context : typing.Optional[PostedContext]
            Utterances to use as context for generating consistent speech style and prosody across multiple requests. These will not be converted to speech output.

        format : typing.Optional[Format]
            Specifies the output audio file format.

        num_generations : typing.Optional[int]
            Number of generations of the audio to produce.

        split_utterances : typing.Optional[bool]
            Controls how audio output is segmented in the response.

            - When **enabled** (`true`), input utterances are automatically split into natural-sounding speech segments.

            - When **disabled** (`false`), the response maintains a strict one-to-one mapping between input utterances and output snippets.

            This setting affects how the `snippets` array is structured in the response, which may be important for applications that need to track the relationship between input text and generated audio segments. When setting to `false`, avoid including utterances with long `text`, as this can result in distorted output.

        strip_headers : typing.Optional[bool]
            If enabled, the audio for all the chunks of a generation, once concatenated together, will constitute a single audio file. Otherwise, if disabled, each chunk's audio will be its own audio file, each with its own headers (if applicable).

        instant_mode : typing.Optional[bool]
            Enables ultra-low latency streaming, significantly reducing the time until the first audio chunk is received. Recommended for real-time applications requiring immediate audio playback. For further details, see our documentation on [instant mode](/docs/text-to-speech-tts/overview#ultra-low-latency-streaming-instant-mode).
            - A [voice](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.utterances.voice) must be specified when instant mode is enabled. Dynamic voice generation is not supported with this mode.
            - Instant mode is only supported for streaming endpoints (e.g., [/v0/tts/stream/json](/reference/text-to-speech-tts/synthesize-json-streaming), [/v0/tts/stream/file](/reference/text-to-speech-tts/synthesize-file-streaming)).
            - Ensure only a single generation is requested ([num_generations](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.num_generations) must be `1` or omitted).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[SnippetAudioChunk]
            Successful Response

        Examples
        --------
        from hume import HumeClient
        from hume.tts import PostedUtterance, PostedUtteranceVoiceWithName

        client = HumeClient(
            api_key="YOUR_API_KEY",
        )
        response = client.tts.synthesize_json_streaming(
            utterances=[
                PostedUtterance(
                    text="Beauty is no quality in things themselves: It exists merely in the mind which contemplates them.",
                    voice=PostedUtteranceVoiceWithName(
                        name="Male English Actor",
                        provider="HUME_AI",
                    ),
                )
            ],
        )
        for chunk in response:
            yield chunk
        """
        with self._raw_client.synthesize_json_streaming(
            utterances=utterances,
            context=context,
            format=format,
            num_generations=num_generations,
            split_utterances=split_utterances,
            strip_headers=strip_headers,
            instant_mode=instant_mode,
            request_options=request_options,
        ) as r:
            yield from r.data


class AsyncTtsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTtsClient(client_wrapper=client_wrapper)
        self.voices = AsyncVoicesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTtsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTtsClient
        """
        return self._raw_client

    async def synthesize_json(
        self,
        *,
        utterances: typing.Sequence[PostedUtterance],
        access_token: typing.Optional[str] = None,
        context: typing.Optional[PostedContext] = OMIT,
        format: typing.Optional[Format] = OMIT,
        num_generations: typing.Optional[int] = OMIT,
        split_utterances: typing.Optional[bool] = OMIT,
        strip_headers: typing.Optional[bool] = OMIT,
        instant_mode: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReturnTts:
        """
        Synthesizes one or more input texts into speech using the specified voice. If no voice is provided, a novel voice will be generated dynamically. Optionally, additional context can be included to influence the speech's style and prosody.

        The response includes the base64-encoded audio and metadata in JSON format.

        Parameters
        ----------
        utterances : typing.Sequence[PostedUtterance]
            A list of **Utterances** to be converted to speech output.

            An **Utterance** is a unit of input for [Octave](/docs/text-to-speech-tts/overview), and includes input `text`, an optional `description` to serve as the prompt for how the speech should be delivered, an optional `voice` specification, and additional controls to guide delivery for `speed` and `trailing_silence`.

        access_token : typing.Optional[str]
            Access token used for authenticating the client. If not provided, an `api_key` must be provided to authenticate.

            The access token is generated using both an API key and a Secret key, which provides an additional layer of security compared to using just an API key.

            For more details, refer to the [Authentication Strategies Guide](/docs/introduction/api-key#authentication-strategies).

        context : typing.Optional[PostedContext]
            Utterances to use as context for generating consistent speech style and prosody across multiple requests. These will not be converted to speech output.

        format : typing.Optional[Format]
            Specifies the output audio file format.

        num_generations : typing.Optional[int]
            Number of generations of the audio to produce.

        split_utterances : typing.Optional[bool]
            Controls how audio output is segmented in the response.

            - When **enabled** (`true`), input utterances are automatically split into natural-sounding speech segments.

            - When **disabled** (`false`), the response maintains a strict one-to-one mapping between input utterances and output snippets.

            This setting affects how the `snippets` array is structured in the response, which may be important for applications that need to track the relationship between input text and generated audio segments. When setting to `false`, avoid including utterances with long `text`, as this can result in distorted output.

        strip_headers : typing.Optional[bool]
            If enabled, the audio for all the chunks of a generation, once concatenated together, will constitute a single audio file. Otherwise, if disabled, each chunk's audio will be its own audio file, each with its own headers (if applicable).

        instant_mode : typing.Optional[bool]
            Enables ultra-low latency streaming, significantly reducing the time until the first audio chunk is received. Recommended for real-time applications requiring immediate audio playback. For further details, see our documentation on [instant mode](/docs/text-to-speech-tts/overview#ultra-low-latency-streaming-instant-mode).
            - A [voice](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.utterances.voice) must be specified when instant mode is enabled. Dynamic voice generation is not supported with this mode.
            - Instant mode is only supported for streaming endpoints (e.g., [/v0/tts/stream/json](/reference/text-to-speech-tts/synthesize-json-streaming), [/v0/tts/stream/file](/reference/text-to-speech-tts/synthesize-file-streaming)).
            - Ensure only a single generation is requested ([num_generations](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.num_generations) must be `1` or omitted).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReturnTts
            Successful Response

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient
        from hume.tts import FormatMp3, PostedContextWithUtterances, PostedUtterance

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tts.synthesize_json(
                utterances=[
                    PostedUtterance(
                        text="Beauty is no quality in things themselves: It exists merely in the mind which contemplates them.",
                        description="Middle-aged masculine voice with a clear, rhythmic Scots lilt, rounded vowels, and a warm, steady tone with an articulate, academic quality.",
                    )
                ],
                context=PostedContextWithUtterances(
                    utterances=[
                        PostedUtterance(
                            text="How can people see beauty so differently?",
                            description="A curious student with a clear and respectful tone, seeking clarification on Hume's ideas with a straightforward question.",
                        )
                    ],
                ),
                format=FormatMp3(),
                num_generations=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.synthesize_json(
            utterances=utterances,
            access_token=access_token,
            context=context,
            format=format,
            num_generations=num_generations,
            split_utterances=split_utterances,
            strip_headers=strip_headers,
            instant_mode=instant_mode,
            request_options=request_options,
        )
        return _response.data

    async def synthesize_file(
        self,
        *,
        utterances: typing.Sequence[PostedUtterance],
        context: typing.Optional[PostedContext] = OMIT,
        format: typing.Optional[Format] = OMIT,
        num_generations: typing.Optional[int] = OMIT,
        split_utterances: typing.Optional[bool] = OMIT,
        strip_headers: typing.Optional[bool] = OMIT,
        instant_mode: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Synthesizes one or more input texts into speech using the specified voice. If no voice is provided, a novel voice will be generated dynamically. Optionally, additional context can be included to influence the speech's style and prosody.

        The response contains the generated audio file in the requested format.

        Parameters
        ----------
        utterances : typing.Sequence[PostedUtterance]
            A list of **Utterances** to be converted to speech output.

            An **Utterance** is a unit of input for [Octave](/docs/text-to-speech-tts/overview), and includes input `text`, an optional `description` to serve as the prompt for how the speech should be delivered, an optional `voice` specification, and additional controls to guide delivery for `speed` and `trailing_silence`.

        context : typing.Optional[PostedContext]
            Utterances to use as context for generating consistent speech style and prosody across multiple requests. These will not be converted to speech output.

        format : typing.Optional[Format]
            Specifies the output audio file format.

        num_generations : typing.Optional[int]
            Number of generations of the audio to produce.

        split_utterances : typing.Optional[bool]
            Controls how audio output is segmented in the response.

            - When **enabled** (`true`), input utterances are automatically split into natural-sounding speech segments.

            - When **disabled** (`false`), the response maintains a strict one-to-one mapping between input utterances and output snippets.

            This setting affects how the `snippets` array is structured in the response, which may be important for applications that need to track the relationship between input text and generated audio segments. When setting to `false`, avoid including utterances with long `text`, as this can result in distorted output.

        strip_headers : typing.Optional[bool]
            If enabled, the audio for all the chunks of a generation, once concatenated together, will constitute a single audio file. Otherwise, if disabled, each chunk's audio will be its own audio file, each with its own headers (if applicable).

        instant_mode : typing.Optional[bool]
            Enables ultra-low latency streaming, significantly reducing the time until the first audio chunk is received. Recommended for real-time applications requiring immediate audio playback. For further details, see our documentation on [instant mode](/docs/text-to-speech-tts/overview#ultra-low-latency-streaming-instant-mode).
            - A [voice](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.utterances.voice) must be specified when instant mode is enabled. Dynamic voice generation is not supported with this mode.
            - Instant mode is only supported for streaming endpoints (e.g., [/v0/tts/stream/json](/reference/text-to-speech-tts/synthesize-json-streaming), [/v0/tts/stream/file](/reference/text-to-speech-tts/synthesize-file-streaming)).
            - Ensure only a single generation is requested ([num_generations](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.num_generations) must be `1` or omitted).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            OK

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient
        from hume.tts import FormatMp3, PostedContextWithGenerationId, PostedUtterance

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tts.synthesize_file(
                utterances=[
                    PostedUtterance(
                        text="Beauty is no quality in things themselves: It exists merely in the mind which contemplates them.",
                        description="Middle-aged masculine voice with a clear, rhythmic Scots lilt, rounded vowels, and a warm, steady tone with an articulate, academic quality.",
                    )
                ],
                context=PostedContextWithGenerationId(
                    generation_id="09ad914d-8e7f-40f8-a279-e34f07f7dab2",
                ),
                format=FormatMp3(),
                num_generations=1,
            )


        asyncio.run(main())
        """
        async with self._raw_client.synthesize_file(
            utterances=utterances,
            context=context,
            format=format,
            num_generations=num_generations,
            split_utterances=split_utterances,
            strip_headers=strip_headers,
            instant_mode=instant_mode,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    async def synthesize_file_streaming(
        self,
        *,
        utterances: typing.Sequence[PostedUtterance],
        context: typing.Optional[PostedContext] = OMIT,
        format: typing.Optional[Format] = OMIT,
        num_generations: typing.Optional[int] = OMIT,
        split_utterances: typing.Optional[bool] = OMIT,
        strip_headers: typing.Optional[bool] = OMIT,
        instant_mode: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[bytes]:
        """
        Streams synthesized speech using the specified voice. If no voice is provided, a novel voice will be generated dynamically. Optionally, additional context can be included to influence the speech's style and prosody.

        Parameters
        ----------
        utterances : typing.Sequence[PostedUtterance]
            A list of **Utterances** to be converted to speech output.

            An **Utterance** is a unit of input for [Octave](/docs/text-to-speech-tts/overview), and includes input `text`, an optional `description` to serve as the prompt for how the speech should be delivered, an optional `voice` specification, and additional controls to guide delivery for `speed` and `trailing_silence`.

        context : typing.Optional[PostedContext]
            Utterances to use as context for generating consistent speech style and prosody across multiple requests. These will not be converted to speech output.

        format : typing.Optional[Format]
            Specifies the output audio file format.

        num_generations : typing.Optional[int]
            Number of generations of the audio to produce.

        split_utterances : typing.Optional[bool]
            Controls how audio output is segmented in the response.

            - When **enabled** (`true`), input utterances are automatically split into natural-sounding speech segments.

            - When **disabled** (`false`), the response maintains a strict one-to-one mapping between input utterances and output snippets.

            This setting affects how the `snippets` array is structured in the response, which may be important for applications that need to track the relationship between input text and generated audio segments. When setting to `false`, avoid including utterances with long `text`, as this can result in distorted output.

        strip_headers : typing.Optional[bool]
            If enabled, the audio for all the chunks of a generation, once concatenated together, will constitute a single audio file. Otherwise, if disabled, each chunk's audio will be its own audio file, each with its own headers (if applicable).

        instant_mode : typing.Optional[bool]
            Enables ultra-low latency streaming, significantly reducing the time until the first audio chunk is received. Recommended for real-time applications requiring immediate audio playback. For further details, see our documentation on [instant mode](/docs/text-to-speech-tts/overview#ultra-low-latency-streaming-instant-mode).
            - A [voice](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.utterances.voice) must be specified when instant mode is enabled. Dynamic voice generation is not supported with this mode.
            - Instant mode is only supported for streaming endpoints (e.g., [/v0/tts/stream/json](/reference/text-to-speech-tts/synthesize-json-streaming), [/v0/tts/stream/file](/reference/text-to-speech-tts/synthesize-file-streaming)).
            - Ensure only a single generation is requested ([num_generations](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.num_generations) must be `1` or omitted).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            OK

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient
        from hume.tts import PostedUtterance, PostedUtteranceVoiceWithName

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tts.synthesize_file_streaming(
                utterances=[
                    PostedUtterance(
                        text="Beauty is no quality in things themselves: It exists merely in the mind which contemplates them.",
                        voice=PostedUtteranceVoiceWithName(
                            name="Male English Actor",
                            provider="HUME_AI",
                        ),
                    )
                ],
            )


        asyncio.run(main())
        """
        async with self._raw_client.synthesize_file_streaming(
            utterances=utterances,
            context=context,
            format=format,
            num_generations=num_generations,
            split_utterances=split_utterances,
            strip_headers=strip_headers,
            instant_mode=instant_mode,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk

    async def synthesize_json_streaming(
        self,
        *,
        utterances: typing.Sequence[PostedUtterance],
        context: typing.Optional[PostedContext] = OMIT,
        format: typing.Optional[Format] = OMIT,
        num_generations: typing.Optional[int] = OMIT,
        split_utterances: typing.Optional[bool] = OMIT,
        strip_headers: typing.Optional[bool] = OMIT,
        instant_mode: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[SnippetAudioChunk]:
        """
        Streams synthesized speech using the specified voice. If no voice is provided, a novel voice will be generated dynamically. Optionally, additional context can be included to influence the speech's style and prosody.

        The response is a stream of JSON objects including audio encoded in base64.

        Parameters
        ----------
        utterances : typing.Sequence[PostedUtterance]
            A list of **Utterances** to be converted to speech output.

            An **Utterance** is a unit of input for [Octave](/docs/text-to-speech-tts/overview), and includes input `text`, an optional `description` to serve as the prompt for how the speech should be delivered, an optional `voice` specification, and additional controls to guide delivery for `speed` and `trailing_silence`.

        context : typing.Optional[PostedContext]
            Utterances to use as context for generating consistent speech style and prosody across multiple requests. These will not be converted to speech output.

        format : typing.Optional[Format]
            Specifies the output audio file format.

        num_generations : typing.Optional[int]
            Number of generations of the audio to produce.

        split_utterances : typing.Optional[bool]
            Controls how audio output is segmented in the response.

            - When **enabled** (`true`), input utterances are automatically split into natural-sounding speech segments.

            - When **disabled** (`false`), the response maintains a strict one-to-one mapping between input utterances and output snippets.

            This setting affects how the `snippets` array is structured in the response, which may be important for applications that need to track the relationship between input text and generated audio segments. When setting to `false`, avoid including utterances with long `text`, as this can result in distorted output.

        strip_headers : typing.Optional[bool]
            If enabled, the audio for all the chunks of a generation, once concatenated together, will constitute a single audio file. Otherwise, if disabled, each chunk's audio will be its own audio file, each with its own headers (if applicable).

        instant_mode : typing.Optional[bool]
            Enables ultra-low latency streaming, significantly reducing the time until the first audio chunk is received. Recommended for real-time applications requiring immediate audio playback. For further details, see our documentation on [instant mode](/docs/text-to-speech-tts/overview#ultra-low-latency-streaming-instant-mode).
            - A [voice](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.utterances.voice) must be specified when instant mode is enabled. Dynamic voice generation is not supported with this mode.
            - Instant mode is only supported for streaming endpoints (e.g., [/v0/tts/stream/json](/reference/text-to-speech-tts/synthesize-json-streaming), [/v0/tts/stream/file](/reference/text-to-speech-tts/synthesize-file-streaming)).
            - Ensure only a single generation is requested ([num_generations](/reference/text-to-speech-tts/synthesize-json-streaming#request.body.num_generations) must be `1` or omitted).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[SnippetAudioChunk]
            Successful Response

        Examples
        --------
        import asyncio

        from hume import AsyncHumeClient
        from hume.tts import PostedUtterance, PostedUtteranceVoiceWithName

        client = AsyncHumeClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.tts.synthesize_json_streaming(
                utterances=[
                    PostedUtterance(
                        text="Beauty is no quality in things themselves: It exists merely in the mind which contemplates them.",
                        voice=PostedUtteranceVoiceWithName(
                            name="Male English Actor",
                            provider="HUME_AI",
                        ),
                    )
                ],
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._raw_client.synthesize_json_streaming(
            utterances=utterances,
            context=context,
            format=format,
            num_generations=num_generations,
            split_utterances=split_utterances,
            strip_headers=strip_headers,
            instant_mode=instant_mode,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk
