# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class Snippet(UniversalBaseModel):
    audio: str = pydantic.Field()
    """
    The segmented audio output in the requested format, encoded as a base64 string.
    """

    generation_id: str = pydantic.Field()
    """
    The generation ID this snippet corresponds to.
    """

    id: str = pydantic.Field()
    """
    A unique ID associated with this **Snippet**.
    """

    text: str = pydantic.Field()
    """
    The text for this **Snippet**.
    """

    transcribed_text: typing.Optional[str] = pydantic.Field(default=None)
    """
    The transcribed text of the generated audio. It is only present if `instant_mode` is set to `false`.
    """

    utterance_index: typing.Optional[int] = pydantic.Field(default=None)
    """
    The index of the utterance in the request this snippet corresponds to.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
