# Dapr SDK for Python

[![PyPI version](https://badge.fury.io/py/dapr.svg)](https://badge.fury.io/py/dapr)
[![PyPI version](https://badge.fury.io/py/dapr-dev.svg)](https://badge.fury.io/py/dapr-dev)
![dapr-python](https://github.com/dapr/python-sdk/workflows/dapr-python/badge.svg?branch=master)
[![Gitter](https://badges.gitter.im/Dapr/community.svg)](https://gitter.im/Dapr/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

[Dapr](https://github.com/dapr/docs/tree/master/concepts#dapr-concepts) is a portable, event-driven, serverless runtime for building distributed applications across cloud and edge.

Dapr SDK for Python allows you to implement the [Virtual Actor model](https://github.com/dapr/docs/tree/master/concepts/actors), based on the actor design pattern. This SDK can run locally, in a container and in any distributed systems environment.

This includes the following packages:

* [dapr.actor](./dapr/actor): Actor Framework
* [dapr.clients](./dapr/clients): Dapr clients for Dapr building blocks
* [dapr.conf](./dapr/conf): Configuration
* [dapr.serializers](./dapr/serializers): serializer/deserializer
* [dapr.proto](./dapr/proto): Dapr gRPC autogenerated gRPC clients
* [flask_dapr](./flask_dapr): flask extension for Dapr

## Status

> Note: Dapr SDK for python is currently under community development in alpha phase.

* [x] Initial implementation of Actor Runtime/Manager/Proxy
* [x] Actor service invocation
* [x] RPC style actor proxy
* [x] Flask integration for Dapr Actor Service
* [x] Example for Actor service invocation
* [x] Complete tox.ini setup
* [x] Actor state management
* [x] Actor timer
* [x] Actor reminder
* [x] Enhance error handling
* [ ] Auto generated documents
* [ ] Create convenient layer wrapping gRPC and HTTP clients for Dapr
* [ ] Flask extensions for Dapr State/Pubsub/Bindings

## Getting started

### Prerequisites

* [Install Dapr standalone mode](https://github.com/dapr/cli#install-dapr-on-your-local-machine-standalone)
* [Install Python 3.8+](https://www.python.org/downloads/)

### Install Dapr python sdk

* Official package - WIP

```sh
pip3 install dapr
```

* Development package

```sh
pip3 install dapr-dev
```

> Note: Do not install both packages.

### Try out examples

Go to [Examples](./examples)

## Developing

### Build and test

1. Clone python-sdk

```bash
git clone https://github.com/dapr/python-sdk.git
cd python-sdk
```

2. Set PYTHONPATH environment

Make sure that you set `PYTHONPATH` environment variable to repo root path.

```bash
export PYTHONPATH=`pwd`
```

3. Install required packages

```bash
pip3 install -r dev-requirements.txt
```

4. Run unit-test

```bash
tox -e py38
```

5. Run type check

```bash
tox -e type
```

## Documentation
Documentation is generated using Sphinx. Extensions used are mainly Napoleon (To process the Google Comment Style) and Autodocs (For automatically generating documentation). The `.rst` files are generated using Sphinx-Apidocs.

To generate documentation:

```bash
tox -e doc
```

The generated files will be found in `docs/_build`.

## Generate gRPC Protobuf client

```sh
pip3 install -r dev-requirements.txt

./tools/regen_grpcclient.sh
```

## Code of Conduct

This project has adopted the [Microsoft Open Source Code of conduct](https://opensource.microsoft.com/codeofconduct/).
For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.
