"""
Queue configuration helpers for user-facing API.

Example:
    from evenage.queues import RedisQueue
    q = RedisQueue(uri="redis://localhost:6379/myagent", queue_name="myagent_queue")

Agent(queue=q) will use this to connect to Redis.
"""
from __future__ import annotations

from dataclasses import dataclass


@dataclass
class RedisQueue:
    uri: str
    queue_name: str | None = None  # For compatibility with desired syntax; not used internally
