import sys
from pathlib import Path

from rich.style import Style
from textual._text_area_theme import TextAreaTheme
from textual.theme import Theme

from restiny.enums import CustomThemes

if getattr(sys, 'frozen', False):
    # When running with pyinstaller
    MODULE_DIR = Path(sys._MEIPASS)
else:
    # When running without pyinstaller
    MODULE_DIR = Path(__file__).resolve().parent

CONF_DIR = Path.home().joinpath('.restiny')
DB_FILE = CONF_DIR / 'restiny.sqlite3'

# Textual themes
CUSTOM_THEMES: dict[CustomThemes, dict[Theme | TextAreaTheme]] = {
    CustomThemes.DARK: {
        'global': Theme(
            name='dark',
            primary='#0178D4',
            secondary='#004578',
            accent='#ffa62b',
            warning='#ffa62b',
            error='#ba3c5b',
            success='#4EBF71',
            foreground='#e0e0e0',
        ),
        'text_area': TextAreaTheme(
            name='dark',
            base_style=Style(color='#CCCCCC', bgcolor='#1F1F1F'),
            gutter_style=Style(color='#6E7681', bgcolor='#1F1F1F'),
            cursor_style=Style(color='#1e1e1e', bgcolor='#f0f0f0'),
            cursor_line_style=Style(bgcolor='#2b2b2b'),
            bracket_matching_style=Style(bgcolor='#3a3a3a', bold=True),
            cursor_line_gutter_style=Style(color='#CCCCCC', bgcolor='#2b2b2b'),
            selection_style=Style(bgcolor='#264F78'),
            syntax_styles={
                'string': Style(color='#ce9178'),
                'string.documentation': Style(color='#ce9178'),
                'comment': Style(color='#6A9955'),
                'heading.marker': Style(color='#6E7681'),
                'keyword': Style(color='#C586C0'),
                'operator': Style(color='#CCCCCC'),
                'conditional': Style(color='#569cd6'),
                'keyword.function': Style(color='#569cd6'),
                'keyword.return': Style(color='#569cd6'),
                'keyword.operator': Style(color='#569cd6'),
                'repeat': Style(color='#569cd6'),
                'exception': Style(color='#569cd6'),
                'include': Style(color='#569cd6'),
                'number': Style(color='#b5cea8'),
                'float': Style(color='#b5cea8'),
                'class': Style(color='#4EC9B0'),
                'type': Style(color='#EFCB43'),
                'type.class': Style(color='#4EC9B0'),
                'type.builtin': Style(color='#9CDCFE'),
                'function': Style(color='#DCDCAA'),
                'function.call': Style(color='#DCDCAA'),
                'method': Style(color='#4EC9B0'),
                'method.call': Style(color='#4EC9B0'),
                'constructor': Style(color='#4EC9B0'),
                'boolean': Style(color='#7DAF9C'),
                'constant.builtin': Style(color='#7DAF9C'),
                'json.null': Style(color='#7DAF9C'),
                'tag': Style(color='#EFCB43'),
                'yaml.field': Style(color='#569cd6', bold=True),
                'json.label': Style(color='#569cd6', bold=True),
                'toml.type': Style(color='#569cd6'),
                'toml.datetime': Style(color='#C586C0', italic=True),
                'css.property': Style(color='#569cd6'),
                'heading': Style(color='#569cd6', bold=True),
                'bold': Style(bold=True),
                'italic': Style(italic=True),
                'strikethrough': Style(strike=True),
                'link.uri': Style(color='#40A6FF', underline=True),
                'link.label': Style(color='#569cd6'),
                'list.marker': Style(color='#6E7681'),
                'inline_code': Style(color='#ce9178'),
                'info_string': Style(color='#ce9178', bold=True, italic=True),
                'punctuation.bracket': Style(color='#CCCCCC'),
                'punctuation.delimiter': Style(color='#CCCCCC'),
                'punctuation.special': Style(color='#CCCCCC'),
            },
        ),
    },
    CustomThemes.DRACULA: {
        'global': Theme(
            name='dracula',
            primary='#BD93F9',
            secondary='#6272A4',
            warning='#FFB86C',
            error='#FF5555',
            success='#50FA7B',
            accent='#FF79C6',
            background='#282A36',
            surface='#2B2E3B',
            panel='#313442',
            foreground='#F8F8F2',
            variables={
                'button-color-foreground': '#282A36',
            },
        ),
        'text_area': TextAreaTheme(
            name='dracula',
            base_style=Style(color='#f8f8f2', bgcolor='#1E1F35'),
            gutter_style=Style(color='#6272a4'),
            cursor_style=Style(color='#282a36', bgcolor='#f8f8f0'),
            cursor_line_style=Style(bgcolor='#282b45'),
            cursor_line_gutter_style=Style(
                color='#c2c2bf', bgcolor='#282b45', bold=True
            ),
            bracket_matching_style=Style(
                bgcolor='#99999d', bold=True, underline=True
            ),
            selection_style=Style(bgcolor='#44475A'),
            syntax_styles={
                'string': Style(color='#f1fa8c'),
                'string.documentation': Style(color='#f1fa8c'),
                'comment': Style(color='#6272a4'),
                'heading.marker': Style(color='#6272a4'),
                'keyword': Style(color='#ff79c6'),
                'operator': Style(color='#f8f8f2'),
                'repeat': Style(color='#ff79c6'),
                'exception': Style(color='#ff79c6'),
                'include': Style(color='#ff79c6'),
                'keyword.function': Style(color='#ff79c6'),
                'keyword.return': Style(color='#ff79c6'),
                'keyword.operator': Style(color='#ff79c6'),
                'conditional': Style(color='#ff79c6'),
                'number': Style(color='#bd93f9'),
                'float': Style(color='#bd93f9'),
                'class': Style(color='#50fa7b'),
                'type': Style(color='#ff79c6'),
                'type.class': Style(color='#50fa7b'),
                'type.builtin': Style(color='#bd93f9'),
                'variable.builtin': Style(color='#f8f8f2'),
                'function': Style(color='#50fa7b'),
                'function.call': Style(color='#50fa7b'),
                'method': Style(color='#50fa7b'),
                'method.call': Style(color='#50fa7b'),
                'boolean': Style(color='#50fa7b'),
                'constant.builtin': Style(color='#bd93f9'),
                'json.null': Style(color='#bd93f9'),
                'regex.punctuation.bracket': Style(color='#ff79c6'),
                'regex.operator': Style(color='#ff79c6'),
                'html.end_tag_error': Style(color='#F83333', underline=True),
                'tag': Style(color='#ff79c6'),
                'yaml.field': Style(color='#ff79c6', bold=True),
                'json.label': Style(color='#ff79c6', bold=True),
                'toml.type': Style(color='#ff79c6'),
                'toml.datetime': Style(color='#bd93f9'),
                'css.property': Style(color='#bd93f9'),
                'heading': Style(color='#ff79c6', bold=True),
                'bold': Style(bold=True),
                'italic': Style(italic=True),
                'strikethrough': Style(strike=True),
                'link.label': Style(color='#ff79c6'),
                'link.uri': Style(color='#bd93f9', underline=True),
                'list.marker': Style(color='#6272a4'),
                'inline_code': Style(color='#f1fa8c'),
                'punctuation.bracket': Style(color='#f8f8f2'),
                'punctuation.delimiter': Style(color='#f8f8f2'),
                'punctuation.special': Style(color='#f8f8f2'),
            },
        ),
    },
    CustomThemes.FOREST: {
        'global': Theme(
            name='forest',
            primary='#58A55C',
            secondary='#0E1A12',
            accent='#8BC34A',
            warning='#C89B3C',
            error='#C0392B',
            success='#4CAF50',
            foreground='#E7F6E7',
            background='#0B1510',
            surface='#142019',
            panel='#1B2A21',
        ),
        'text_area': TextAreaTheme(
            name='forest',
            base_style=Style(color='#E7F6E7', bgcolor='#0B1510'),
            gutter_style=Style(color='#8CA694', bgcolor='#142019'),
            cursor_style=Style(color='#0B1510', bgcolor='#58A55C'),
            cursor_line_style=Style(bgcolor='#1B2A21'),
            cursor_line_gutter_style=Style(color='#B5D3C0', bgcolor='#1B2A21'),
            bracket_matching_style=Style(bgcolor='#284232', bold=True),
            selection_style=Style(bgcolor='#284232'),
            syntax_styles={
                'string': Style(color='#BCEABF'),
                'string.documentation': Style(color='#BCEABF'),
                'comment': Style(color='#4A6B59', italic=True),
                'heading.marker': Style(color='#6C8F7E'),
                'keyword': Style(color='#8BC34A', bold=True),
                'operator': Style(color='#E7F6E7'),
                'conditional': Style(color='#8BC34A'),
                'keyword.function': Style(color='#8BC34A'),
                'keyword.return': Style(color='#8BC34A'),
                'keyword.operator': Style(color='#8BC34A'),
                'repeat': Style(color='#8BC34A'),
                'exception': Style(color='#C0392B'),
                'include': Style(color='#8BC34A'),
                'number': Style(color='#A4E28F'),
                'float': Style(color='#A4E28F'),
                'class': Style(color='#4CAF50'),
                'type': Style(color='#4CAF50'),
                'type.class': Style(color='#4CAF50'),
                'type.builtin': Style(color='#8BC34A'),
                'variable.builtin': Style(color='#E7F6E7'),
                'function': Style(color='#58A55C'),
                'function.call': Style(color='#58A55C'),
                'method': Style(color='#58A55C'),
                'method.call': Style(color='#58A55C'),
                'boolean': Style(color='#9FE6A0'),
                'constant.builtin': Style(color='#9FE6A0'),
                'json.null': Style(color='#9FE6A0'),
                'regex.punctuation.bracket': Style(color='#8BC34A'),
                'regex.operator': Style(color='#8BC34A'),
                'tag': Style(color='#8BC34A'),
                'yaml.field': Style(color='#8BC34A', bold=True),
                'json.label': Style(color='#8BC34A', bold=True),
                'toml.type': Style(color='#8BC34A'),
                'toml.datetime': Style(color='#A4E28F'),
                'css.property': Style(color='#A4E28F'),
                'heading': Style(color='#8BC34A', bold=True),
                'bold': Style(bold=True),
                'italic': Style(italic=True),
                'strikethrough': Style(strike=True),
                'link.label': Style(color='#8BC34A'),
                'link.uri': Style(color='#A4E28F', underline=True),
                'list.marker': Style(color='#6C8F7E'),
                'inline_code': Style(color='#BCEABF'),
                'punctuation.bracket': Style(color='#E7F6E7'),
                'punctuation.delimiter': Style(color='#E7F6E7'),
                'punctuation.special': Style(color='#E7F6E7'),
            },
        ),
    },
}
