# provide/foundation/cli/commands/logs/constants.py
#
# SPDX-FileCopyrightText: Copyright (c) provide.io llc. All rights reserved.
# SPDX-License-Identifier: Apache-2.0

from __future__ import annotations

"""Constants for log generation."""

# Cut-up phrases inspired by Burroughs
BURROUGHS_PHRASES = [
    "mutated Soft Machine prescribed within data stream",
    "pre-recorded talking asshole dissolved into under neon hum",
    "the viral Word carrying a new strain of reality",
    "memory banks spilling future-pasts onto the terminal floor",
    "the soft typewriter of the Other Half",
    "control mechanisms broadcast in reversed time signatures",
    "equations of control flickering on a broken monitor",
    "semantic disturbances in Sector 9",
    "the Biologic Courts passing sentence in a dream",
    "a thousand junk units screaming in unison",
    "frequency shift reported by Sector 5",
    "the algebra of need written in neural static",
]

# Service names
SERVICE_NAMES = [
    "api-gateway",
    "auth-service",
    "user-service",
    "payment-processor",
    "notification-service",
    "search-index",
    "cache-layer",
    "data-pipeline",
    "ml-inference",
    "report-generator",
    "webhook-handler",
    "queue-processor",
    "stream-analyzer",
    "batch-job",
    "cron-scheduler",
    "interzone-terminal",
    "nova-police",
    "reality-studio",
]

# Operations
OPERATIONS = [
    "process_request",
    "validate_input",
    "execute_query",
    "transform_data",
    "send_notification",
    "update_cache",
    "sync_state",
    "aggregate_metrics",
    "encode_response",
    "decode_request",
    "authorize_access",
    "refresh_token",
    "persist_data",
    "emit_event",
    "handle_error",
    "transmit_signal",
    "intercept_word",
    "decode_reality",
]

# Normal tech-style operations
NORMAL_OPERATIONS = [
    "processed",
    "validated",
    "executed",
    "transformed",
    "cached",
    "synced",
]

# Normal tech-style objects
NORMAL_OBJECTS = [
    "request",
    "query",
    "data",
    "event",
    "message",
    "transaction",
]

# Error codes
ERROR_CODES = [400, 404, 500, 503]

# Error types
ERROR_TYPES = [
    "ValidationError",
    "ServiceUnavailable",
    "TimeoutError",
    "DatabaseError",
    "RateLimitExceeded",
]

# Log levels for non-errors
NON_ERROR_LEVELS = ["debug", "info", "warning"]

# Domain values
DOMAINS = ["user", "system", "data", "api", None]

# Action values
ACTIONS = ["create", "read", "update", "delete", None]

# Status values
STATUSES = ["success", "pending", None]

# Duration range (milliseconds)
MIN_DURATION_MS = 10
MAX_DURATION_MS = 5000


# <3 🧱🤝💻🪄
