# provide/foundation/profiling/defaults.py
#
# SPDX-FileCopyrightText: Copyright (c) provide.io llc. All rights reserved.
# SPDX-License-Identifier: Apache-2.0

from __future__ import annotations

"""Profiling defaults for Foundation configuration."""

# =================================
# Profiling Defaults
# =================================
DEFAULT_PROFILING_SAMPLE_RATE = 0.01  # 1% sampling
DEFAULT_PROFILING_ENABLED = False
DEFAULT_PROFILING_TRACK_MEMORY = False
DEFAULT_PROFILING_BUFFER_SIZE = 1000
DEFAULT_PROFILING_FLUSH_INTERVAL_SECONDS = 30
DEFAULT_PROFILING_MAX_MEMORY_MB = 100
DEFAULT_PROFILING_ENABLE_FAST_PATH = True
DEFAULT_PROFILING_BACKGROUND_PROCESSING = True
DEFAULT_PROFILING_CLI_ENABLED = True

# =================================
# Export Defaults
# =================================
DEFAULT_PROFILING_BATCH_SIZE = 100
DEFAULT_PROFILING_EXPORT_TIMEOUT_SECONDS = 30
DEFAULT_PROFILING_MAX_RETRIES = 3

__all__ = [
    "DEFAULT_PROFILING_BACKGROUND_PROCESSING",
    "DEFAULT_PROFILING_BATCH_SIZE",
    "DEFAULT_PROFILING_BUFFER_SIZE",
    "DEFAULT_PROFILING_CLI_ENABLED",
    "DEFAULT_PROFILING_ENABLED",
    "DEFAULT_PROFILING_ENABLE_FAST_PATH",
    "DEFAULT_PROFILING_EXPORT_TIMEOUT_SECONDS",
    "DEFAULT_PROFILING_FLUSH_INTERVAL_SECONDS",
    "DEFAULT_PROFILING_MAX_MEMORY_MB",
    "DEFAULT_PROFILING_MAX_RETRIES",
    "DEFAULT_PROFILING_SAMPLE_RATE",
    "DEFAULT_PROFILING_TRACK_MEMORY",
]


# <3 🧱🤝⏱️🪄
