# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AccessMutualTlsCertificateArgs', 'AccessMutualTlsCertificate']

@pulumi.input_type
class AccessMutualTlsCertificateArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 associated_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AccessMutualTlsCertificate resource.
        :param pulumi.Input[builtins.str] certificate: The certificate content.
        :param pulumi.Input[builtins.str] name: The name of the certificate.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_hostnames: The hostnames of the applications that will use this certificate.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "name", name)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if associated_hostnames is not None:
            pulumi.set(__self__, "associated_hostnames", associated_hostnames)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[builtins.str]:
        """
        The certificate content.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="associatedHostnames")
    def associated_hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The hostnames of the applications that will use this certificate.
        """
        return pulumi.get(self, "associated_hostnames")

    @associated_hostnames.setter
    def associated_hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "associated_hostnames", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _AccessMutualTlsCertificateState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 associated_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 expires_on: Optional[pulumi.Input[builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessMutualTlsCertificate resources.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_hostnames: The hostnames of the applications that will use this certificate.
        :param pulumi.Input[builtins.str] certificate: The certificate content.
        :param pulumi.Input[builtins.str] fingerprint: The MD5 fingerprint of the certificate.
        :param pulumi.Input[builtins.str] name: The name of the certificate.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if associated_hostnames is not None:
            pulumi.set(__self__, "associated_hostnames", associated_hostnames)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if expires_on is not None:
            pulumi.set(__self__, "expires_on", expires_on)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="associatedHostnames")
    def associated_hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The hostnames of the applications that will use this certificate.
        """
        return pulumi.get(self, "associated_hostnames")

    @associated_hostnames.setter
    def associated_hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "associated_hostnames", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The certificate content.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "expires_on")

    @expires_on.setter
    def expires_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expires_on", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The MD5 fingerprint of the certificate.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the certificate.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


warnings.warn("""cloudflare.index/accessmutualtlscertificate.AccessMutualTlsCertificate has been deprecated in favor of cloudflare.index/zerotrustaccessmtlscertificate.ZeroTrustAccessMtlsCertificate""", DeprecationWarning)


@pulumi.type_token("cloudflare:index/accessMutualTlsCertificate:AccessMutualTlsCertificate")
class AccessMutualTlsCertificate(pulumi.CustomResource):
    warnings.warn("""cloudflare.index/accessmutualtlscertificate.AccessMutualTlsCertificate has been deprecated in favor of cloudflare.index/zerotrustaccessmtlscertificate.ZeroTrustAccessMtlsCertificate""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 associated_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_access_mtls_certificate = cloudflare.ZeroTrustAccessMtlsCertificate("example_zero_trust_access_mtls_certificate",
            certificate=\"\"\"  -----BEGIN CERTIFICATE-----
          MIIGAjCCA+qgAwIBAgIJAI7kymlF7CWT...N4RI7KKB7nikiuUf8vhULKy5IX10
          DrUtmu/B
          -----END CERTIFICATE-----
        \"\"\",
            name="Allow devs",
            zone_id="zone_id",
            associated_hostnames=["admin.example.com"])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accessMutualTlsCertificate:AccessMutualTlsCertificate example '<{accounts|zones}/{account_id|zone_id}>/<certificate_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_hostnames: The hostnames of the applications that will use this certificate.
        :param pulumi.Input[builtins.str] certificate: The certificate content.
        :param pulumi.Input[builtins.str] name: The name of the certificate.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessMutualTlsCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_zero_trust_access_mtls_certificate = cloudflare.ZeroTrustAccessMtlsCertificate("example_zero_trust_access_mtls_certificate",
            certificate=\"\"\"  -----BEGIN CERTIFICATE-----
          MIIGAjCCA+qgAwIBAgIJAI7kymlF7CWT...N4RI7KKB7nikiuUf8vhULKy5IX10
          DrUtmu/B
          -----END CERTIFICATE-----
        \"\"\",
            name="Allow devs",
            zone_id="zone_id",
            associated_hostnames=["admin.example.com"])
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accessMutualTlsCertificate:AccessMutualTlsCertificate example '<{accounts|zones}/{account_id|zone_id}>/<certificate_id>'
        ```

        :param str resource_name: The name of the resource.
        :param AccessMutualTlsCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessMutualTlsCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 associated_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""AccessMutualTlsCertificate is deprecated: cloudflare.index/accessmutualtlscertificate.AccessMutualTlsCertificate has been deprecated in favor of cloudflare.index/zerotrustaccessmtlscertificate.ZeroTrustAccessMtlsCertificate""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessMutualTlsCertificateArgs.__new__(AccessMutualTlsCertificateArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["associated_hostnames"] = associated_hostnames
            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = certificate
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["expires_on"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/cloudflareAccessMutualTlsCertificate:AccessMutualTlsCertificate")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(AccessMutualTlsCertificate, __self__).__init__(
            'cloudflare:index/accessMutualTlsCertificate:AccessMutualTlsCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            associated_hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            certificate: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            expires_on: Optional[pulumi.Input[builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'AccessMutualTlsCertificate':
        """
        Get an existing AccessMutualTlsCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] associated_hostnames: The hostnames of the applications that will use this certificate.
        :param pulumi.Input[builtins.str] certificate: The certificate content.
        :param pulumi.Input[builtins.str] fingerprint: The MD5 fingerprint of the certificate.
        :param pulumi.Input[builtins.str] name: The name of the certificate.
        :param pulumi.Input[builtins.str] zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessMutualTlsCertificateState.__new__(_AccessMutualTlsCertificateState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["associated_hostnames"] = associated_hostnames
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["expires_on"] = expires_on
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["name"] = name
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["zone_id"] = zone_id
        return AccessMutualTlsCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="associatedHostnames")
    def associated_hostnames(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The hostnames of the applications that will use this certificate.
        """
        return pulumi.get(self, "associated_hostnames")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[builtins.str]:
        """
        The certificate content.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        The MD5 fingerprint of the certificate.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the certificate.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")

