# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessPolicyArgs', 'AccessPolicy']

@pulumi.input_type
class AccessPolicyArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 decision: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]] = None,
                 approval_required: Optional[pulumi.Input[builtins.bool]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]] = None,
                 isolation_required: Optional[pulumi.Input[builtins.bool]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[builtins.str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[builtins.bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]] = None,
                 session_duration: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AccessPolicy resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.str] decision: The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
               Available values: "allow", "deny", "non_identity", "bypass".
        :param pulumi.Input[builtins.str] name: The name of the Access policy.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]] approval_groups: Administrators who can approve a temporary authentication request.
        :param pulumi.Input[builtins.bool] approval_required: Requires the user to request access from an administrator at the start of each session.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]] excludes: Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[builtins.bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        :param pulumi.Input[builtins.str] purpose_justification_prompt: A custom message that will appear on the purpose justification screen.
        :param pulumi.Input[builtins.bool] purpose_justification_required: Require users to enter a justification when they log in to the application.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]] requires: Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        :param pulumi.Input[builtins.str] session_duration: The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "decision", decision)
        pulumi.set(__self__, "name", name)
        if approval_groups is not None:
            pulumi.set(__self__, "approval_groups", approval_groups)
        if approval_required is not None:
            pulumi.set(__self__, "approval_required", approval_required)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if isolation_required is not None:
            pulumi.set(__self__, "isolation_required", isolation_required)
        if purpose_justification_prompt is not None:
            pulumi.set(__self__, "purpose_justification_prompt", purpose_justification_prompt)
        if purpose_justification_required is not None:
            pulumi.set(__self__, "purpose_justification_required", purpose_justification_required)
        if requires is not None:
            pulumi.set(__self__, "requires", requires)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def decision(self) -> pulumi.Input[builtins.str]:
        """
        The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
        Available values: "allow", "deny", "non_identity", "bypass".
        """
        return pulumi.get(self, "decision")

    @decision.setter
    def decision(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "decision", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Access policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="approvalGroups")
    def approval_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]]:
        """
        Administrators who can approve a temporary authentication request.
        """
        return pulumi.get(self, "approval_groups")

    @approval_groups.setter
    def approval_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]]):
        pulumi.set(self, "approval_groups", value)

    @property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Requires the user to request access from an administrator at the start of each session.
        """
        return pulumi.get(self, "approval_required")

    @approval_required.setter
    def approval_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "approval_required", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]]:
        """
        Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]]:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]]):
        pulumi.set(self, "includes", value)

    @property
    @pulumi.getter(name="isolationRequired")
    def isolation_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        """
        return pulumi.get(self, "isolation_required")

    @isolation_required.setter
    def isolation_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "isolation_required", value)

    @property
    @pulumi.getter(name="purposeJustificationPrompt")
    def purpose_justification_prompt(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A custom message that will appear on the purpose justification screen.
        """
        return pulumi.get(self, "purpose_justification_prompt")

    @purpose_justification_prompt.setter
    def purpose_justification_prompt(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "purpose_justification_prompt", value)

    @property
    @pulumi.getter(name="purposeJustificationRequired")
    def purpose_justification_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Require users to enter a justification when they log in to the application.
        """
        return pulumi.get(self, "purpose_justification_required")

    @purpose_justification_required.setter
    def purpose_justification_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "purpose_justification_required", value)

    @property
    @pulumi.getter
    def requires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]]:
        """
        Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @requires.setter
    def requires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]]):
        pulumi.set(self, "requires", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_duration", value)


@pulumi.input_type
class _AccessPolicyState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 app_count: Optional[pulumi.Input[builtins.int]] = None,
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]] = None,
                 approval_required: Optional[pulumi.Input[builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 decision: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]] = None,
                 isolation_required: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[builtins.str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[builtins.bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]] = None,
                 reusable: Optional[pulumi.Input[builtins.bool]] = None,
                 session_duration: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessPolicy resources.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.int] app_count: Number of access applications currently using this policy.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]] approval_groups: Administrators who can approve a temporary authentication request.
        :param pulumi.Input[builtins.bool] approval_required: Requires the user to request access from an administrator at the start of each session.
        :param pulumi.Input[builtins.str] decision: The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
               Available values: "allow", "deny", "non_identity", "bypass".
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]] excludes: Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[builtins.bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        :param pulumi.Input[builtins.str] name: The name of the Access policy.
        :param pulumi.Input[builtins.str] purpose_justification_prompt: A custom message that will appear on the purpose justification screen.
        :param pulumi.Input[builtins.bool] purpose_justification_required: Require users to enter a justification when they log in to the application.
        :param pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]] requires: Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        :param pulumi.Input[builtins.str] session_duration: The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if app_count is not None:
            pulumi.set(__self__, "app_count", app_count)
        if approval_groups is not None:
            pulumi.set(__self__, "approval_groups", approval_groups)
        if approval_required is not None:
            pulumi.set(__self__, "approval_required", approval_required)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if decision is not None:
            pulumi.set(__self__, "decision", decision)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if includes is not None:
            pulumi.set(__self__, "includes", includes)
        if isolation_required is not None:
            pulumi.set(__self__, "isolation_required", isolation_required)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if purpose_justification_prompt is not None:
            pulumi.set(__self__, "purpose_justification_prompt", purpose_justification_prompt)
        if purpose_justification_required is not None:
            pulumi.set(__self__, "purpose_justification_required", purpose_justification_required)
        if requires is not None:
            pulumi.set(__self__, "requires", requires)
        if reusable is not None:
            pulumi.set(__self__, "reusable", reusable)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="appCount")
    def app_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of access applications currently using this policy.
        """
        return pulumi.get(self, "app_count")

    @app_count.setter
    def app_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "app_count", value)

    @property
    @pulumi.getter(name="approvalGroups")
    def approval_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]]:
        """
        Administrators who can approve a temporary authentication request.
        """
        return pulumi.get(self, "approval_groups")

    @approval_groups.setter
    def approval_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyApprovalGroupArgs']]]]):
        pulumi.set(self, "approval_groups", value)

    @property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Requires the user to request access from an administrator at the start of each session.
        """
        return pulumi.get(self, "approval_required")

    @approval_required.setter
    def approval_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "approval_required", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def decision(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
        Available values: "allow", "deny", "non_identity", "bypass".
        """
        return pulumi.get(self, "decision")

    @decision.setter
    def decision(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "decision", value)

    @property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]]:
        """
        Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyExcludeArgs']]]]):
        pulumi.set(self, "excludes", value)

    @property
    @pulumi.getter
    def includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]]:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @includes.setter
    def includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyIncludeArgs']]]]):
        pulumi.set(self, "includes", value)

    @property
    @pulumi.getter(name="isolationRequired")
    def isolation_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        """
        return pulumi.get(self, "isolation_required")

    @isolation_required.setter
    def isolation_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "isolation_required", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Access policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="purposeJustificationPrompt")
    def purpose_justification_prompt(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A custom message that will appear on the purpose justification screen.
        """
        return pulumi.get(self, "purpose_justification_prompt")

    @purpose_justification_prompt.setter
    def purpose_justification_prompt(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "purpose_justification_prompt", value)

    @property
    @pulumi.getter(name="purposeJustificationRequired")
    def purpose_justification_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Require users to enter a justification when they log in to the application.
        """
        return pulumi.get(self, "purpose_justification_required")

    @purpose_justification_required.setter
    def purpose_justification_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "purpose_justification_required", value)

    @property
    @pulumi.getter
    def requires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]]:
        """
        Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @requires.setter
    def requires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessPolicyRequireArgs']]]]):
        pulumi.set(self, "requires", value)

    @property
    @pulumi.getter
    def reusable(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "reusable")

    @reusable.setter
    def reusable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reusable", value)

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_duration", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


warnings.warn("""cloudflare.index/accesspolicy.AccessPolicy has been deprecated in favor of cloudflare.index/zerotrustaccesspolicy.ZeroTrustAccessPolicy""", DeprecationWarning)


@pulumi.type_token("cloudflare:index/accessPolicy:AccessPolicy")
class AccessPolicy(pulumi.CustomResource):
    warnings.warn("""cloudflare.index/accesspolicy.AccessPolicy has been deprecated in favor of cloudflare.index/zerotrustaccesspolicy.ZeroTrustAccessPolicy""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyApprovalGroupArgs', 'AccessPolicyApprovalGroupArgsDict']]]]] = None,
                 approval_required: Optional[pulumi.Input[builtins.bool]] = None,
                 decision: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyExcludeArgs', 'AccessPolicyExcludeArgsDict']]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyIncludeArgs', 'AccessPolicyIncludeArgsDict']]]]] = None,
                 isolation_required: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[builtins.str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[builtins.bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRequireArgs', 'AccessPolicyRequireArgsDict']]]]] = None,
                 session_duration: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accessPolicy:AccessPolicy example '<account_id>/<policy_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyApprovalGroupArgs', 'AccessPolicyApprovalGroupArgsDict']]]] approval_groups: Administrators who can approve a temporary authentication request.
        :param pulumi.Input[builtins.bool] approval_required: Requires the user to request access from an administrator at the start of each session.
        :param pulumi.Input[builtins.str] decision: The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
               Available values: "allow", "deny", "non_identity", "bypass".
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyExcludeArgs', 'AccessPolicyExcludeArgsDict']]]] excludes: Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyIncludeArgs', 'AccessPolicyIncludeArgsDict']]]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[builtins.bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        :param pulumi.Input[builtins.str] name: The name of the Access policy.
        :param pulumi.Input[builtins.str] purpose_justification_prompt: A custom message that will appear on the purpose justification screen.
        :param pulumi.Input[builtins.bool] purpose_justification_required: Require users to enter a justification when they log in to the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRequireArgs', 'AccessPolicyRequireArgsDict']]]] requires: Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        :param pulumi.Input[builtins.str] session_duration: The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accessPolicy:AccessPolicy example '<account_id>/<policy_id>'
        ```

        :param str resource_name: The name of the resource.
        :param AccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyApprovalGroupArgs', 'AccessPolicyApprovalGroupArgsDict']]]]] = None,
                 approval_required: Optional[pulumi.Input[builtins.bool]] = None,
                 decision: Optional[pulumi.Input[builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyExcludeArgs', 'AccessPolicyExcludeArgsDict']]]]] = None,
                 includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyIncludeArgs', 'AccessPolicyIncludeArgsDict']]]]] = None,
                 isolation_required: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 purpose_justification_prompt: Optional[pulumi.Input[builtins.str]] = None,
                 purpose_justification_required: Optional[pulumi.Input[builtins.bool]] = None,
                 requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRequireArgs', 'AccessPolicyRequireArgsDict']]]]] = None,
                 session_duration: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""AccessPolicy is deprecated: cloudflare.index/accesspolicy.AccessPolicy has been deprecated in favor of cloudflare.index/zerotrustaccesspolicy.ZeroTrustAccessPolicy""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessPolicyArgs.__new__(AccessPolicyArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["approval_groups"] = approval_groups
            __props__.__dict__["approval_required"] = approval_required
            if decision is None and not opts.urn:
                raise TypeError("Missing required property 'decision'")
            __props__.__dict__["decision"] = decision
            __props__.__dict__["excludes"] = excludes
            __props__.__dict__["includes"] = includes
            __props__.__dict__["isolation_required"] = isolation_required
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["purpose_justification_prompt"] = purpose_justification_prompt
            __props__.__dict__["purpose_justification_required"] = purpose_justification_required
            __props__.__dict__["requires"] = requires
            __props__.__dict__["session_duration"] = session_duration
            __props__.__dict__["app_count"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["reusable"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/accessPolicy:AccessPolicy")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(AccessPolicy, __self__).__init__(
            'cloudflare:index/accessPolicy:AccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            app_count: Optional[pulumi.Input[builtins.int]] = None,
            approval_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyApprovalGroupArgs', 'AccessPolicyApprovalGroupArgsDict']]]]] = None,
            approval_required: Optional[pulumi.Input[builtins.bool]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            decision: Optional[pulumi.Input[builtins.str]] = None,
            excludes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyExcludeArgs', 'AccessPolicyExcludeArgsDict']]]]] = None,
            includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyIncludeArgs', 'AccessPolicyIncludeArgsDict']]]]] = None,
            isolation_required: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            purpose_justification_prompt: Optional[pulumi.Input[builtins.str]] = None,
            purpose_justification_required: Optional[pulumi.Input[builtins.bool]] = None,
            requires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRequireArgs', 'AccessPolicyRequireArgsDict']]]]] = None,
            reusable: Optional[pulumi.Input[builtins.bool]] = None,
            session_duration: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'AccessPolicy':
        """
        Get an existing AccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.int] app_count: Number of access applications currently using this policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyApprovalGroupArgs', 'AccessPolicyApprovalGroupArgsDict']]]] approval_groups: Administrators who can approve a temporary authentication request.
        :param pulumi.Input[builtins.bool] approval_required: Requires the user to request access from an administrator at the start of each session.
        :param pulumi.Input[builtins.str] decision: The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
               Available values: "allow", "deny", "non_identity", "bypass".
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyExcludeArgs', 'AccessPolicyExcludeArgsDict']]]] excludes: Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyIncludeArgs', 'AccessPolicyIncludeArgsDict']]]] includes: Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        :param pulumi.Input[builtins.bool] isolation_required: Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        :param pulumi.Input[builtins.str] name: The name of the Access policy.
        :param pulumi.Input[builtins.str] purpose_justification_prompt: A custom message that will appear on the purpose justification screen.
        :param pulumi.Input[builtins.bool] purpose_justification_required: Require users to enter a justification when they log in to the application.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessPolicyRequireArgs', 'AccessPolicyRequireArgsDict']]]] requires: Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        :param pulumi.Input[builtins.str] session_duration: The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessPolicyState.__new__(_AccessPolicyState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["app_count"] = app_count
        __props__.__dict__["approval_groups"] = approval_groups
        __props__.__dict__["approval_required"] = approval_required
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["decision"] = decision
        __props__.__dict__["excludes"] = excludes
        __props__.__dict__["includes"] = includes
        __props__.__dict__["isolation_required"] = isolation_required
        __props__.__dict__["name"] = name
        __props__.__dict__["purpose_justification_prompt"] = purpose_justification_prompt
        __props__.__dict__["purpose_justification_required"] = purpose_justification_required
        __props__.__dict__["requires"] = requires
        __props__.__dict__["reusable"] = reusable
        __props__.__dict__["session_duration"] = session_duration
        __props__.__dict__["updated_at"] = updated_at
        return AccessPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="appCount")
    def app_count(self) -> pulumi.Output[builtins.int]:
        """
        Number of access applications currently using this policy.
        """
        return pulumi.get(self, "app_count")

    @property
    @pulumi.getter(name="approvalGroups")
    def approval_groups(self) -> pulumi.Output[Optional[Sequence['outputs.AccessPolicyApprovalGroup']]]:
        """
        Administrators who can approve a temporary authentication request.
        """
        return pulumi.get(self, "approval_groups")

    @property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Requires the user to request access from an administrator at the start of each session.
        """
        return pulumi.get(self, "approval_required")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def decision(self) -> pulumi.Output[builtins.str]:
        """
        The action Access will take if a user matches this policy. Infrastructure application policies can only use the Allow action.
        Available values: "allow", "deny", "non_identity", "bypass".
        """
        return pulumi.get(self, "decision")

    @property
    @pulumi.getter
    def excludes(self) -> pulumi.Output[Sequence['outputs.AccessPolicyExclude']]:
        """
        Rules evaluated with a NOT logical operator. To match the policy, a user cannot meet any of the Exclude rules.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter
    def includes(self) -> pulumi.Output[Sequence['outputs.AccessPolicyInclude']]:
        """
        Rules evaluated with an OR logical operator. A user needs to meet only one of the Include rules.
        """
        return pulumi.get(self, "includes")

    @property
    @pulumi.getter(name="isolationRequired")
    def isolation_required(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Require this application to be served in an isolated browser for users matching this policy. 'Client Web Isolation' must be on for the account in order to use this feature.
        """
        return pulumi.get(self, "isolation_required")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Access policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="purposeJustificationPrompt")
    def purpose_justification_prompt(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A custom message that will appear on the purpose justification screen.
        """
        return pulumi.get(self, "purpose_justification_prompt")

    @property
    @pulumi.getter(name="purposeJustificationRequired")
    def purpose_justification_required(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Require users to enter a justification when they log in to the application.
        """
        return pulumi.get(self, "purpose_justification_required")

    @property
    @pulumi.getter
    def requires(self) -> pulumi.Output[Sequence['outputs.AccessPolicyRequire']]:
        """
        Rules evaluated with an AND logical operator. To match the policy, a user must meet all of the Require rules.
        """
        return pulumi.get(self, "requires")

    @property
    @pulumi.getter
    def reusable(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "reusable")

    @property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[builtins.str]:
        """
        The amount of time that tokens issued for the application will be valid. Must be in the format `300ms` or `2h45m`. Valid time units are: ns, us (or µs), ms, s, m, h.
        """
        return pulumi.get(self, "session_duration")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated_at")

