# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 settings: Optional[pulumi.Input['AccountSettingsArgs']] = None,
                 unit: Optional[pulumi.Input['AccountUnitArgs']] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[builtins.str] name: Account name
        :param pulumi.Input[builtins.str] type: the type of account being created. For self-serve customers, use standard. for enterprise customers, use enterprise.
               Available values: "standard", "enterprise".
        :param pulumi.Input['AccountSettingsArgs'] settings: Account settings
        :param pulumi.Input['AccountUnitArgs'] unit: information related to the tenant unit, and optionally, an id of the unit to create the account on. see https://developers.cloudflare.com/tenant/how-to/manage-accounts/
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Account name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        the type of account being created. For self-serve customers, use standard. for enterprise customers, use enterprise.
        Available values: "standard", "enterprise".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['AccountSettingsArgs']]:
        """
        Account settings
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['AccountSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input['AccountUnitArgs']]:
        """
        information related to the tenant unit, and optionally, an id of the unit to create the account on. see https://developers.cloudflare.com/tenant/how-to/manage-accounts/
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input['AccountUnitArgs']]):
        pulumi.set(self, "unit", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 created_on: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input['AccountSettingsArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 unit: Optional[pulumi.Input['AccountUnitArgs']] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[builtins.str] created_on: Timestamp for the creation of the account
        :param pulumi.Input[builtins.str] name: Account name
        :param pulumi.Input['AccountSettingsArgs'] settings: Account settings
        :param pulumi.Input[builtins.str] type: the type of account being created. For self-serve customers, use standard. for enterprise customers, use enterprise.
               Available values: "standard", "enterprise".
        :param pulumi.Input['AccountUnitArgs'] unit: information related to the tenant unit, and optionally, an id of the unit to create the account on. see https://developers.cloudflare.com/tenant/how-to/manage-accounts/
        """
        if created_on is not None:
            pulumi.set(__self__, "created_on", created_on)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timestamp for the creation of the account
        """
        return pulumi.get(self, "created_on")

    @created_on.setter
    def created_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_on", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['AccountSettingsArgs']]:
        """
        Account settings
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['AccountSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        the type of account being created. For self-serve customers, use standard. for enterprise customers, use enterprise.
        Available values: "standard", "enterprise".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input['AccountUnitArgs']]:
        """
        information related to the tenant unit, and optionally, an id of the unit to create the account on. see https://developers.cloudflare.com/tenant/how-to/manage-accounts/
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input['AccountUnitArgs']]):
        pulumi.set(self, "unit", value)


@pulumi.type_token("cloudflare:index/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['AccountSettingsArgs', 'AccountSettingsArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 unit: Optional[pulumi.Input[Union['AccountUnitArgs', 'AccountUnitArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_account = cloudflare.Account("example_account",
            name="name",
            type="standard",
            unit={
                "id": "f267e341f3dd4697bd3b9f71dd96247f",
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/account:Account example '<account_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Account name
        :param pulumi.Input[Union['AccountSettingsArgs', 'AccountSettingsArgsDict']] settings: Account settings
        :param pulumi.Input[builtins.str] type: the type of account being created. For self-serve customers, use standard. for enterprise customers, use enterprise.
               Available values: "standard", "enterprise".
        :param pulumi.Input[Union['AccountUnitArgs', 'AccountUnitArgsDict']] unit: information related to the tenant unit, and optionally, an id of the unit to create the account on. see https://developers.cloudflare.com/tenant/how-to/manage-accounts/
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_account = cloudflare.Account("example_account",
            name="name",
            type="standard",
            unit={
                "id": "f267e341f3dd4697bd3b9f71dd96247f",
            })
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/account:Account example '<account_id>'
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['AccountSettingsArgs', 'AccountSettingsArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 unit: Optional[pulumi.Input[Union['AccountUnitArgs', 'AccountUnitArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["settings"] = settings
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["unit"] = unit
            __props__.__dict__["created_on"] = None
        super(Account, __self__).__init__(
            'cloudflare:index/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_on: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            settings: Optional[pulumi.Input[Union['AccountSettingsArgs', 'AccountSettingsArgsDict']]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            unit: Optional[pulumi.Input[Union['AccountUnitArgs', 'AccountUnitArgsDict']]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_on: Timestamp for the creation of the account
        :param pulumi.Input[builtins.str] name: Account name
        :param pulumi.Input[Union['AccountSettingsArgs', 'AccountSettingsArgsDict']] settings: Account settings
        :param pulumi.Input[builtins.str] type: the type of account being created. For self-serve customers, use standard. for enterprise customers, use enterprise.
               Available values: "standard", "enterprise".
        :param pulumi.Input[Union['AccountUnitArgs', 'AccountUnitArgsDict']] unit: information related to the tenant unit, and optionally, an id of the unit to create the account on. see https://developers.cloudflare.com/tenant/how-to/manage-accounts/
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["created_on"] = created_on
        __props__.__dict__["name"] = name
        __props__.__dict__["settings"] = settings
        __props__.__dict__["type"] = type
        __props__.__dict__["unit"] = unit
        return Account(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> pulumi.Output[builtins.str]:
        """
        Timestamp for the creation of the account
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Account name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output['outputs.AccountSettings']:
        """
        Account settings
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        the type of account being created. For self-serve customers, use standard. for enterprise customers, use enterprise.
        Available values: "standard", "enterprise".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Output[Optional['outputs.AccountUnit']]:
        """
        information related to the tenant unit, and optionally, an id of the unit to create the account on. see https://developers.cloudflare.com/tenant/how-to/manage-accounts/
        """
        return pulumi.get(self, "unit")

