# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountMemberArgs', 'AccountMember']

@pulumi.input_type
class AccountMemberArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 email: pulumi.Input[builtins.str],
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['AccountMemberPolicyArgs']]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AccountMember resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] email: The contact email address of the user.
        :param pulumi.Input[Sequence[pulumi.Input['AccountMemberPolicyArgs']]] policies: Array of policies associated with this member.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Array of roles associated with this member.
        :param pulumi.Input[builtins.str] status: Available values: "accepted", "pending".
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "email", email)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        """
        The contact email address of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountMemberPolicyArgs']]]]:
        """
        Array of policies associated with this member.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountMemberPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Array of roles associated with this member.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Available values: "accepted", "pending".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _AccountMemberState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['AccountMemberPolicyArgs']]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input['AccountMemberUserArgs']] = None):
        """
        Input properties used for looking up and filtering AccountMember resources.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] email: The contact email address of the user.
        :param pulumi.Input[Sequence[pulumi.Input['AccountMemberPolicyArgs']]] policies: Array of policies associated with this member.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Array of roles associated with this member.
        :param pulumi.Input[builtins.str] status: Available values: "accepted", "pending".
        :param pulumi.Input['AccountMemberUserArgs'] user: Details of the user associated to the membership.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The contact email address of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountMemberPolicyArgs']]]]:
        """
        Array of policies associated with this member.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountMemberPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Array of roles associated with this member.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Available values: "accepted", "pending".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['AccountMemberUserArgs']]:
        """
        Details of the user associated to the membership.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['AccountMemberUserArgs']]):
        pulumi.set(self, "user", value)


@pulumi.type_token("cloudflare:index/accountMember:AccountMember")
class AccountMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountMemberPolicyArgs', 'AccountMemberPolicyArgsDict']]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_account_member = cloudflare.AccountMember("example_account_member",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            email="user@example.com",
            roles=["3536bcfad5faccb999b47003c79917fb"],
            status="accepted")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accountMember:AccountMember example '<account_id>/<member_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] email: The contact email address of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountMemberPolicyArgs', 'AccountMemberPolicyArgsDict']]]] policies: Array of policies associated with this member.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Array of roles associated with this member.
        :param pulumi.Input[builtins.str] status: Available values: "accepted", "pending".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_account_member = cloudflare.AccountMember("example_account_member",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            email="user@example.com",
            roles=["3536bcfad5faccb999b47003c79917fb"],
            status="accepted")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/accountMember:AccountMember example '<account_id>/<member_id>'
        ```

        :param str resource_name: The name of the resource.
        :param AccountMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountMemberPolicyArgs', 'AccountMemberPolicyArgsDict']]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountMemberArgs.__new__(AccountMemberArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["policies"] = policies
            __props__.__dict__["roles"] = roles
            __props__.__dict__["status"] = status
            __props__.__dict__["user"] = None
        super(AccountMember, __self__).__init__(
            'cloudflare:index/accountMember:AccountMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountMemberPolicyArgs', 'AccountMemberPolicyArgsDict']]]]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            user: Optional[pulumi.Input[Union['AccountMemberUserArgs', 'AccountMemberUserArgsDict']]] = None) -> 'AccountMember':
        """
        Get an existing AccountMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] email: The contact email address of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountMemberPolicyArgs', 'AccountMemberPolicyArgsDict']]]] policies: Array of policies associated with this member.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] roles: Array of roles associated with this member.
        :param pulumi.Input[builtins.str] status: Available values: "accepted", "pending".
        :param pulumi.Input[Union['AccountMemberUserArgs', 'AccountMemberUserArgsDict']] user: Details of the user associated to the membership.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountMemberState.__new__(_AccountMemberState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["email"] = email
        __props__.__dict__["policies"] = policies
        __props__.__dict__["roles"] = roles
        __props__.__dict__["status"] = status
        __props__.__dict__["user"] = user
        return AccountMember(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        The contact email address of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Sequence['outputs.AccountMemberPolicy']]:
        """
        Array of policies associated with this member.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Array of roles associated with this member.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Available values: "accepted", "pending".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output['outputs.AccountMemberUser']:
        """
        Details of the user associated to the membership.
        """
        return pulumi.get(self, "user")

