# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthenticatedOriginPullsArgs', 'AuthenticatedOriginPulls']

@pulumi.input_type
class AuthenticatedOriginPullsArgs:
    def __init__(__self__, *,
                 configs: pulumi.Input[Sequence[pulumi.Input['AuthenticatedOriginPullsConfigArgs']]],
                 zone_id: pulumi.Input[builtins.str],
                 hostname: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AuthenticatedOriginPulls resource.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        :param pulumi.Input[builtins.str] hostname: The hostname on the origin for which the client certificate uploaded will be used.
        """
        pulumi.set(__self__, "configs", configs)
        pulumi.set(__self__, "zone_id", zone_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @property
    @pulumi.getter
    def configs(self) -> pulumi.Input[Sequence[pulumi.Input['AuthenticatedOriginPullsConfigArgs']]]:
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: pulumi.Input[Sequence[pulumi.Input['AuthenticatedOriginPullsConfigArgs']]]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname on the origin for which the client certificate uploaded will be used.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)


@pulumi.input_type
class _AuthenticatedOriginPullsState:
    def __init__(__self__, *,
                 cert_id: Optional[pulumi.Input[builtins.str]] = None,
                 cert_status: Optional[pulumi.Input[builtins.str]] = None,
                 cert_updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 cert_uploaded_on: Optional[pulumi.Input[builtins.str]] = None,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticatedOriginPullsConfigArgs']]]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 expires_on: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 issuer: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 serial_number: Optional[pulumi.Input[builtins.str]] = None,
                 signature: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthenticatedOriginPulls resources.
        :param pulumi.Input[builtins.str] cert_id: Identifier.
        :param pulumi.Input[builtins.str] cert_status: Status of the certificate or the association.
               Available values: "initializing", "pending*deployment", "pending*deletion", "active", "deleted", "deployment*timed*out", "deletion*timed*out".
        :param pulumi.Input[builtins.str] cert_updated_at: The time when the certificate was updated.
        :param pulumi.Input[builtins.str] cert_uploaded_on: The time when the certificate was uploaded.
        :param pulumi.Input[builtins.str] certificate: The hostname certificate.
        :param pulumi.Input[builtins.str] created_at: The time when the certificate was created.
        :param pulumi.Input[builtins.bool] enabled: Indicates whether hostname-level authenticated origin pulls is enabled. A null value voids the association.
        :param pulumi.Input[builtins.str] expires_on: The date when the certificate expires.
        :param pulumi.Input[builtins.str] hostname: The hostname on the origin for which the client certificate uploaded will be used.
        :param pulumi.Input[builtins.str] issuer: The certificate authority that issued the certificate.
        :param pulumi.Input[builtins.str] private_key: The hostname certificate's private key.
        :param pulumi.Input[builtins.str] serial_number: The serial number on the uploaded certificate.
        :param pulumi.Input[builtins.str] signature: The type of hash used for the certificate.
        :param pulumi.Input[builtins.str] status: Status of the certificate or the association.
               Available values: "initializing", "pending*deployment", "pending*deletion", "active", "deleted", "deployment*timed*out", "deletion*timed*out".
        :param pulumi.Input[builtins.str] updated_at: The time when the certificate was updated.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cert_status is not None:
            pulumi.set(__self__, "cert_status", cert_status)
        if cert_updated_at is not None:
            pulumi.set(__self__, "cert_updated_at", cert_updated_at)
        if cert_uploaded_on is not None:
            pulumi.set(__self__, "cert_uploaded_on", cert_uploaded_on)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expires_on is not None:
            pulumi.set(__self__, "expires_on", expires_on)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "cert_id")

    @cert_id.setter
    def cert_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cert_id", value)

    @property
    @pulumi.getter(name="certStatus")
    def cert_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the certificate or the association.
        Available values: "initializing", "pending*deployment", "pending*deletion", "active", "deleted", "deployment*timed*out", "deletion*timed*out".
        """
        return pulumi.get(self, "cert_status")

    @cert_status.setter
    def cert_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cert_status", value)

    @property
    @pulumi.getter(name="certUpdatedAt")
    def cert_updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the certificate was updated.
        """
        return pulumi.get(self, "cert_updated_at")

    @cert_updated_at.setter
    def cert_updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cert_updated_at", value)

    @property
    @pulumi.getter(name="certUploadedOn")
    def cert_uploaded_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the certificate was uploaded.
        """
        return pulumi.get(self, "cert_uploaded_on")

    @cert_uploaded_on.setter
    def cert_uploaded_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cert_uploaded_on", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticatedOriginPullsConfigArgs']]]]:
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticatedOriginPullsConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the certificate was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether hostname-level authenticated origin pulls is enabled. A null value voids the association.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date when the certificate expires.
        """
        return pulumi.get(self, "expires_on")

    @expires_on.setter
    def expires_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expires_on", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname on the origin for which the client certificate uploaded will be used.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The certificate authority that issued the certificate.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname certificate's private key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The serial number on the uploaded certificate.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of hash used for the certificate.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "signature", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the certificate or the association.
        Available values: "initializing", "pending*deployment", "pending*deletion", "active", "deleted", "deployment*timed*out", "deletion*timed*out".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the certificate was updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/authenticatedOriginPulls:AuthenticatedOriginPulls")
class AuthenticatedOriginPulls(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthenticatedOriginPullsConfigArgs', 'AuthenticatedOriginPullsConfigArgsDict']]]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] hostname: The hostname on the origin for which the client certificate uploaded will be used.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthenticatedOriginPullsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        :param str resource_name: The name of the resource.
        :param AuthenticatedOriginPullsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthenticatedOriginPullsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthenticatedOriginPullsConfigArgs', 'AuthenticatedOriginPullsConfigArgsDict']]]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthenticatedOriginPullsArgs.__new__(AuthenticatedOriginPullsArgs)

            if configs is None and not opts.urn:
                raise TypeError("Missing required property 'configs'")
            __props__.__dict__["configs"] = configs
            __props__.__dict__["hostname"] = hostname
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["cert_id"] = None
            __props__.__dict__["cert_status"] = None
            __props__.__dict__["cert_updated_at"] = None
            __props__.__dict__["cert_uploaded_on"] = None
            __props__.__dict__["certificate"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enabled"] = None
            __props__.__dict__["expires_on"] = None
            __props__.__dict__["issuer"] = None
            __props__.__dict__["private_key"] = None
            __props__.__dict__["serial_number"] = None
            __props__.__dict__["signature"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthenticatedOriginPulls, __self__).__init__(
            'cloudflare:index/authenticatedOriginPulls:AuthenticatedOriginPulls',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cert_id: Optional[pulumi.Input[builtins.str]] = None,
            cert_status: Optional[pulumi.Input[builtins.str]] = None,
            cert_updated_at: Optional[pulumi.Input[builtins.str]] = None,
            cert_uploaded_on: Optional[pulumi.Input[builtins.str]] = None,
            certificate: Optional[pulumi.Input[builtins.str]] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthenticatedOriginPullsConfigArgs', 'AuthenticatedOriginPullsConfigArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            expires_on: Optional[pulumi.Input[builtins.str]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            issuer: Optional[pulumi.Input[builtins.str]] = None,
            private_key: Optional[pulumi.Input[builtins.str]] = None,
            serial_number: Optional[pulumi.Input[builtins.str]] = None,
            signature: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'AuthenticatedOriginPulls':
        """
        Get an existing AuthenticatedOriginPulls resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cert_id: Identifier.
        :param pulumi.Input[builtins.str] cert_status: Status of the certificate or the association.
               Available values: "initializing", "pending*deployment", "pending*deletion", "active", "deleted", "deployment*timed*out", "deletion*timed*out".
        :param pulumi.Input[builtins.str] cert_updated_at: The time when the certificate was updated.
        :param pulumi.Input[builtins.str] cert_uploaded_on: The time when the certificate was uploaded.
        :param pulumi.Input[builtins.str] certificate: The hostname certificate.
        :param pulumi.Input[builtins.str] created_at: The time when the certificate was created.
        :param pulumi.Input[builtins.bool] enabled: Indicates whether hostname-level authenticated origin pulls is enabled. A null value voids the association.
        :param pulumi.Input[builtins.str] expires_on: The date when the certificate expires.
        :param pulumi.Input[builtins.str] hostname: The hostname on the origin for which the client certificate uploaded will be used.
        :param pulumi.Input[builtins.str] issuer: The certificate authority that issued the certificate.
        :param pulumi.Input[builtins.str] private_key: The hostname certificate's private key.
        :param pulumi.Input[builtins.str] serial_number: The serial number on the uploaded certificate.
        :param pulumi.Input[builtins.str] signature: The type of hash used for the certificate.
        :param pulumi.Input[builtins.str] status: Status of the certificate or the association.
               Available values: "initializing", "pending*deployment", "pending*deletion", "active", "deleted", "deployment*timed*out", "deletion*timed*out".
        :param pulumi.Input[builtins.str] updated_at: The time when the certificate was updated.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthenticatedOriginPullsState.__new__(_AuthenticatedOriginPullsState)

        __props__.__dict__["cert_id"] = cert_id
        __props__.__dict__["cert_status"] = cert_status
        __props__.__dict__["cert_updated_at"] = cert_updated_at
        __props__.__dict__["cert_uploaded_on"] = cert_uploaded_on
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["configs"] = configs
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["expires_on"] = expires_on
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["signature"] = signature
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["zone_id"] = zone_id
        return AuthenticatedOriginPulls(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certId")
    def cert_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "cert_id")

    @property
    @pulumi.getter(name="certStatus")
    def cert_status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the certificate or the association.
        Available values: "initializing", "pending*deployment", "pending*deletion", "active", "deleted", "deployment*timed*out", "deletion*timed*out".
        """
        return pulumi.get(self, "cert_status")

    @property
    @pulumi.getter(name="certUpdatedAt")
    def cert_updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The time when the certificate was updated.
        """
        return pulumi.get(self, "cert_updated_at")

    @property
    @pulumi.getter(name="certUploadedOn")
    def cert_uploaded_on(self) -> pulumi.Output[builtins.str]:
        """
        The time when the certificate was uploaded.
        """
        return pulumi.get(self, "cert_uploaded_on")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[builtins.str]:
        """
        The hostname certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Sequence['outputs.AuthenticatedOriginPullsConfig']]:
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The time when the certificate was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether hostname-level authenticated origin pulls is enabled. A null value voids the association.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> pulumi.Output[builtins.str]:
        """
        The date when the certificate expires.
        """
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The hostname on the origin for which the client certificate uploaded will be used.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[builtins.str]:
        """
        The certificate authority that issued the certificate.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[builtins.str]:
        """
        The hostname certificate's private key.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[builtins.str]:
        """
        The serial number on the uploaded certificate.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter
    def signature(self) -> pulumi.Output[builtins.str]:
        """
        The type of hash used for the certificate.
        """
        return pulumi.get(self, "signature")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the certificate or the association.
        Available values: "initializing", "pending*deployment", "pending*deletion", "active", "deleted", "deployment*timed*out", "deletion*timed*out".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The time when the certificate was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

