# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BotManagementArgs', 'BotManagement']

@pulumi.input_type
class BotManagementArgs:
    def __init__(__self__, *,
                 zone_id: pulumi.Input[builtins.str],
                 ai_bots_protection: Optional[pulumi.Input[builtins.str]] = None,
                 auto_update_model: Optional[pulumi.Input[builtins.bool]] = None,
                 crawler_protection: Optional[pulumi.Input[builtins.str]] = None,
                 enable_js: Optional[pulumi.Input[builtins.bool]] = None,
                 fight_mode: Optional[pulumi.Input[builtins.bool]] = None,
                 optimize_wordpress: Optional[pulumi.Input[builtins.bool]] = None,
                 sbfm_definitely_automated: Optional[pulumi.Input[builtins.str]] = None,
                 sbfm_likely_automated: Optional[pulumi.Input[builtins.str]] = None,
                 sbfm_static_resource_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 sbfm_verified_bots: Optional[pulumi.Input[builtins.str]] = None,
                 suppress_session_score: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a BotManagement resource.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        :param pulumi.Input[builtins.str] ai_bots_protection: Enable rule to block AI Scrapers and Crawlers.
               Available values: "block", "disabled".
        :param pulumi.Input[builtins.bool] auto_update_model: Automatically update to the newest bot detection models created by Cloudflare as they are released. [Learn more.](https://developers.cloudflare.com/bots/reference/machine-learning-models#model-versions-and-release-notes)
        :param pulumi.Input[builtins.str] crawler_protection: Enable rule to punish AI Scrapers and Crawlers via a link maze.
               Available values: "enabled", "disabled".
        :param pulumi.Input[builtins.bool] enable_js: Use lightweight, invisible JavaScript detections to improve Bot Management. [Learn more about JavaScript Detections](https://developers.cloudflare.com/bots/reference/javascript-detections/).
        :param pulumi.Input[builtins.bool] fight_mode: Whether to enable Bot Fight Mode.
        :param pulumi.Input[builtins.bool] optimize_wordpress: Whether to optimize Super Bot Fight Mode protections for Wordpress.
        :param pulumi.Input[builtins.str] sbfm_definitely_automated: Super Bot Fight Mode (SBFM) action to take on definitely automated requests.
               Available values: "allow", "block", "managed_challenge".
        :param pulumi.Input[builtins.str] sbfm_likely_automated: Super Bot Fight Mode (SBFM) action to take on likely automated requests.
               Available values: "allow", "block", "managed_challenge".
        :param pulumi.Input[builtins.bool] sbfm_static_resource_protection: Super Bot Fight Mode (SBFM) to enable static resource protection.
               Enable if static resources on your application need bot protection.
               Note: Static resource protection can also result in legitimate traffic being blocked.
        :param pulumi.Input[builtins.str] sbfm_verified_bots: Super Bot Fight Mode (SBFM) action to take on verified bots requests.
               Available values: "allow", "block".
        :param pulumi.Input[builtins.bool] suppress_session_score: Whether to disable tracking the highest bot score for a session in the Bot Management cookie.
        """
        pulumi.set(__self__, "zone_id", zone_id)
        if ai_bots_protection is not None:
            pulumi.set(__self__, "ai_bots_protection", ai_bots_protection)
        if auto_update_model is not None:
            pulumi.set(__self__, "auto_update_model", auto_update_model)
        if crawler_protection is not None:
            pulumi.set(__self__, "crawler_protection", crawler_protection)
        if enable_js is not None:
            pulumi.set(__self__, "enable_js", enable_js)
        if fight_mode is not None:
            pulumi.set(__self__, "fight_mode", fight_mode)
        if optimize_wordpress is not None:
            pulumi.set(__self__, "optimize_wordpress", optimize_wordpress)
        if sbfm_definitely_automated is not None:
            pulumi.set(__self__, "sbfm_definitely_automated", sbfm_definitely_automated)
        if sbfm_likely_automated is not None:
            pulumi.set(__self__, "sbfm_likely_automated", sbfm_likely_automated)
        if sbfm_static_resource_protection is not None:
            pulumi.set(__self__, "sbfm_static_resource_protection", sbfm_static_resource_protection)
        if sbfm_verified_bots is not None:
            pulumi.set(__self__, "sbfm_verified_bots", sbfm_verified_bots)
        if suppress_session_score is not None:
            pulumi.set(__self__, "suppress_session_score", suppress_session_score)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="aiBotsProtection")
    def ai_bots_protection(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable rule to block AI Scrapers and Crawlers.
        Available values: "block", "disabled".
        """
        return pulumi.get(self, "ai_bots_protection")

    @ai_bots_protection.setter
    def ai_bots_protection(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ai_bots_protection", value)

    @property
    @pulumi.getter(name="autoUpdateModel")
    def auto_update_model(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Automatically update to the newest bot detection models created by Cloudflare as they are released. [Learn more.](https://developers.cloudflare.com/bots/reference/machine-learning-models#model-versions-and-release-notes)
        """
        return pulumi.get(self, "auto_update_model")

    @auto_update_model.setter
    def auto_update_model(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_update_model", value)

    @property
    @pulumi.getter(name="crawlerProtection")
    def crawler_protection(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable rule to punish AI Scrapers and Crawlers via a link maze.
        Available values: "enabled", "disabled".
        """
        return pulumi.get(self, "crawler_protection")

    @crawler_protection.setter
    def crawler_protection(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "crawler_protection", value)

    @property
    @pulumi.getter(name="enableJs")
    def enable_js(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use lightweight, invisible JavaScript detections to improve Bot Management. [Learn more about JavaScript Detections](https://developers.cloudflare.com/bots/reference/javascript-detections/).
        """
        return pulumi.get(self, "enable_js")

    @enable_js.setter
    def enable_js(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_js", value)

    @property
    @pulumi.getter(name="fightMode")
    def fight_mode(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable Bot Fight Mode.
        """
        return pulumi.get(self, "fight_mode")

    @fight_mode.setter
    def fight_mode(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fight_mode", value)

    @property
    @pulumi.getter(name="optimizeWordpress")
    def optimize_wordpress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to optimize Super Bot Fight Mode protections for Wordpress.
        """
        return pulumi.get(self, "optimize_wordpress")

    @optimize_wordpress.setter
    def optimize_wordpress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "optimize_wordpress", value)

    @property
    @pulumi.getter(name="sbfmDefinitelyAutomated")
    def sbfm_definitely_automated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Super Bot Fight Mode (SBFM) action to take on definitely automated requests.
        Available values: "allow", "block", "managed_challenge".
        """
        return pulumi.get(self, "sbfm_definitely_automated")

    @sbfm_definitely_automated.setter
    def sbfm_definitely_automated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sbfm_definitely_automated", value)

    @property
    @pulumi.getter(name="sbfmLikelyAutomated")
    def sbfm_likely_automated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Super Bot Fight Mode (SBFM) action to take on likely automated requests.
        Available values: "allow", "block", "managed_challenge".
        """
        return pulumi.get(self, "sbfm_likely_automated")

    @sbfm_likely_automated.setter
    def sbfm_likely_automated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sbfm_likely_automated", value)

    @property
    @pulumi.getter(name="sbfmStaticResourceProtection")
    def sbfm_static_resource_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Super Bot Fight Mode (SBFM) to enable static resource protection.
        Enable if static resources on your application need bot protection.
        Note: Static resource protection can also result in legitimate traffic being blocked.
        """
        return pulumi.get(self, "sbfm_static_resource_protection")

    @sbfm_static_resource_protection.setter
    def sbfm_static_resource_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sbfm_static_resource_protection", value)

    @property
    @pulumi.getter(name="sbfmVerifiedBots")
    def sbfm_verified_bots(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Super Bot Fight Mode (SBFM) action to take on verified bots requests.
        Available values: "allow", "block".
        """
        return pulumi.get(self, "sbfm_verified_bots")

    @sbfm_verified_bots.setter
    def sbfm_verified_bots(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sbfm_verified_bots", value)

    @property
    @pulumi.getter(name="suppressSessionScore")
    def suppress_session_score(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to disable tracking the highest bot score for a session in the Bot Management cookie.
        """
        return pulumi.get(self, "suppress_session_score")

    @suppress_session_score.setter
    def suppress_session_score(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suppress_session_score", value)


@pulumi.input_type
class _BotManagementState:
    def __init__(__self__, *,
                 ai_bots_protection: Optional[pulumi.Input[builtins.str]] = None,
                 auto_update_model: Optional[pulumi.Input[builtins.bool]] = None,
                 crawler_protection: Optional[pulumi.Input[builtins.str]] = None,
                 enable_js: Optional[pulumi.Input[builtins.bool]] = None,
                 fight_mode: Optional[pulumi.Input[builtins.bool]] = None,
                 optimize_wordpress: Optional[pulumi.Input[builtins.bool]] = None,
                 sbfm_definitely_automated: Optional[pulumi.Input[builtins.str]] = None,
                 sbfm_likely_automated: Optional[pulumi.Input[builtins.str]] = None,
                 sbfm_static_resource_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 sbfm_verified_bots: Optional[pulumi.Input[builtins.str]] = None,
                 stale_zone_configuration: Optional[pulumi.Input['BotManagementStaleZoneConfigurationArgs']] = None,
                 suppress_session_score: Optional[pulumi.Input[builtins.bool]] = None,
                 using_latest_model: Optional[pulumi.Input[builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering BotManagement resources.
        :param pulumi.Input[builtins.str] ai_bots_protection: Enable rule to block AI Scrapers and Crawlers.
               Available values: "block", "disabled".
        :param pulumi.Input[builtins.bool] auto_update_model: Automatically update to the newest bot detection models created by Cloudflare as they are released. [Learn more.](https://developers.cloudflare.com/bots/reference/machine-learning-models#model-versions-and-release-notes)
        :param pulumi.Input[builtins.str] crawler_protection: Enable rule to punish AI Scrapers and Crawlers via a link maze.
               Available values: "enabled", "disabled".
        :param pulumi.Input[builtins.bool] enable_js: Use lightweight, invisible JavaScript detections to improve Bot Management. [Learn more about JavaScript Detections](https://developers.cloudflare.com/bots/reference/javascript-detections/).
        :param pulumi.Input[builtins.bool] fight_mode: Whether to enable Bot Fight Mode.
        :param pulumi.Input[builtins.bool] optimize_wordpress: Whether to optimize Super Bot Fight Mode protections for Wordpress.
        :param pulumi.Input[builtins.str] sbfm_definitely_automated: Super Bot Fight Mode (SBFM) action to take on definitely automated requests.
               Available values: "allow", "block", "managed_challenge".
        :param pulumi.Input[builtins.str] sbfm_likely_automated: Super Bot Fight Mode (SBFM) action to take on likely automated requests.
               Available values: "allow", "block", "managed_challenge".
        :param pulumi.Input[builtins.bool] sbfm_static_resource_protection: Super Bot Fight Mode (SBFM) to enable static resource protection.
               Enable if static resources on your application need bot protection.
               Note: Static resource protection can also result in legitimate traffic being blocked.
        :param pulumi.Input[builtins.str] sbfm_verified_bots: Super Bot Fight Mode (SBFM) action to take on verified bots requests.
               Available values: "allow", "block".
        :param pulumi.Input['BotManagementStaleZoneConfigurationArgs'] stale_zone_configuration: A read-only field that shows which unauthorized settings are currently active on the zone. These settings typically result from upgrades or downgrades.
        :param pulumi.Input[builtins.bool] suppress_session_score: Whether to disable tracking the highest bot score for a session in the Bot Management cookie.
        :param pulumi.Input[builtins.bool] using_latest_model: A read-only field that indicates whether the zone currently is running the latest ML model.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        if ai_bots_protection is not None:
            pulumi.set(__self__, "ai_bots_protection", ai_bots_protection)
        if auto_update_model is not None:
            pulumi.set(__self__, "auto_update_model", auto_update_model)
        if crawler_protection is not None:
            pulumi.set(__self__, "crawler_protection", crawler_protection)
        if enable_js is not None:
            pulumi.set(__self__, "enable_js", enable_js)
        if fight_mode is not None:
            pulumi.set(__self__, "fight_mode", fight_mode)
        if optimize_wordpress is not None:
            pulumi.set(__self__, "optimize_wordpress", optimize_wordpress)
        if sbfm_definitely_automated is not None:
            pulumi.set(__self__, "sbfm_definitely_automated", sbfm_definitely_automated)
        if sbfm_likely_automated is not None:
            pulumi.set(__self__, "sbfm_likely_automated", sbfm_likely_automated)
        if sbfm_static_resource_protection is not None:
            pulumi.set(__self__, "sbfm_static_resource_protection", sbfm_static_resource_protection)
        if sbfm_verified_bots is not None:
            pulumi.set(__self__, "sbfm_verified_bots", sbfm_verified_bots)
        if stale_zone_configuration is not None:
            pulumi.set(__self__, "stale_zone_configuration", stale_zone_configuration)
        if suppress_session_score is not None:
            pulumi.set(__self__, "suppress_session_score", suppress_session_score)
        if using_latest_model is not None:
            pulumi.set(__self__, "using_latest_model", using_latest_model)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="aiBotsProtection")
    def ai_bots_protection(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable rule to block AI Scrapers and Crawlers.
        Available values: "block", "disabled".
        """
        return pulumi.get(self, "ai_bots_protection")

    @ai_bots_protection.setter
    def ai_bots_protection(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ai_bots_protection", value)

    @property
    @pulumi.getter(name="autoUpdateModel")
    def auto_update_model(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Automatically update to the newest bot detection models created by Cloudflare as they are released. [Learn more.](https://developers.cloudflare.com/bots/reference/machine-learning-models#model-versions-and-release-notes)
        """
        return pulumi.get(self, "auto_update_model")

    @auto_update_model.setter
    def auto_update_model(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_update_model", value)

    @property
    @pulumi.getter(name="crawlerProtection")
    def crawler_protection(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable rule to punish AI Scrapers and Crawlers via a link maze.
        Available values: "enabled", "disabled".
        """
        return pulumi.get(self, "crawler_protection")

    @crawler_protection.setter
    def crawler_protection(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "crawler_protection", value)

    @property
    @pulumi.getter(name="enableJs")
    def enable_js(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use lightweight, invisible JavaScript detections to improve Bot Management. [Learn more about JavaScript Detections](https://developers.cloudflare.com/bots/reference/javascript-detections/).
        """
        return pulumi.get(self, "enable_js")

    @enable_js.setter
    def enable_js(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_js", value)

    @property
    @pulumi.getter(name="fightMode")
    def fight_mode(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable Bot Fight Mode.
        """
        return pulumi.get(self, "fight_mode")

    @fight_mode.setter
    def fight_mode(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fight_mode", value)

    @property
    @pulumi.getter(name="optimizeWordpress")
    def optimize_wordpress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to optimize Super Bot Fight Mode protections for Wordpress.
        """
        return pulumi.get(self, "optimize_wordpress")

    @optimize_wordpress.setter
    def optimize_wordpress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "optimize_wordpress", value)

    @property
    @pulumi.getter(name="sbfmDefinitelyAutomated")
    def sbfm_definitely_automated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Super Bot Fight Mode (SBFM) action to take on definitely automated requests.
        Available values: "allow", "block", "managed_challenge".
        """
        return pulumi.get(self, "sbfm_definitely_automated")

    @sbfm_definitely_automated.setter
    def sbfm_definitely_automated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sbfm_definitely_automated", value)

    @property
    @pulumi.getter(name="sbfmLikelyAutomated")
    def sbfm_likely_automated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Super Bot Fight Mode (SBFM) action to take on likely automated requests.
        Available values: "allow", "block", "managed_challenge".
        """
        return pulumi.get(self, "sbfm_likely_automated")

    @sbfm_likely_automated.setter
    def sbfm_likely_automated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sbfm_likely_automated", value)

    @property
    @pulumi.getter(name="sbfmStaticResourceProtection")
    def sbfm_static_resource_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Super Bot Fight Mode (SBFM) to enable static resource protection.
        Enable if static resources on your application need bot protection.
        Note: Static resource protection can also result in legitimate traffic being blocked.
        """
        return pulumi.get(self, "sbfm_static_resource_protection")

    @sbfm_static_resource_protection.setter
    def sbfm_static_resource_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "sbfm_static_resource_protection", value)

    @property
    @pulumi.getter(name="sbfmVerifiedBots")
    def sbfm_verified_bots(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Super Bot Fight Mode (SBFM) action to take on verified bots requests.
        Available values: "allow", "block".
        """
        return pulumi.get(self, "sbfm_verified_bots")

    @sbfm_verified_bots.setter
    def sbfm_verified_bots(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sbfm_verified_bots", value)

    @property
    @pulumi.getter(name="staleZoneConfiguration")
    def stale_zone_configuration(self) -> Optional[pulumi.Input['BotManagementStaleZoneConfigurationArgs']]:
        """
        A read-only field that shows which unauthorized settings are currently active on the zone. These settings typically result from upgrades or downgrades.
        """
        return pulumi.get(self, "stale_zone_configuration")

    @stale_zone_configuration.setter
    def stale_zone_configuration(self, value: Optional[pulumi.Input['BotManagementStaleZoneConfigurationArgs']]):
        pulumi.set(self, "stale_zone_configuration", value)

    @property
    @pulumi.getter(name="suppressSessionScore")
    def suppress_session_score(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to disable tracking the highest bot score for a session in the Bot Management cookie.
        """
        return pulumi.get(self, "suppress_session_score")

    @suppress_session_score.setter
    def suppress_session_score(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suppress_session_score", value)

    @property
    @pulumi.getter(name="usingLatestModel")
    def using_latest_model(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A read-only field that indicates whether the zone currently is running the latest ML model.
        """
        return pulumi.get(self, "using_latest_model")

    @using_latest_model.setter
    def using_latest_model(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "using_latest_model", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/botManagement:BotManagement")
class BotManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_bots_protection: Optional[pulumi.Input[builtins.str]] = None,
                 auto_update_model: Optional[pulumi.Input[builtins.bool]] = None,
                 crawler_protection: Optional[pulumi.Input[builtins.str]] = None,
                 enable_js: Optional[pulumi.Input[builtins.bool]] = None,
                 fight_mode: Optional[pulumi.Input[builtins.bool]] = None,
                 optimize_wordpress: Optional[pulumi.Input[builtins.bool]] = None,
                 sbfm_definitely_automated: Optional[pulumi.Input[builtins.str]] = None,
                 sbfm_likely_automated: Optional[pulumi.Input[builtins.str]] = None,
                 sbfm_static_resource_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 sbfm_verified_bots: Optional[pulumi.Input[builtins.str]] = None,
                 suppress_session_score: Optional[pulumi.Input[builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_bot_management = cloudflare.BotManagement("example_bot_management",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            ai_bots_protection="block",
            crawler_protection="enabled",
            enable_js=True,
            fight_mode=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/botManagement:BotManagement example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ai_bots_protection: Enable rule to block AI Scrapers and Crawlers.
               Available values: "block", "disabled".
        :param pulumi.Input[builtins.bool] auto_update_model: Automatically update to the newest bot detection models created by Cloudflare as they are released. [Learn more.](https://developers.cloudflare.com/bots/reference/machine-learning-models#model-versions-and-release-notes)
        :param pulumi.Input[builtins.str] crawler_protection: Enable rule to punish AI Scrapers and Crawlers via a link maze.
               Available values: "enabled", "disabled".
        :param pulumi.Input[builtins.bool] enable_js: Use lightweight, invisible JavaScript detections to improve Bot Management. [Learn more about JavaScript Detections](https://developers.cloudflare.com/bots/reference/javascript-detections/).
        :param pulumi.Input[builtins.bool] fight_mode: Whether to enable Bot Fight Mode.
        :param pulumi.Input[builtins.bool] optimize_wordpress: Whether to optimize Super Bot Fight Mode protections for Wordpress.
        :param pulumi.Input[builtins.str] sbfm_definitely_automated: Super Bot Fight Mode (SBFM) action to take on definitely automated requests.
               Available values: "allow", "block", "managed_challenge".
        :param pulumi.Input[builtins.str] sbfm_likely_automated: Super Bot Fight Mode (SBFM) action to take on likely automated requests.
               Available values: "allow", "block", "managed_challenge".
        :param pulumi.Input[builtins.bool] sbfm_static_resource_protection: Super Bot Fight Mode (SBFM) to enable static resource protection.
               Enable if static resources on your application need bot protection.
               Note: Static resource protection can also result in legitimate traffic being blocked.
        :param pulumi.Input[builtins.str] sbfm_verified_bots: Super Bot Fight Mode (SBFM) action to take on verified bots requests.
               Available values: "allow", "block".
        :param pulumi.Input[builtins.bool] suppress_session_score: Whether to disable tracking the highest bot score for a session in the Bot Management cookie.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BotManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_bot_management = cloudflare.BotManagement("example_bot_management",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            ai_bots_protection="block",
            crawler_protection="enabled",
            enable_js=True,
            fight_mode=True)
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/botManagement:BotManagement example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param BotManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BotManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ai_bots_protection: Optional[pulumi.Input[builtins.str]] = None,
                 auto_update_model: Optional[pulumi.Input[builtins.bool]] = None,
                 crawler_protection: Optional[pulumi.Input[builtins.str]] = None,
                 enable_js: Optional[pulumi.Input[builtins.bool]] = None,
                 fight_mode: Optional[pulumi.Input[builtins.bool]] = None,
                 optimize_wordpress: Optional[pulumi.Input[builtins.bool]] = None,
                 sbfm_definitely_automated: Optional[pulumi.Input[builtins.str]] = None,
                 sbfm_likely_automated: Optional[pulumi.Input[builtins.str]] = None,
                 sbfm_static_resource_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 sbfm_verified_bots: Optional[pulumi.Input[builtins.str]] = None,
                 suppress_session_score: Optional[pulumi.Input[builtins.bool]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BotManagementArgs.__new__(BotManagementArgs)

            __props__.__dict__["ai_bots_protection"] = ai_bots_protection
            __props__.__dict__["auto_update_model"] = auto_update_model
            __props__.__dict__["crawler_protection"] = crawler_protection
            __props__.__dict__["enable_js"] = enable_js
            __props__.__dict__["fight_mode"] = fight_mode
            __props__.__dict__["optimize_wordpress"] = optimize_wordpress
            __props__.__dict__["sbfm_definitely_automated"] = sbfm_definitely_automated
            __props__.__dict__["sbfm_likely_automated"] = sbfm_likely_automated
            __props__.__dict__["sbfm_static_resource_protection"] = sbfm_static_resource_protection
            __props__.__dict__["sbfm_verified_bots"] = sbfm_verified_bots
            __props__.__dict__["suppress_session_score"] = suppress_session_score
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["stale_zone_configuration"] = None
            __props__.__dict__["using_latest_model"] = None
        super(BotManagement, __self__).__init__(
            'cloudflare:index/botManagement:BotManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ai_bots_protection: Optional[pulumi.Input[builtins.str]] = None,
            auto_update_model: Optional[pulumi.Input[builtins.bool]] = None,
            crawler_protection: Optional[pulumi.Input[builtins.str]] = None,
            enable_js: Optional[pulumi.Input[builtins.bool]] = None,
            fight_mode: Optional[pulumi.Input[builtins.bool]] = None,
            optimize_wordpress: Optional[pulumi.Input[builtins.bool]] = None,
            sbfm_definitely_automated: Optional[pulumi.Input[builtins.str]] = None,
            sbfm_likely_automated: Optional[pulumi.Input[builtins.str]] = None,
            sbfm_static_resource_protection: Optional[pulumi.Input[builtins.bool]] = None,
            sbfm_verified_bots: Optional[pulumi.Input[builtins.str]] = None,
            stale_zone_configuration: Optional[pulumi.Input[Union['BotManagementStaleZoneConfigurationArgs', 'BotManagementStaleZoneConfigurationArgsDict']]] = None,
            suppress_session_score: Optional[pulumi.Input[builtins.bool]] = None,
            using_latest_model: Optional[pulumi.Input[builtins.bool]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'BotManagement':
        """
        Get an existing BotManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ai_bots_protection: Enable rule to block AI Scrapers and Crawlers.
               Available values: "block", "disabled".
        :param pulumi.Input[builtins.bool] auto_update_model: Automatically update to the newest bot detection models created by Cloudflare as they are released. [Learn more.](https://developers.cloudflare.com/bots/reference/machine-learning-models#model-versions-and-release-notes)
        :param pulumi.Input[builtins.str] crawler_protection: Enable rule to punish AI Scrapers and Crawlers via a link maze.
               Available values: "enabled", "disabled".
        :param pulumi.Input[builtins.bool] enable_js: Use lightweight, invisible JavaScript detections to improve Bot Management. [Learn more about JavaScript Detections](https://developers.cloudflare.com/bots/reference/javascript-detections/).
        :param pulumi.Input[builtins.bool] fight_mode: Whether to enable Bot Fight Mode.
        :param pulumi.Input[builtins.bool] optimize_wordpress: Whether to optimize Super Bot Fight Mode protections for Wordpress.
        :param pulumi.Input[builtins.str] sbfm_definitely_automated: Super Bot Fight Mode (SBFM) action to take on definitely automated requests.
               Available values: "allow", "block", "managed_challenge".
        :param pulumi.Input[builtins.str] sbfm_likely_automated: Super Bot Fight Mode (SBFM) action to take on likely automated requests.
               Available values: "allow", "block", "managed_challenge".
        :param pulumi.Input[builtins.bool] sbfm_static_resource_protection: Super Bot Fight Mode (SBFM) to enable static resource protection.
               Enable if static resources on your application need bot protection.
               Note: Static resource protection can also result in legitimate traffic being blocked.
        :param pulumi.Input[builtins.str] sbfm_verified_bots: Super Bot Fight Mode (SBFM) action to take on verified bots requests.
               Available values: "allow", "block".
        :param pulumi.Input[Union['BotManagementStaleZoneConfigurationArgs', 'BotManagementStaleZoneConfigurationArgsDict']] stale_zone_configuration: A read-only field that shows which unauthorized settings are currently active on the zone. These settings typically result from upgrades or downgrades.
        :param pulumi.Input[builtins.bool] suppress_session_score: Whether to disable tracking the highest bot score for a session in the Bot Management cookie.
        :param pulumi.Input[builtins.bool] using_latest_model: A read-only field that indicates whether the zone currently is running the latest ML model.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BotManagementState.__new__(_BotManagementState)

        __props__.__dict__["ai_bots_protection"] = ai_bots_protection
        __props__.__dict__["auto_update_model"] = auto_update_model
        __props__.__dict__["crawler_protection"] = crawler_protection
        __props__.__dict__["enable_js"] = enable_js
        __props__.__dict__["fight_mode"] = fight_mode
        __props__.__dict__["optimize_wordpress"] = optimize_wordpress
        __props__.__dict__["sbfm_definitely_automated"] = sbfm_definitely_automated
        __props__.__dict__["sbfm_likely_automated"] = sbfm_likely_automated
        __props__.__dict__["sbfm_static_resource_protection"] = sbfm_static_resource_protection
        __props__.__dict__["sbfm_verified_bots"] = sbfm_verified_bots
        __props__.__dict__["stale_zone_configuration"] = stale_zone_configuration
        __props__.__dict__["suppress_session_score"] = suppress_session_score
        __props__.__dict__["using_latest_model"] = using_latest_model
        __props__.__dict__["zone_id"] = zone_id
        return BotManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aiBotsProtection")
    def ai_bots_protection(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Enable rule to block AI Scrapers and Crawlers.
        Available values: "block", "disabled".
        """
        return pulumi.get(self, "ai_bots_protection")

    @property
    @pulumi.getter(name="autoUpdateModel")
    def auto_update_model(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Automatically update to the newest bot detection models created by Cloudflare as they are released. [Learn more.](https://developers.cloudflare.com/bots/reference/machine-learning-models#model-versions-and-release-notes)
        """
        return pulumi.get(self, "auto_update_model")

    @property
    @pulumi.getter(name="crawlerProtection")
    def crawler_protection(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Enable rule to punish AI Scrapers and Crawlers via a link maze.
        Available values: "enabled", "disabled".
        """
        return pulumi.get(self, "crawler_protection")

    @property
    @pulumi.getter(name="enableJs")
    def enable_js(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Use lightweight, invisible JavaScript detections to improve Bot Management. [Learn more about JavaScript Detections](https://developers.cloudflare.com/bots/reference/javascript-detections/).
        """
        return pulumi.get(self, "enable_js")

    @property
    @pulumi.getter(name="fightMode")
    def fight_mode(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable Bot Fight Mode.
        """
        return pulumi.get(self, "fight_mode")

    @property
    @pulumi.getter(name="optimizeWordpress")
    def optimize_wordpress(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to optimize Super Bot Fight Mode protections for Wordpress.
        """
        return pulumi.get(self, "optimize_wordpress")

    @property
    @pulumi.getter(name="sbfmDefinitelyAutomated")
    def sbfm_definitely_automated(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Super Bot Fight Mode (SBFM) action to take on definitely automated requests.
        Available values: "allow", "block", "managed_challenge".
        """
        return pulumi.get(self, "sbfm_definitely_automated")

    @property
    @pulumi.getter(name="sbfmLikelyAutomated")
    def sbfm_likely_automated(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Super Bot Fight Mode (SBFM) action to take on likely automated requests.
        Available values: "allow", "block", "managed_challenge".
        """
        return pulumi.get(self, "sbfm_likely_automated")

    @property
    @pulumi.getter(name="sbfmStaticResourceProtection")
    def sbfm_static_resource_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Super Bot Fight Mode (SBFM) to enable static resource protection.
        Enable if static resources on your application need bot protection.
        Note: Static resource protection can also result in legitimate traffic being blocked.
        """
        return pulumi.get(self, "sbfm_static_resource_protection")

    @property
    @pulumi.getter(name="sbfmVerifiedBots")
    def sbfm_verified_bots(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Super Bot Fight Mode (SBFM) action to take on verified bots requests.
        Available values: "allow", "block".
        """
        return pulumi.get(self, "sbfm_verified_bots")

    @property
    @pulumi.getter(name="staleZoneConfiguration")
    def stale_zone_configuration(self) -> pulumi.Output['outputs.BotManagementStaleZoneConfiguration']:
        """
        A read-only field that shows which unauthorized settings are currently active on the zone. These settings typically result from upgrades or downgrades.
        """
        return pulumi.get(self, "stale_zone_configuration")

    @property
    @pulumi.getter(name="suppressSessionScore")
    def suppress_session_score(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to disable tracking the highest bot score for a session in the Bot Management cookie.
        """
        return pulumi.get(self, "suppress_session_score")

    @property
    @pulumi.getter(name="usingLatestModel")
    def using_latest_model(self) -> pulumi.Output[builtins.bool]:
        """
        A read-only field that indicates whether the zone currently is running the latest ML model.
        """
        return pulumi.get(self, "using_latest_model")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

