# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CallsSfuAppArgs', 'CallsSfuApp']

@pulumi.input_type
class CallsSfuAppArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CallsSfuApp resource.
        :param pulumi.Input[builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[builtins.str] app_id: A Cloudflare-generated unique identifier for a item.
        :param pulumi.Input[builtins.str] name: A short description of Calls app, not shown to end users.
        """
        pulumi.set(__self__, "account_id", account_id)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a item.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A short description of Calls app, not shown to end users.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CallsSfuAppState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 created: Optional[pulumi.Input[builtins.str]] = None,
                 modified: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CallsSfuApp resources.
        :param pulumi.Input[builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[builtins.str] app_id: A Cloudflare-generated unique identifier for a item.
        :param pulumi.Input[builtins.str] created: The date and time the item was created.
        :param pulumi.Input[builtins.str] modified: The date and time the item was last modified.
        :param pulumi.Input[builtins.str] name: A short description of Calls app, not shown to end users.
        :param pulumi.Input[builtins.str] secret: Bearer token
        :param pulumi.Input[builtins.str] uid: A Cloudflare-generated unique identifier for a item.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if modified is not None:
            pulumi.set(__self__, "modified", modified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a item.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the item was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter
    def modified(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the item was last modified.
        """
        return pulumi.get(self, "modified")

    @modified.setter
    def modified(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A short description of Calls app, not shown to end users.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Bearer token
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a item.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("cloudflare:index/callsSfuApp:CallsSfuApp")
class CallsSfuApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_calls_sfu_app = cloudflare.CallsSfuApp("example_calls_sfu_app",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="production-realtime-app")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[builtins.str] app_id: A Cloudflare-generated unique identifier for a item.
        :param pulumi.Input[builtins.str] name: A short description of Calls app, not shown to end users.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CallsSfuAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_calls_sfu_app = cloudflare.CallsSfuApp("example_calls_sfu_app",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="production-realtime-app")
        ```

        :param str resource_name: The name of the resource.
        :param CallsSfuAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CallsSfuAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CallsSfuAppArgs.__new__(CallsSfuAppArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["name"] = name
            __props__.__dict__["created"] = None
            __props__.__dict__["modified"] = None
            __props__.__dict__["secret"] = None
            __props__.__dict__["uid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CallsSfuApp, __self__).__init__(
            'cloudflare:index/callsSfuApp:CallsSfuApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            app_id: Optional[pulumi.Input[builtins.str]] = None,
            created: Optional[pulumi.Input[builtins.str]] = None,
            modified: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            secret: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None) -> 'CallsSfuApp':
        """
        Get an existing CallsSfuApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: The account identifier tag.
        :param pulumi.Input[builtins.str] app_id: A Cloudflare-generated unique identifier for a item.
        :param pulumi.Input[builtins.str] created: The date and time the item was created.
        :param pulumi.Input[builtins.str] modified: The date and time the item was last modified.
        :param pulumi.Input[builtins.str] name: A short description of Calls app, not shown to end users.
        :param pulumi.Input[builtins.str] secret: Bearer token
        :param pulumi.Input[builtins.str] uid: A Cloudflare-generated unique identifier for a item.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CallsSfuAppState.__new__(_CallsSfuAppState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["created"] = created
        __props__.__dict__["modified"] = modified
        __props__.__dict__["name"] = name
        __props__.__dict__["secret"] = secret
        __props__.__dict__["uid"] = uid
        return CallsSfuApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A Cloudflare-generated unique identifier for a item.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the item was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def modified(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the item was last modified.
        """
        return pulumi.get(self, "modified")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A short description of Calls app, not shown to end users.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[builtins.str]:
        """
        Bearer token
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        A Cloudflare-generated unique identifier for a item.
        """
        return pulumi.get(self, "uid")

