# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudforceOneRequestArgs', 'CloudforceOneRequest']

@pulumi.input_type
class CloudforceOneRequestArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.str]] = None,
                 request_type: Optional[pulumi.Input[builtins.str]] = None,
                 summary: Optional[pulumi.Input[builtins.str]] = None,
                 tlp: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CloudforceOneRequest resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.str] content: Request content.
        :param pulumi.Input[builtins.str] priority: Priority for analyzing the request.
        :param pulumi.Input[builtins.str] request_type: Requested information from request.
        :param pulumi.Input[builtins.str] summary: Brief description of the request.
        :param pulumi.Input[builtins.str] tlp: The CISA defined Traffic Light Protocol (TLP).
               Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        pulumi.set(__self__, "account_id", account_id)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if tlp is not None:
            pulumi.set(__self__, "tlp", tlp)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Request content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Priority for analyzing the request.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Requested information from request.
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_type", value)

    @property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Brief description of the request.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "summary", value)

    @property
    @pulumi.getter
    def tlp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CISA defined Traffic Light Protocol (TLP).
        Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        return pulumi.get(self, "tlp")

    @tlp.setter
    def tlp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tlp", value)


@pulumi.input_type
class _CloudforceOneRequestState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 completed: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 created: Optional[pulumi.Input[builtins.str]] = None,
                 message_tokens: Optional[pulumi.Input[builtins.int]] = None,
                 priority: Optional[pulumi.Input[builtins.str]] = None,
                 readable_id: Optional[pulumi.Input[builtins.str]] = None,
                 request: Optional[pulumi.Input[builtins.str]] = None,
                 request_type: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 summary: Optional[pulumi.Input[builtins.str]] = None,
                 tlp: Optional[pulumi.Input[builtins.str]] = None,
                 tokens: Optional[pulumi.Input[builtins.int]] = None,
                 updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudforceOneRequest resources.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.str] content: Request content.
        :param pulumi.Input[builtins.int] message_tokens: Tokens for the request messages.
        :param pulumi.Input[builtins.str] priority: Priority for analyzing the request.
        :param pulumi.Input[builtins.str] readable_id: Readable Request ID.
        :param pulumi.Input[builtins.str] request: Requested information from request.
        :param pulumi.Input[builtins.str] request_type: Requested information from request.
        :param pulumi.Input[builtins.str] status: Request Status.
               Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        :param pulumi.Input[builtins.str] summary: Brief description of the request.
        :param pulumi.Input[builtins.str] tlp: The CISA defined Traffic Light Protocol (TLP).
               Available values: "clear", "amber", "amber-strict", "green", "red".
        :param pulumi.Input[builtins.int] tokens: Tokens for the request.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if completed is not None:
            pulumi.set(__self__, "completed", completed)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if message_tokens is not None:
            pulumi.set(__self__, "message_tokens", message_tokens)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if readable_id is not None:
            pulumi.set(__self__, "readable_id", readable_id)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if request_type is not None:
            pulumi.set(__self__, "request_type", request_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)
        if tlp is not None:
            pulumi.set(__self__, "tlp", tlp)
        if tokens is not None:
            pulumi.set(__self__, "tokens", tokens)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def completed(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "completed")

    @completed.setter
    def completed(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "completed", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Request content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="messageTokens")
    def message_tokens(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Tokens for the request messages.
        """
        return pulumi.get(self, "message_tokens")

    @message_tokens.setter
    def message_tokens(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "message_tokens", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Priority for analyzing the request.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="readableId")
    def readable_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Readable Request ID.
        """
        return pulumi.get(self, "readable_id")

    @readable_id.setter
    def readable_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "readable_id", value)

    @property
    @pulumi.getter
    def request(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Requested information from request.
        """
        return pulumi.get(self, "request")

    @request.setter
    def request(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request", value)

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Requested information from request.
        """
        return pulumi.get(self, "request_type")

    @request_type.setter
    def request_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Request Status.
        Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Brief description of the request.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "summary", value)

    @property
    @pulumi.getter
    def tlp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CISA defined Traffic Light Protocol (TLP).
        Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        return pulumi.get(self, "tlp")

    @tlp.setter
    def tlp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tlp", value)

    @property
    @pulumi.getter
    def tokens(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Tokens for the request.
        """
        return pulumi.get(self, "tokens")

    @tokens.setter
    def tokens(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tokens", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated", value)


@pulumi.type_token("cloudflare:index/cloudforceOneRequest:CloudforceOneRequest")
class CloudforceOneRequest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.str]] = None,
                 request_type: Optional[pulumi.Input[builtins.str]] = None,
                 summary: Optional[pulumi.Input[builtins.str]] = None,
                 tlp: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_cloudforce_one_request = cloudflare.CloudforceOneRequest("example_cloudforce_one_request",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            content="What regions were most effected by the recent DoS?",
            priority="routine",
            request_type="Victomology",
            summary="DoS attack",
            tlp="clear")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/cloudforceOneRequest:CloudforceOneRequest example '<account_id>/<request_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.str] content: Request content.
        :param pulumi.Input[builtins.str] priority: Priority for analyzing the request.
        :param pulumi.Input[builtins.str] request_type: Requested information from request.
        :param pulumi.Input[builtins.str] summary: Brief description of the request.
        :param pulumi.Input[builtins.str] tlp: The CISA defined Traffic Light Protocol (TLP).
               Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudforceOneRequestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_cloudforce_one_request = cloudflare.CloudforceOneRequest("example_cloudforce_one_request",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            content="What regions were most effected by the recent DoS?",
            priority="routine",
            request_type="Victomology",
            summary="DoS attack",
            tlp="clear")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/cloudforceOneRequest:CloudforceOneRequest example '<account_id>/<request_id>'
        ```

        :param str resource_name: The name of the resource.
        :param CloudforceOneRequestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudforceOneRequestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.str]] = None,
                 request_type: Optional[pulumi.Input[builtins.str]] = None,
                 summary: Optional[pulumi.Input[builtins.str]] = None,
                 tlp: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudforceOneRequestArgs.__new__(CloudforceOneRequestArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["content"] = content
            __props__.__dict__["priority"] = priority
            __props__.__dict__["request_type"] = request_type
            __props__.__dict__["summary"] = summary
            __props__.__dict__["tlp"] = tlp
            __props__.__dict__["completed"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["message_tokens"] = None
            __props__.__dict__["readable_id"] = None
            __props__.__dict__["request"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tokens"] = None
            __props__.__dict__["updated"] = None
        super(CloudforceOneRequest, __self__).__init__(
            'cloudflare:index/cloudforceOneRequest:CloudforceOneRequest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            completed: Optional[pulumi.Input[builtins.str]] = None,
            content: Optional[pulumi.Input[builtins.str]] = None,
            created: Optional[pulumi.Input[builtins.str]] = None,
            message_tokens: Optional[pulumi.Input[builtins.int]] = None,
            priority: Optional[pulumi.Input[builtins.str]] = None,
            readable_id: Optional[pulumi.Input[builtins.str]] = None,
            request: Optional[pulumi.Input[builtins.str]] = None,
            request_type: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            summary: Optional[pulumi.Input[builtins.str]] = None,
            tlp: Optional[pulumi.Input[builtins.str]] = None,
            tokens: Optional[pulumi.Input[builtins.int]] = None,
            updated: Optional[pulumi.Input[builtins.str]] = None) -> 'CloudforceOneRequest':
        """
        Get an existing CloudforceOneRequest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.str] content: Request content.
        :param pulumi.Input[builtins.int] message_tokens: Tokens for the request messages.
        :param pulumi.Input[builtins.str] priority: Priority for analyzing the request.
        :param pulumi.Input[builtins.str] readable_id: Readable Request ID.
        :param pulumi.Input[builtins.str] request: Requested information from request.
        :param pulumi.Input[builtins.str] request_type: Requested information from request.
        :param pulumi.Input[builtins.str] status: Request Status.
               Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        :param pulumi.Input[builtins.str] summary: Brief description of the request.
        :param pulumi.Input[builtins.str] tlp: The CISA defined Traffic Light Protocol (TLP).
               Available values: "clear", "amber", "amber-strict", "green", "red".
        :param pulumi.Input[builtins.int] tokens: Tokens for the request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudforceOneRequestState.__new__(_CloudforceOneRequestState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["completed"] = completed
        __props__.__dict__["content"] = content
        __props__.__dict__["created"] = created
        __props__.__dict__["message_tokens"] = message_tokens
        __props__.__dict__["priority"] = priority
        __props__.__dict__["readable_id"] = readable_id
        __props__.__dict__["request"] = request
        __props__.__dict__["request_type"] = request_type
        __props__.__dict__["status"] = status
        __props__.__dict__["summary"] = summary
        __props__.__dict__["tlp"] = tlp
        __props__.__dict__["tokens"] = tokens
        __props__.__dict__["updated"] = updated
        return CloudforceOneRequest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def completed(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "completed")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Request content.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="messageTokens")
    def message_tokens(self) -> pulumi.Output[builtins.int]:
        """
        Tokens for the request messages.
        """
        return pulumi.get(self, "message_tokens")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Priority for analyzing the request.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="readableId")
    def readable_id(self) -> pulumi.Output[builtins.str]:
        """
        Readable Request ID.
        """
        return pulumi.get(self, "readable_id")

    @property
    @pulumi.getter
    def request(self) -> pulumi.Output[builtins.str]:
        """
        Requested information from request.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Requested information from request.
        """
        return pulumi.get(self, "request_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Request Status.
        Available values: "open", "accepted", "reported", "approved", "completed", "declined".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def summary(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Brief description of the request.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter
    def tlp(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The CISA defined Traffic Light Protocol (TLP).
        Available values: "clear", "amber", "amber-strict", "green", "red".
        """
        return pulumi.get(self, "tlp")

    @property
    @pulumi.getter
    def tokens(self) -> pulumi.Output[builtins.int]:
        """
        Tokens for the request.
        """
        return pulumi.get(self, "tokens")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated")

