# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CloudforceOneRequestMessageArgs', 'CloudforceOneRequestMessage']

@pulumi.input_type
class CloudforceOneRequestMessageArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 request_id: pulumi.Input[builtins.str],
                 content: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CloudforceOneRequestMessage resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.str] request_id: UUID.
        :param pulumi.Input[builtins.str] content: Content of message.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "request_id", request_id)
        if content is not None:
            pulumi.set(__self__, "content", content)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Input[builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Content of message.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)


@pulumi.input_type
class _CloudforceOneRequestMessageState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 author: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 created: Optional[pulumi.Input[builtins.str]] = None,
                 is_follow_on_request: Optional[pulumi.Input[builtins.bool]] = None,
                 request_id: Optional[pulumi.Input[builtins.str]] = None,
                 updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CloudforceOneRequestMessage resources.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.str] author: Author of message.
        :param pulumi.Input[builtins.str] content: Content of message.
        :param pulumi.Input[builtins.str] created: Defines the message creation time.
        :param pulumi.Input[builtins.bool] is_follow_on_request: Whether the message is a follow-on request.
        :param pulumi.Input[builtins.str] request_id: UUID.
        :param pulumi.Input[builtins.str] updated: Defines the message last updated time.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if is_follow_on_request is not None:
            pulumi.set(__self__, "is_follow_on_request", is_follow_on_request)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Author of message.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Content of message.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the message creation time.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter(name="isFollowOnRequest")
    def is_follow_on_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the message is a follow-on request.
        """
        return pulumi.get(self, "is_follow_on_request")

    @is_follow_on_request.setter
    def is_follow_on_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_follow_on_request", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID.
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines the message last updated time.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated", value)


@pulumi.type_token("cloudflare:index/cloudforceOneRequestMessage:CloudforceOneRequestMessage")
class CloudforceOneRequestMessage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 request_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_cloudforce_one_request_message = cloudflare.CloudforceOneRequestMessage("example_cloudforce_one_request_message",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            request_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
            content="Can you elaborate on the type of DoS that occurred?")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/cloudforceOneRequestMessage:CloudforceOneRequestMessage example '<account_id>/<request_id>/<page>/<per_page>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.str] content: Content of message.
        :param pulumi.Input[builtins.str] request_id: UUID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudforceOneRequestMessageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_cloudforce_one_request_message = cloudflare.CloudforceOneRequestMessage("example_cloudforce_one_request_message",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            request_id="f174e90a-fafe-4643-bbbc-4a0ed4fc8415",
            content="Can you elaborate on the type of DoS that occurred?")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/cloudforceOneRequestMessage:CloudforceOneRequestMessage example '<account_id>/<request_id>/<page>/<per_page>'
        ```

        :param str resource_name: The name of the resource.
        :param CloudforceOneRequestMessageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudforceOneRequestMessageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 request_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudforceOneRequestMessageArgs.__new__(CloudforceOneRequestMessageArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["content"] = content
            if request_id is None and not opts.urn:
                raise TypeError("Missing required property 'request_id'")
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["author"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["is_follow_on_request"] = None
            __props__.__dict__["updated"] = None
        super(CloudforceOneRequestMessage, __self__).__init__(
            'cloudflare:index/cloudforceOneRequestMessage:CloudforceOneRequestMessage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            author: Optional[pulumi.Input[builtins.str]] = None,
            content: Optional[pulumi.Input[builtins.str]] = None,
            created: Optional[pulumi.Input[builtins.str]] = None,
            is_follow_on_request: Optional[pulumi.Input[builtins.bool]] = None,
            request_id: Optional[pulumi.Input[builtins.str]] = None,
            updated: Optional[pulumi.Input[builtins.str]] = None) -> 'CloudforceOneRequestMessage':
        """
        Get an existing CloudforceOneRequestMessage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Identifier.
        :param pulumi.Input[builtins.str] author: Author of message.
        :param pulumi.Input[builtins.str] content: Content of message.
        :param pulumi.Input[builtins.str] created: Defines the message creation time.
        :param pulumi.Input[builtins.bool] is_follow_on_request: Whether the message is a follow-on request.
        :param pulumi.Input[builtins.str] request_id: UUID.
        :param pulumi.Input[builtins.str] updated: Defines the message last updated time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudforceOneRequestMessageState.__new__(_CloudforceOneRequestMessageState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["author"] = author
        __props__.__dict__["content"] = content
        __props__.__dict__["created"] = created
        __props__.__dict__["is_follow_on_request"] = is_follow_on_request
        __props__.__dict__["request_id"] = request_id
        __props__.__dict__["updated"] = updated
        return CloudforceOneRequestMessage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[builtins.str]:
        """
        Author of message.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Content of message.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[builtins.str]:
        """
        Defines the message creation time.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="isFollowOnRequest")
    def is_follow_on_request(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the message is a follow-on request.
        """
        return pulumi.get(self, "is_follow_on_request")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[builtins.str]:
        """
        UUID.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[builtins.str]:
        """
        Defines the message last updated time.
        """
        return pulumi.get(self, "updated")

