# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContentScanningExpressionArgs', 'ContentScanningExpression']

@pulumi.input_type
class ContentScanningExpressionArgs:
    def __init__(__self__, *,
                 bodies: pulumi.Input[Sequence[pulumi.Input['ContentScanningExpressionBodyArgs']]],
                 zone_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ContentScanningExpression resource.
        :param pulumi.Input[builtins.str] zone_id: Defines an identifier.
        """
        pulumi.set(__self__, "bodies", bodies)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def bodies(self) -> pulumi.Input[Sequence[pulumi.Input['ContentScanningExpressionBodyArgs']]]:
        return pulumi.get(self, "bodies")

    @bodies.setter
    def bodies(self, value: pulumi.Input[Sequence[pulumi.Input['ContentScanningExpressionBodyArgs']]]):
        pulumi.set(self, "bodies", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _ContentScanningExpressionState:
    def __init__(__self__, *,
                 bodies: Optional[pulumi.Input[Sequence[pulumi.Input['ContentScanningExpressionBodyArgs']]]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContentScanningExpression resources.
        :param pulumi.Input[builtins.str] zone_id: Defines an identifier.
        """
        if bodies is not None:
            pulumi.set(__self__, "bodies", bodies)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def bodies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContentScanningExpressionBodyArgs']]]]:
        return pulumi.get(self, "bodies")

    @bodies.setter
    def bodies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContentScanningExpressionBodyArgs']]]]):
        pulumi.set(self, "bodies", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/contentScanningExpression:ContentScanningExpression")
class ContentScanningExpression(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bodies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContentScanningExpressionBodyArgs', 'ContentScanningExpressionBodyArgsDict']]]]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_content_scanning_expression = cloudflare.ContentScanningExpression("example_content_scanning_expression",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            bodies=[{
                "payload": "lookup_json_string(http.request.body.raw, \\"file\\")",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] zone_id: Defines an identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContentScanningExpressionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_content_scanning_expression = cloudflare.ContentScanningExpression("example_content_scanning_expression",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            bodies=[{
                "payload": "lookup_json_string(http.request.body.raw, \\"file\\")",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ContentScanningExpressionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContentScanningExpressionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bodies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContentScanningExpressionBodyArgs', 'ContentScanningExpressionBodyArgsDict']]]]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContentScanningExpressionArgs.__new__(ContentScanningExpressionArgs)

            if bodies is None and not opts.urn:
                raise TypeError("Missing required property 'bodies'")
            __props__.__dict__["bodies"] = bodies
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(ContentScanningExpression, __self__).__init__(
            'cloudflare:index/contentScanningExpression:ContentScanningExpression',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bodies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContentScanningExpressionBodyArgs', 'ContentScanningExpressionBodyArgsDict']]]]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ContentScanningExpression':
        """
        Get an existing ContentScanningExpression resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] zone_id: Defines an identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContentScanningExpressionState.__new__(_ContentScanningExpressionState)

        __props__.__dict__["bodies"] = bodies
        __props__.__dict__["zone_id"] = zone_id
        return ContentScanningExpression(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bodies(self) -> pulumi.Output[Sequence['outputs.ContentScanningExpressionBody']]:
        return pulumi.get(self, "bodies")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Defines an identifier.
        """
        return pulumi.get(self, "zone_id")

