# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['D1DatabaseArgs', 'D1Database']

@pulumi.input_type
class D1DatabaseArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 primary_location_hint: Optional[pulumi.Input[builtins.str]] = None,
                 read_replication: Optional[pulumi.Input['D1DatabaseReadReplicationArgs']] = None):
        """
        The set of arguments for constructing a D1Database resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] name: D1 database name.
        :param pulumi.Input[builtins.str] primary_location_hint: Specify the region to create the D1 primary, if available. If this option is omitted, the D1 will be created as close as possible to the current user.
               Available values: "wnam", "enam", "weur", "eeur", "apac", "oc".
        :param pulumi.Input['D1DatabaseReadReplicationArgs'] read_replication: Configuration for D1 read replication.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "name", name)
        if primary_location_hint is not None:
            pulumi.set(__self__, "primary_location_hint", primary_location_hint)
        if read_replication is not None:
            pulumi.set(__self__, "read_replication", read_replication)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        D1 database name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryLocationHint")
    def primary_location_hint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the region to create the D1 primary, if available. If this option is omitted, the D1 will be created as close as possible to the current user.
        Available values: "wnam", "enam", "weur", "eeur", "apac", "oc".
        """
        return pulumi.get(self, "primary_location_hint")

    @primary_location_hint.setter
    def primary_location_hint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_location_hint", value)

    @property
    @pulumi.getter(name="readReplication")
    def read_replication(self) -> Optional[pulumi.Input['D1DatabaseReadReplicationArgs']]:
        """
        Configuration for D1 read replication.
        """
        return pulumi.get(self, "read_replication")

    @read_replication.setter
    def read_replication(self, value: Optional[pulumi.Input['D1DatabaseReadReplicationArgs']]):
        pulumi.set(self, "read_replication", value)


@pulumi.input_type
class _D1DatabaseState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 file_size: Optional[pulumi.Input[builtins.float]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 num_tables: Optional[pulumi.Input[builtins.float]] = None,
                 primary_location_hint: Optional[pulumi.Input[builtins.str]] = None,
                 read_replication: Optional[pulumi.Input['D1DatabaseReadReplicationArgs']] = None,
                 uuid: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering D1Database resources.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] created_at: Specifies the timestamp the resource was created as an ISO8601 string.
        :param pulumi.Input[builtins.float] file_size: The D1 database's size, in bytes.
        :param pulumi.Input[builtins.str] name: D1 database name.
        :param pulumi.Input[builtins.str] primary_location_hint: Specify the region to create the D1 primary, if available. If this option is omitted, the D1 will be created as close as possible to the current user.
               Available values: "wnam", "enam", "weur", "eeur", "apac", "oc".
        :param pulumi.Input['D1DatabaseReadReplicationArgs'] read_replication: Configuration for D1 read replication.
        :param pulumi.Input[builtins.str] uuid: D1 database identifier (UUID).
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if file_size is not None:
            pulumi.set(__self__, "file_size", file_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if num_tables is not None:
            pulumi.set(__self__, "num_tables", num_tables)
        if primary_location_hint is not None:
            pulumi.set(__self__, "primary_location_hint", primary_location_hint)
        if read_replication is not None:
            pulumi.set(__self__, "read_replication", read_replication)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the timestamp the resource was created as an ISO8601 string.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="fileSize")
    def file_size(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The D1 database's size, in bytes.
        """
        return pulumi.get(self, "file_size")

    @file_size.setter
    def file_size(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "file_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        D1 database name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numTables")
    def num_tables(self) -> Optional[pulumi.Input[builtins.float]]:
        return pulumi.get(self, "num_tables")

    @num_tables.setter
    def num_tables(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "num_tables", value)

    @property
    @pulumi.getter(name="primaryLocationHint")
    def primary_location_hint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the region to create the D1 primary, if available. If this option is omitted, the D1 will be created as close as possible to the current user.
        Available values: "wnam", "enam", "weur", "eeur", "apac", "oc".
        """
        return pulumi.get(self, "primary_location_hint")

    @primary_location_hint.setter
    def primary_location_hint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_location_hint", value)

    @property
    @pulumi.getter(name="readReplication")
    def read_replication(self) -> Optional[pulumi.Input['D1DatabaseReadReplicationArgs']]:
        """
        Configuration for D1 read replication.
        """
        return pulumi.get(self, "read_replication")

    @read_replication.setter
    def read_replication(self, value: Optional[pulumi.Input['D1DatabaseReadReplicationArgs']]):
        pulumi.set(self, "read_replication", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        D1 database identifier (UUID).
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("cloudflare:index/d1Database:D1Database")
class D1Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_location_hint: Optional[pulumi.Input[builtins.str]] = None,
                 read_replication: Optional[pulumi.Input[Union['D1DatabaseReadReplicationArgs', 'D1DatabaseReadReplicationArgsDict']]] = None,
                 __props__=None):
        """
        !> When a D1 Database is replaced all the data is lost. Please ensure you have a
           backup of your data before replacing a D1 Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_d1_database = cloudflare.D1Database("example_d1_database",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="my-database",
            primary_location_hint="wnam")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/d1Database:D1Database example '<account_id>/<database_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] name: D1 database name.
        :param pulumi.Input[builtins.str] primary_location_hint: Specify the region to create the D1 primary, if available. If this option is omitted, the D1 will be created as close as possible to the current user.
               Available values: "wnam", "enam", "weur", "eeur", "apac", "oc".
        :param pulumi.Input[Union['D1DatabaseReadReplicationArgs', 'D1DatabaseReadReplicationArgsDict']] read_replication: Configuration for D1 read replication.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: D1DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> When a D1 Database is replaced all the data is lost. Please ensure you have a
           backup of your data before replacing a D1 Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_d1_database = cloudflare.D1Database("example_d1_database",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="my-database",
            primary_location_hint="wnam")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/d1Database:D1Database example '<account_id>/<database_id>'
        ```

        :param str resource_name: The name of the resource.
        :param D1DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(D1DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_location_hint: Optional[pulumi.Input[builtins.str]] = None,
                 read_replication: Optional[pulumi.Input[Union['D1DatabaseReadReplicationArgs', 'D1DatabaseReadReplicationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = D1DatabaseArgs.__new__(D1DatabaseArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_location_hint"] = primary_location_hint
            __props__.__dict__["read_replication"] = read_replication
            __props__.__dict__["created_at"] = None
            __props__.__dict__["file_size"] = None
            __props__.__dict__["num_tables"] = None
            __props__.__dict__["uuid"] = None
            __props__.__dict__["version"] = None
        super(D1Database, __self__).__init__(
            'cloudflare:index/d1Database:D1Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            file_size: Optional[pulumi.Input[builtins.float]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            num_tables: Optional[pulumi.Input[builtins.float]] = None,
            primary_location_hint: Optional[pulumi.Input[builtins.str]] = None,
            read_replication: Optional[pulumi.Input[Union['D1DatabaseReadReplicationArgs', 'D1DatabaseReadReplicationArgsDict']]] = None,
            uuid: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'D1Database':
        """
        Get an existing D1Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account identifier tag.
        :param pulumi.Input[builtins.str] created_at: Specifies the timestamp the resource was created as an ISO8601 string.
        :param pulumi.Input[builtins.float] file_size: The D1 database's size, in bytes.
        :param pulumi.Input[builtins.str] name: D1 database name.
        :param pulumi.Input[builtins.str] primary_location_hint: Specify the region to create the D1 primary, if available. If this option is omitted, the D1 will be created as close as possible to the current user.
               Available values: "wnam", "enam", "weur", "eeur", "apac", "oc".
        :param pulumi.Input[Union['D1DatabaseReadReplicationArgs', 'D1DatabaseReadReplicationArgsDict']] read_replication: Configuration for D1 read replication.
        :param pulumi.Input[builtins.str] uuid: D1 database identifier (UUID).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _D1DatabaseState.__new__(_D1DatabaseState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["file_size"] = file_size
        __props__.__dict__["name"] = name
        __props__.__dict__["num_tables"] = num_tables
        __props__.__dict__["primary_location_hint"] = primary_location_hint
        __props__.__dict__["read_replication"] = read_replication
        __props__.__dict__["uuid"] = uuid
        __props__.__dict__["version"] = version
        return D1Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the timestamp the resource was created as an ISO8601 string.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="fileSize")
    def file_size(self) -> pulumi.Output[builtins.float]:
        """
        The D1 database's size, in bytes.
        """
        return pulumi.get(self, "file_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        D1 database name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numTables")
    def num_tables(self) -> pulumi.Output[builtins.float]:
        return pulumi.get(self, "num_tables")

    @property
    @pulumi.getter(name="primaryLocationHint")
    def primary_location_hint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify the region to create the D1 primary, if available. If this option is omitted, the D1 will be created as close as possible to the current user.
        Available values: "wnam", "enam", "weur", "eeur", "apac", "oc".
        """
        return pulumi.get(self, "primary_location_hint")

    @property
    @pulumi.getter(name="readReplication")
    def read_replication(self) -> pulumi.Output[Optional['outputs.D1DatabaseReadReplication']]:
        """
        Configuration for D1 read replication.
        """
        return pulumi.get(self, "read_replication")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[builtins.str]:
        """
        D1 database identifier (UUID).
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "version")

