# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DlpCustomProfileArgs', 'DlpCustomProfile']

@pulumi.input_type
class DlpCustomProfileArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 entries: pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileEntryArgs']]],
                 name: pulumi.Input[builtins.str],
                 ai_context_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input['DlpCustomProfileContextAwarenessArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ocr_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 shared_entries: Optional[pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileSharedEntryArgs']]]] = None):
        """
        The set of arguments for constructing a DlpCustomProfile resource.
        :param pulumi.Input[builtins.int] allowed_match_count: Related DLP policies will trigger when the match count exceeds the number set.
        :param pulumi.Input['DlpCustomProfileContextAwarenessArgs'] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        :param pulumi.Input[builtins.str] description: The description of the profile.
        :param pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileSharedEntryArgs']]] shared_entries: Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "entries", entries)
        pulumi.set(__self__, "name", name)
        if ai_context_enabled is not None:
            pulumi.set(__self__, "ai_context_enabled", ai_context_enabled)
        if allowed_match_count is not None:
            pulumi.set(__self__, "allowed_match_count", allowed_match_count)
        if confidence_threshold is not None:
            pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if context_awareness is not None:
            pulumi.set(__self__, "context_awareness", context_awareness)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ocr_enabled is not None:
            pulumi.set(__self__, "ocr_enabled", ocr_enabled)
        if shared_entries is not None:
            pulumi.set(__self__, "shared_entries", shared_entries)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileEntryArgs']]]:
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileEntryArgs']]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="aiContextEnabled")
    def ai_context_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "ai_context_enabled")

    @ai_context_enabled.setter
    def ai_context_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ai_context_enabled", value)

    @property
    @pulumi.getter(name="allowedMatchCount")
    def allowed_match_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Related DLP policies will trigger when the match count exceeds the number set.
        """
        return pulumi.get(self, "allowed_match_count")

    @allowed_match_count.setter
    def allowed_match_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allowed_match_count", value)

    @property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "confidence_threshold")

    @confidence_threshold.setter
    def confidence_threshold(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "confidence_threshold", value)

    @property
    @pulumi.getter(name="contextAwareness")
    def context_awareness(self) -> Optional[pulumi.Input['DlpCustomProfileContextAwarenessArgs']]:
        """
        Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        return pulumi.get(self, "context_awareness")

    @context_awareness.setter
    def context_awareness(self, value: Optional[pulumi.Input['DlpCustomProfileContextAwarenessArgs']]):
        pulumi.set(self, "context_awareness", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ocrEnabled")
    def ocr_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "ocr_enabled")

    @ocr_enabled.setter
    def ocr_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ocr_enabled", value)

    @property
    @pulumi.getter(name="sharedEntries")
    def shared_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileSharedEntryArgs']]]]:
        """
        Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        """
        return pulumi.get(self, "shared_entries")

    @shared_entries.setter
    def shared_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileSharedEntryArgs']]]]):
        pulumi.set(self, "shared_entries", value)


@pulumi.input_type
class _DlpCustomProfileState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 ai_context_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input['DlpCustomProfileContextAwarenessArgs']] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileEntryArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocr_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 open_access: Optional[pulumi.Input[builtins.bool]] = None,
                 shared_entries: Optional[pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileSharedEntryArgs']]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DlpCustomProfile resources.
        :param pulumi.Input[builtins.int] allowed_match_count: Related DLP policies will trigger when the match count exceeds the number set.
        :param pulumi.Input['DlpCustomProfileContextAwarenessArgs'] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        :param pulumi.Input[builtins.str] created_at: When the profile was created.
        :param pulumi.Input[builtins.str] description: The description of the profile.
        :param pulumi.Input[builtins.bool] open_access: Whether this profile can be accessed by anyone.
        :param pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileSharedEntryArgs']]] shared_entries: Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        :param pulumi.Input[builtins.str] type: Available values: "custom", "predefined", "integration".
        :param pulumi.Input[builtins.str] updated_at: When the profile was lasted updated.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if ai_context_enabled is not None:
            pulumi.set(__self__, "ai_context_enabled", ai_context_enabled)
        if allowed_match_count is not None:
            pulumi.set(__self__, "allowed_match_count", allowed_match_count)
        if confidence_threshold is not None:
            pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if context_awareness is not None:
            pulumi.set(__self__, "context_awareness", context_awareness)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ocr_enabled is not None:
            pulumi.set(__self__, "ocr_enabled", ocr_enabled)
        if open_access is not None:
            pulumi.set(__self__, "open_access", open_access)
        if shared_entries is not None:
            pulumi.set(__self__, "shared_entries", shared_entries)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="aiContextEnabled")
    def ai_context_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "ai_context_enabled")

    @ai_context_enabled.setter
    def ai_context_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ai_context_enabled", value)

    @property
    @pulumi.getter(name="allowedMatchCount")
    def allowed_match_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Related DLP policies will trigger when the match count exceeds the number set.
        """
        return pulumi.get(self, "allowed_match_count")

    @allowed_match_count.setter
    def allowed_match_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "allowed_match_count", value)

    @property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "confidence_threshold")

    @confidence_threshold.setter
    def confidence_threshold(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "confidence_threshold", value)

    @property
    @pulumi.getter(name="contextAwareness")
    def context_awareness(self) -> Optional[pulumi.Input['DlpCustomProfileContextAwarenessArgs']]:
        """
        Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        return pulumi.get(self, "context_awareness")

    @context_awareness.setter
    def context_awareness(self, value: Optional[pulumi.Input['DlpCustomProfileContextAwarenessArgs']]):
        pulumi.set(self, "context_awareness", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the profile was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileEntryArgs']]]]:
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="ocrEnabled")
    def ocr_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "ocr_enabled")

    @ocr_enabled.setter
    def ocr_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ocr_enabled", value)

    @property
    @pulumi.getter(name="openAccess")
    def open_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether this profile can be accessed by anyone.
        """
        return pulumi.get(self, "open_access")

    @open_access.setter
    def open_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "open_access", value)

    @property
    @pulumi.getter(name="sharedEntries")
    def shared_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileSharedEntryArgs']]]]:
        """
        Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        """
        return pulumi.get(self, "shared_entries")

    @shared_entries.setter
    def shared_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DlpCustomProfileSharedEntryArgs']]]]):
        pulumi.set(self, "shared_entries", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Available values: "custom", "predefined", "integration".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the profile was lasted updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


warnings.warn("""cloudflare.index/dlpcustomprofile.DlpCustomProfile has been deprecated in favor of cloudflare.index/zerotrustdlpcustomprofile.ZeroTrustDlpCustomProfile""", DeprecationWarning)


@pulumi.type_token("cloudflare:index/dlpCustomProfile:DlpCustomProfile")
class DlpCustomProfile(pulumi.CustomResource):
    warnings.warn("""cloudflare.index/dlpcustomprofile.DlpCustomProfile has been deprecated in favor of cloudflare.index/zerotrustdlpcustomprofile.ZeroTrustDlpCustomProfile""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 ai_context_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input[Union['DlpCustomProfileContextAwarenessArgs', 'DlpCustomProfileContextAwarenessArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DlpCustomProfileEntryArgs', 'DlpCustomProfileEntryArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocr_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 shared_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DlpCustomProfileSharedEntryArgs', 'DlpCustomProfileSharedEntryArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/dlpCustomProfile:DlpCustomProfile example '<account_id>/<profile_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] allowed_match_count: Related DLP policies will trigger when the match count exceeds the number set.
        :param pulumi.Input[Union['DlpCustomProfileContextAwarenessArgs', 'DlpCustomProfileContextAwarenessArgsDict']] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        :param pulumi.Input[builtins.str] description: The description of the profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DlpCustomProfileSharedEntryArgs', 'DlpCustomProfileSharedEntryArgsDict']]]] shared_entries: Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DlpCustomProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import cloudflare:index/dlpCustomProfile:DlpCustomProfile example '<account_id>/<profile_id>'
        ```

        :param str resource_name: The name of the resource.
        :param DlpCustomProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DlpCustomProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 ai_context_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_match_count: Optional[pulumi.Input[builtins.int]] = None,
                 confidence_threshold: Optional[pulumi.Input[builtins.str]] = None,
                 context_awareness: Optional[pulumi.Input[Union['DlpCustomProfileContextAwarenessArgs', 'DlpCustomProfileContextAwarenessArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DlpCustomProfileEntryArgs', 'DlpCustomProfileEntryArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 ocr_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 shared_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DlpCustomProfileSharedEntryArgs', 'DlpCustomProfileSharedEntryArgsDict']]]]] = None,
                 __props__=None):
        pulumi.log.warn("""DlpCustomProfile is deprecated: cloudflare.index/dlpcustomprofile.DlpCustomProfile has been deprecated in favor of cloudflare.index/zerotrustdlpcustomprofile.ZeroTrustDlpCustomProfile""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DlpCustomProfileArgs.__new__(DlpCustomProfileArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["ai_context_enabled"] = ai_context_enabled
            __props__.__dict__["allowed_match_count"] = allowed_match_count
            __props__.__dict__["confidence_threshold"] = confidence_threshold
            __props__.__dict__["context_awareness"] = context_awareness
            __props__.__dict__["description"] = description
            if entries is None and not opts.urn:
                raise TypeError("Missing required property 'entries'")
            __props__.__dict__["entries"] = entries
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["ocr_enabled"] = ocr_enabled
            __props__.__dict__["shared_entries"] = shared_entries
            __props__.__dict__["created_at"] = None
            __props__.__dict__["open_access"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="cloudflare:index/dlpCustomProfile:DlpCustomProfile")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(DlpCustomProfile, __self__).__init__(
            'cloudflare:index/dlpCustomProfile:DlpCustomProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            ai_context_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            allowed_match_count: Optional[pulumi.Input[builtins.int]] = None,
            confidence_threshold: Optional[pulumi.Input[builtins.str]] = None,
            context_awareness: Optional[pulumi.Input[Union['DlpCustomProfileContextAwarenessArgs', 'DlpCustomProfileContextAwarenessArgsDict']]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DlpCustomProfileEntryArgs', 'DlpCustomProfileEntryArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            ocr_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            open_access: Optional[pulumi.Input[builtins.bool]] = None,
            shared_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DlpCustomProfileSharedEntryArgs', 'DlpCustomProfileSharedEntryArgsDict']]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'DlpCustomProfile':
        """
        Get an existing DlpCustomProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] allowed_match_count: Related DLP policies will trigger when the match count exceeds the number set.
        :param pulumi.Input[Union['DlpCustomProfileContextAwarenessArgs', 'DlpCustomProfileContextAwarenessArgsDict']] context_awareness: Scan the context of predefined entries to only return matches surrounded by keywords.
        :param pulumi.Input[builtins.str] created_at: When the profile was created.
        :param pulumi.Input[builtins.str] description: The description of the profile.
        :param pulumi.Input[builtins.bool] open_access: Whether this profile can be accessed by anyone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DlpCustomProfileSharedEntryArgs', 'DlpCustomProfileSharedEntryArgsDict']]]] shared_entries: Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        :param pulumi.Input[builtins.str] type: Available values: "custom", "predefined", "integration".
        :param pulumi.Input[builtins.str] updated_at: When the profile was lasted updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DlpCustomProfileState.__new__(_DlpCustomProfileState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["ai_context_enabled"] = ai_context_enabled
        __props__.__dict__["allowed_match_count"] = allowed_match_count
        __props__.__dict__["confidence_threshold"] = confidence_threshold
        __props__.__dict__["context_awareness"] = context_awareness
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["entries"] = entries
        __props__.__dict__["name"] = name
        __props__.__dict__["ocr_enabled"] = ocr_enabled
        __props__.__dict__["open_access"] = open_access
        __props__.__dict__["shared_entries"] = shared_entries
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return DlpCustomProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="aiContextEnabled")
    def ai_context_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "ai_context_enabled")

    @property
    @pulumi.getter(name="allowedMatchCount")
    def allowed_match_count(self) -> pulumi.Output[builtins.int]:
        """
        Related DLP policies will trigger when the match count exceeds the number set.
        """
        return pulumi.get(self, "allowed_match_count")

    @property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "confidence_threshold")

    @property
    @pulumi.getter(name="contextAwareness")
    def context_awareness(self) -> pulumi.Output[Optional['outputs.DlpCustomProfileContextAwareness']]:
        """
        Scan the context of predefined entries to only return matches surrounded by keywords.
        """
        return pulumi.get(self, "context_awareness")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        When the profile was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Sequence['outputs.DlpCustomProfileEntry']]:
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ocrEnabled")
    def ocr_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "ocr_enabled")

    @property
    @pulumi.getter(name="openAccess")
    def open_access(self) -> pulumi.Output[builtins.bool]:
        """
        Whether this profile can be accessed by anyone.
        """
        return pulumi.get(self, "open_access")

    @property
    @pulumi.getter(name="sharedEntries")
    def shared_entries(self) -> pulumi.Output[Optional[Sequence['outputs.DlpCustomProfileSharedEntry']]]:
        """
        Entries from other profiles (e.g. pre-defined Cloudflare profiles, or your Microsoft Information Protection profiles).
        """
        return pulumi.get(self, "shared_entries")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Available values: "custom", "predefined", "integration".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        When the profile was lasted updated.
        """
        return pulumi.get(self, "updated_at")

