# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EmailRoutingDnsArgs', 'EmailRoutingDns']

@pulumi.input_type
class EmailRoutingDnsArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 zone_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a EmailRoutingDns resource.
        :param pulumi.Input[builtins.str] name: Domain of your zone.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Domain of your zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _EmailRoutingDnsState:
    def __init__(__self__, *,
                 created: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['EmailRoutingDnsErrorArgs']]]] = None,
                 messages: Optional[pulumi.Input[Sequence[pulumi.Input['EmailRoutingDnsMessageArgs']]]] = None,
                 modified: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 result: Optional[pulumi.Input['EmailRoutingDnsResultArgs']] = None,
                 result_info: Optional[pulumi.Input['EmailRoutingDnsResultInfoArgs']] = None,
                 skip_wizard: Optional[pulumi.Input[builtins.bool]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 success: Optional[pulumi.Input[builtins.bool]] = None,
                 tag: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EmailRoutingDns resources.
        :param pulumi.Input[builtins.str] created: The date and time the settings have been created.
        :param pulumi.Input[builtins.bool] enabled: State of the zone settings for Email Routing.
        :param pulumi.Input[builtins.str] modified: The date and time the settings have been modified.
        :param pulumi.Input[builtins.str] name: Domain of your zone.
        :param pulumi.Input[builtins.bool] skip_wizard: Flag to check if the user skipped the configuration wizard.
        :param pulumi.Input[builtins.str] status: Show the state of your account, and the type or configuration error.
               Available values: "ready", "unconfigured", "misconfigured", "misconfigured/locked", "unlocked".
        :param pulumi.Input[builtins.bool] success: Whether the API call was successful.
        :param pulumi.Input[builtins.str] tag: Email Routing settings tag. (Deprecated, replaced by Email Routing settings identifier)
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        if created is not None:
            pulumi.set(__self__, "created", created)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)
        if modified is not None:
            pulumi.set(__self__, "modified", modified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if result is not None:
            pulumi.set(__self__, "result", result)
        if result_info is not None:
            pulumi.set(__self__, "result_info", result_info)
        if skip_wizard is not None:
            pulumi.set(__self__, "skip_wizard", skip_wizard)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if success is not None:
            pulumi.set(__self__, "success", success)
        if tag is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""tag is deprecated: This attribute is deprecated.""")
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the settings have been created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        State of the zone settings for Email Routing.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EmailRoutingDnsErrorArgs']]]]:
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EmailRoutingDnsErrorArgs']]]]):
        pulumi.set(self, "errors", value)

    @property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EmailRoutingDnsMessageArgs']]]]:
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EmailRoutingDnsMessageArgs']]]]):
        pulumi.set(self, "messages", value)

    @property
    @pulumi.getter
    def modified(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the settings have been modified.
        """
        return pulumi.get(self, "modified")

    @modified.setter
    def modified(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Domain of your zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def result(self) -> Optional[pulumi.Input['EmailRoutingDnsResultArgs']]:
        return pulumi.get(self, "result")

    @result.setter
    def result(self, value: Optional[pulumi.Input['EmailRoutingDnsResultArgs']]):
        pulumi.set(self, "result", value)

    @property
    @pulumi.getter(name="resultInfo")
    def result_info(self) -> Optional[pulumi.Input['EmailRoutingDnsResultInfoArgs']]:
        return pulumi.get(self, "result_info")

    @result_info.setter
    def result_info(self, value: Optional[pulumi.Input['EmailRoutingDnsResultInfoArgs']]):
        pulumi.set(self, "result_info", value)

    @property
    @pulumi.getter(name="skipWizard")
    def skip_wizard(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Flag to check if the user skipped the configuration wizard.
        """
        return pulumi.get(self, "skip_wizard")

    @skip_wizard.setter
    def skip_wizard(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_wizard", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Show the state of your account, and the type or configuration error.
        Available values: "ready", "unconfigured", "misconfigured", "misconfigured/locked", "unlocked".
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def success(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the API call was successful.
        """
        return pulumi.get(self, "success")

    @success.setter
    def success(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "success", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email Routing settings tag. (Deprecated, replaced by Email Routing settings identifier)
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tag", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("cloudflare:index/emailRoutingDns:EmailRoutingDns")
class EmailRoutingDns(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_email_routing_dns = cloudflare.EmailRoutingDns("example_email_routing_dns",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="example.net")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/emailRoutingDns:EmailRoutingDns example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: Domain of your zone.
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmailRoutingDnsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_email_routing_dns = cloudflare.EmailRoutingDns("example_email_routing_dns",
            zone_id="023e105f4ecef8ad9ca31a8372d0c353",
            name="example.net")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/emailRoutingDns:EmailRoutingDns example '<zone_id>'
        ```

        :param str resource_name: The name of the resource.
        :param EmailRoutingDnsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmailRoutingDnsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmailRoutingDnsArgs.__new__(EmailRoutingDnsArgs)

            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created"] = None
            __props__.__dict__["enabled"] = None
            __props__.__dict__["errors"] = None
            __props__.__dict__["messages"] = None
            __props__.__dict__["modified"] = None
            __props__.__dict__["result"] = None
            __props__.__dict__["result_info"] = None
            __props__.__dict__["skip_wizard"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["success"] = None
            __props__.__dict__["tag"] = None
        super(EmailRoutingDns, __self__).__init__(
            'cloudflare:index/emailRoutingDns:EmailRoutingDns',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EmailRoutingDnsErrorArgs', 'EmailRoutingDnsErrorArgsDict']]]]] = None,
            messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EmailRoutingDnsMessageArgs', 'EmailRoutingDnsMessageArgsDict']]]]] = None,
            modified: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            result: Optional[pulumi.Input[Union['EmailRoutingDnsResultArgs', 'EmailRoutingDnsResultArgsDict']]] = None,
            result_info: Optional[pulumi.Input[Union['EmailRoutingDnsResultInfoArgs', 'EmailRoutingDnsResultInfoArgsDict']]] = None,
            skip_wizard: Optional[pulumi.Input[builtins.bool]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            success: Optional[pulumi.Input[builtins.bool]] = None,
            tag: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'EmailRoutingDns':
        """
        Get an existing EmailRoutingDns resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created: The date and time the settings have been created.
        :param pulumi.Input[builtins.bool] enabled: State of the zone settings for Email Routing.
        :param pulumi.Input[builtins.str] modified: The date and time the settings have been modified.
        :param pulumi.Input[builtins.str] name: Domain of your zone.
        :param pulumi.Input[builtins.bool] skip_wizard: Flag to check if the user skipped the configuration wizard.
        :param pulumi.Input[builtins.str] status: Show the state of your account, and the type or configuration error.
               Available values: "ready", "unconfigured", "misconfigured", "misconfigured/locked", "unlocked".
        :param pulumi.Input[builtins.bool] success: Whether the API call was successful.
        :param pulumi.Input[builtins.str] tag: Email Routing settings tag. (Deprecated, replaced by Email Routing settings identifier)
        :param pulumi.Input[builtins.str] zone_id: Identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EmailRoutingDnsState.__new__(_EmailRoutingDnsState)

        __props__.__dict__["created"] = created
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["errors"] = errors
        __props__.__dict__["messages"] = messages
        __props__.__dict__["modified"] = modified
        __props__.__dict__["name"] = name
        __props__.__dict__["result"] = result
        __props__.__dict__["result_info"] = result_info
        __props__.__dict__["skip_wizard"] = skip_wizard
        __props__.__dict__["status"] = status
        __props__.__dict__["success"] = success
        __props__.__dict__["tag"] = tag
        __props__.__dict__["zone_id"] = zone_id
        return EmailRoutingDns(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the settings have been created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        State of the zone settings for Email Routing.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence['outputs.EmailRoutingDnsError']]:
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def messages(self) -> pulumi.Output[Sequence['outputs.EmailRoutingDnsMessage']]:
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter
    def modified(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the settings have been modified.
        """
        return pulumi.get(self, "modified")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Domain of your zone.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def result(self) -> pulumi.Output['outputs.EmailRoutingDnsResult']:
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="resultInfo")
    def result_info(self) -> pulumi.Output['outputs.EmailRoutingDnsResultInfo']:
        return pulumi.get(self, "result_info")

    @property
    @pulumi.getter(name="skipWizard")
    def skip_wizard(self) -> pulumi.Output[builtins.bool]:
        """
        Flag to check if the user skipped the configuration wizard.
        """
        return pulumi.get(self, "skip_wizard")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Show the state of your account, and the type or configuration error.
        Available values: "ready", "unconfigured", "misconfigured", "misconfigured/locked", "unlocked".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def success(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the API call was successful.
        """
        return pulumi.get(self, "success")

    @property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated.""")
    def tag(self) -> pulumi.Output[builtins.str]:
        """
        Email Routing settings tag. (Deprecated, replaced by Email Routing settings identifier)
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")

