# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EmailSecurityImpersonationRegistryArgs', 'EmailSecurityImpersonationRegistry']

@pulumi.input_type
class EmailSecurityImpersonationRegistryArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[builtins.str],
                 email: pulumi.Input[builtins.str],
                 is_email_regex: pulumi.Input[builtins.bool],
                 name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a EmailSecurityImpersonationRegistry resource.
        :param pulumi.Input[builtins.str] account_id: Account Identifier
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "is_email_regex", is_email_regex)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[builtins.str]:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="isEmailRegex")
    def is_email_regex(self) -> pulumi.Input[builtins.bool]:
        return pulumi.get(self, "is_email_regex")

    @is_email_regex.setter
    def is_email_regex(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_email_regex", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _EmailSecurityImpersonationRegistryState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 comments: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[builtins.int]] = None,
                 directory_node_id: Optional[pulumi.Input[builtins.int]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 external_directory_node_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_email_regex: Optional[pulumi.Input[builtins.bool]] = None,
                 last_modified: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 provenance: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EmailSecurityImpersonationRegistry resources.
        :param pulumi.Input[builtins.str] account_id: Account Identifier
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if directory_node_id is not None:
            pulumi.set(__self__, "directory_node_id", directory_node_id)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if external_directory_node_id is not None:
            warnings.warn("""This attribute is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""external_directory_node_id is deprecated: This attribute is deprecated.""")
        if external_directory_node_id is not None:
            pulumi.set(__self__, "external_directory_node_id", external_directory_node_id)
        if is_email_regex is not None:
            pulumi.set(__self__, "is_email_regex", is_email_regex)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provenance is not None:
            pulumi.set(__self__, "provenance", provenance)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comments", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter(name="directoryNodeId")
    def directory_node_id(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "directory_node_id")

    @directory_node_id.setter
    def directory_node_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "directory_node_id", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="externalDirectoryNodeId")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def external_directory_node_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "external_directory_node_id")

    @external_directory_node_id.setter
    def external_directory_node_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_directory_node_id", value)

    @property
    @pulumi.getter(name="isEmailRegex")
    def is_email_regex(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "is_email_regex")

    @is_email_regex.setter
    def is_email_regex(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_email_regex", value)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modified", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def provenance(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "provenance")

    @provenance.setter
    def provenance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provenance", value)


@pulumi.type_token("cloudflare:index/emailSecurityImpersonationRegistry:EmailSecurityImpersonationRegistry")
class EmailSecurityImpersonationRegistry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 is_email_regex: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_email_security_impersonation_registry = cloudflare.EmailSecurityImpersonationRegistry("example_email_security_impersonation_registry",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            email="email",
            is_email_regex=True,
            name="name")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/emailSecurityImpersonationRegistry:EmailSecurityImpersonationRegistry example '<account_id>/<display_name_id>'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account Identifier
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EmailSecurityImpersonationRegistryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudflare as cloudflare

        example_email_security_impersonation_registry = cloudflare.EmailSecurityImpersonationRegistry("example_email_security_impersonation_registry",
            account_id="023e105f4ecef8ad9ca31a8372d0c353",
            email="email",
            is_email_regex=True,
            name="name")
        ```

        ## Import

        ```sh
        $ pulumi import cloudflare:index/emailSecurityImpersonationRegistry:EmailSecurityImpersonationRegistry example '<account_id>/<display_name_id>'
        ```

        :param str resource_name: The name of the resource.
        :param EmailSecurityImpersonationRegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EmailSecurityImpersonationRegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[builtins.str]] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 is_email_regex: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EmailSecurityImpersonationRegistryArgs.__new__(EmailSecurityImpersonationRegistryArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if is_email_regex is None and not opts.urn:
                raise TypeError("Missing required property 'is_email_regex'")
            __props__.__dict__["is_email_regex"] = is_email_regex
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["comments"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["directory_id"] = None
            __props__.__dict__["directory_node_id"] = None
            __props__.__dict__["external_directory_node_id"] = None
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["provenance"] = None
        super(EmailSecurityImpersonationRegistry, __self__).__init__(
            'cloudflare:index/emailSecurityImpersonationRegistry:EmailSecurityImpersonationRegistry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[builtins.str]] = None,
            comments: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            directory_id: Optional[pulumi.Input[builtins.int]] = None,
            directory_node_id: Optional[pulumi.Input[builtins.int]] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            external_directory_node_id: Optional[pulumi.Input[builtins.str]] = None,
            is_email_regex: Optional[pulumi.Input[builtins.bool]] = None,
            last_modified: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            provenance: Optional[pulumi.Input[builtins.str]] = None) -> 'EmailSecurityImpersonationRegistry':
        """
        Get an existing EmailSecurityImpersonationRegistry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_id: Account Identifier
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EmailSecurityImpersonationRegistryState.__new__(_EmailSecurityImpersonationRegistryState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["comments"] = comments
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["directory_node_id"] = directory_node_id
        __props__.__dict__["email"] = email
        __props__.__dict__["external_directory_node_id"] = external_directory_node_id
        __props__.__dict__["is_email_regex"] = is_email_regex
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["name"] = name
        __props__.__dict__["provenance"] = provenance
        return EmailSecurityImpersonationRegistry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        Account Identifier
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def comments(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "comments")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="directoryNodeId")
    def directory_node_id(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "directory_node_id")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="externalDirectoryNodeId")
    @_utilities.deprecated("""This attribute is deprecated.""")
    def external_directory_node_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "external_directory_node_id")

    @property
    @pulumi.getter(name="isEmailRegex")
    def is_email_regex(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "is_email_regex")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def provenance(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "provenance")

