# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccessRuleResult',
    'AwaitableGetAccessRuleResult',
    'get_access_rule',
    'get_access_rule_output',
]

@pulumi.output_type
class GetAccessRuleResult:
    """
    A collection of values returned by getAccessRule.
    """
    def __init__(__self__, account_id=None, allowed_modes=None, configuration=None, created_on=None, filter=None, id=None, mode=None, modified_on=None, notes=None, rule_id=None, scope=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if allowed_modes and not isinstance(allowed_modes, list):
            raise TypeError("Expected argument 'allowed_modes' to be a list")
        pulumi.set(__self__, "allowed_modes", allowed_modes)
        if configuration and not isinstance(configuration, dict):
            raise TypeError("Expected argument 'configuration' to be a dict")
        pulumi.set(__self__, "configuration", configuration)
        if created_on and not isinstance(created_on, str):
            raise TypeError("Expected argument 'created_on' to be a str")
        pulumi.set(__self__, "created_on", created_on)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if notes and not isinstance(notes, str):
            raise TypeError("Expected argument 'notes' to be a str")
        pulumi.set(__self__, "notes", notes)
        if rule_id and not isinstance(rule_id, str):
            raise TypeError("Expected argument 'rule_id' to be a str")
        pulumi.set(__self__, "rule_id", rule_id)
        if scope and not isinstance(scope, dict):
            raise TypeError("Expected argument 'scope' to be a dict")
        pulumi.set(__self__, "scope", scope)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="allowedModes")
    def allowed_modes(self) -> Sequence[builtins.str]:
        """
        The available actions that a rule can apply to a matched request.
        """
        return pulumi.get(self, "allowed_modes")

    @property
    @pulumi.getter
    def configuration(self) -> 'outputs.GetAccessRuleConfigurationResult':
        """
        The rule configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> builtins.str:
        """
        The timestamp of when the rule was created.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetAccessRuleFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier for a rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The action to apply to a matched request.
        Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        """
        The timestamp of when the rule was last modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def notes(self) -> builtins.str:
        """
        An informative summary of the rule, typically used as a reminder or explanation.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[builtins.str]:
        """
        Unique identifier for a rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter
    def scope(self) -> 'outputs.GetAccessRuleScopeResult':
        """
        All zones owned by the user will have the rule applied.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetAccessRuleResult(GetAccessRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessRuleResult(
            account_id=self.account_id,
            allowed_modes=self.allowed_modes,
            configuration=self.configuration,
            created_on=self.created_on,
            filter=self.filter,
            id=self.id,
            mode=self.mode,
            modified_on=self.modified_on,
            notes=self.notes,
            rule_id=self.rule_id,
            scope=self.scope,
            zone_id=self.zone_id)


def get_access_rule(account_id: Optional[builtins.str] = None,
                    filter: Optional[Union['GetAccessRuleFilterArgs', 'GetAccessRuleFilterArgsDict']] = None,
                    rule_id: Optional[builtins.str] = None,
                    zone_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessRuleResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_access_rule = cloudflare.get_access_rule(rule_id="023e105f4ecef8ad9ca31a8372d0c353",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str rule_id: Unique identifier for a rule.
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['ruleId'] = rule_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccessRule:getAccessRule', __args__, opts=opts, typ=GetAccessRuleResult).value

    return AwaitableGetAccessRuleResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        allowed_modes=pulumi.get(__ret__, 'allowed_modes'),
        configuration=pulumi.get(__ret__, 'configuration'),
        created_on=pulumi.get(__ret__, 'created_on'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        mode=pulumi.get(__ret__, 'mode'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        notes=pulumi.get(__ret__, 'notes'),
        rule_id=pulumi.get(__ret__, 'rule_id'),
        scope=pulumi.get(__ret__, 'scope'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_access_rule_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           filter: Optional[pulumi.Input[Optional[Union['GetAccessRuleFilterArgs', 'GetAccessRuleFilterArgsDict']]]] = None,
                           rule_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           zone_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessRuleResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_access_rule = cloudflare.get_access_rule(rule_id="023e105f4ecef8ad9ca31a8372d0c353",
        account_id="account_id",
        zone_id="zone_id")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str rule_id: Unique identifier for a rule.
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['ruleId'] = rule_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccessRule:getAccessRule', __args__, opts=opts, typ=GetAccessRuleResult)
    return __ret__.apply(lambda __response__: GetAccessRuleResult(
        account_id=pulumi.get(__response__, 'account_id'),
        allowed_modes=pulumi.get(__response__, 'allowed_modes'),
        configuration=pulumi.get(__response__, 'configuration'),
        created_on=pulumi.get(__response__, 'created_on'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        mode=pulumi.get(__response__, 'mode'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        notes=pulumi.get(__response__, 'notes'),
        rule_id=pulumi.get(__response__, 'rule_id'),
        scope=pulumi.get(__response__, 'scope'),
        zone_id=pulumi.get(__response__, 'zone_id')))
