# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccessRulesResult',
    'AwaitableGetAccessRulesResult',
    'get_access_rules',
    'get_access_rules_output',
]

@pulumi.output_type
class GetAccessRulesResult:
    """
    A collection of values returned by getAccessRules.
    """
    def __init__(__self__, account_id=None, configuration=None, direction=None, id=None, match=None, max_items=None, mode=None, notes=None, order=None, results=None, zone_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if configuration and not isinstance(configuration, dict):
            raise TypeError("Expected argument 'configuration' to be a dict")
        pulumi.set(__self__, "configuration", configuration)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if match and not isinstance(match, str):
            raise TypeError("Expected argument 'match' to be a str")
        pulumi.set(__self__, "match", match)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if notes and not isinstance(notes, str):
            raise TypeError("Expected argument 'notes' to be a str")
        pulumi.set(__self__, "notes", notes)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.GetAccessRulesConfigurationResult']:
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def direction(self) -> Optional[builtins.str]:
        """
        Defines the direction used to sort returned rules.
        Available values: "asc", "desc".
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def match(self) -> builtins.str:
        """
        Defines the search requirements. When set to `all`, all the search requirements must match. When set to `any`, only one of the search requirements has to match.
        Available values: "any", "all".
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        The action to apply to a matched request.
        Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def notes(self) -> Optional[builtins.str]:
        """
        Defines the string to search for in the notes of existing IP Access rules.
        Notes: For example, the string 'attack' would match IP Access rules with notes 'Attack 26/02' and 'Attack 27/02'. The search is case insensitive.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter
    def order(self) -> Optional[builtins.str]:
        """
        Defines the field used to sort returned rules.
        Available values: "configuration.target", "configuration.value", "mode".
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetAccessRulesResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[builtins.str]:
        """
        The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetAccessRulesResult(GetAccessRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessRulesResult(
            account_id=self.account_id,
            configuration=self.configuration,
            direction=self.direction,
            id=self.id,
            match=self.match,
            max_items=self.max_items,
            mode=self.mode,
            notes=self.notes,
            order=self.order,
            results=self.results,
            zone_id=self.zone_id)


def get_access_rules(account_id: Optional[builtins.str] = None,
                     configuration: Optional[Union['GetAccessRulesConfigurationArgs', 'GetAccessRulesConfigurationArgsDict']] = None,
                     direction: Optional[builtins.str] = None,
                     match: Optional[builtins.str] = None,
                     max_items: Optional[builtins.int] = None,
                     mode: Optional[builtins.str] = None,
                     notes: Optional[builtins.str] = None,
                     order: Optional[builtins.str] = None,
                     zone_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessRulesResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_access_rules = cloudflare.get_access_rules(account_id="account_id",
        zone_id="zone_id",
        configuration={
            "target": "ip",
            "value": "198.51.100.4",
        },
        direction="desc",
        mode="challenge",
        notes="my note",
        order="mode")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str direction: Defines the direction used to sort returned rules.
           Available values: "asc", "desc".
    :param builtins.str match: Defines the search requirements. When set to `all`, all the search requirements must match. When set to `any`, only one of the search requirements has to match.
           Available values: "any", "all".
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str mode: The action to apply to a matched request.
           Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
    :param builtins.str notes: Defines the string to search for in the notes of existing IP Access rules.
           Notes: For example, the string 'attack' would match IP Access rules with notes 'Attack 26/02' and 'Attack 27/02'. The search is case insensitive.
    :param builtins.str order: Defines the field used to sort returned rules.
           Available values: "configuration.target", "configuration.value", "mode".
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['configuration'] = configuration
    __args__['direction'] = direction
    __args__['match'] = match
    __args__['maxItems'] = max_items
    __args__['mode'] = mode
    __args__['notes'] = notes
    __args__['order'] = order
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccessRules:getAccessRules', __args__, opts=opts, typ=GetAccessRulesResult).value

    return AwaitableGetAccessRulesResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        configuration=pulumi.get(__ret__, 'configuration'),
        direction=pulumi.get(__ret__, 'direction'),
        id=pulumi.get(__ret__, 'id'),
        match=pulumi.get(__ret__, 'match'),
        max_items=pulumi.get(__ret__, 'max_items'),
        mode=pulumi.get(__ret__, 'mode'),
        notes=pulumi.get(__ret__, 'notes'),
        order=pulumi.get(__ret__, 'order'),
        results=pulumi.get(__ret__, 'results'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_access_rules_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            configuration: Optional[pulumi.Input[Optional[Union['GetAccessRulesConfigurationArgs', 'GetAccessRulesConfigurationArgsDict']]]] = None,
                            direction: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            match: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                            mode: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            notes: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            order: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            zone_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessRulesResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_access_rules = cloudflare.get_access_rules(account_id="account_id",
        zone_id="zone_id",
        configuration={
            "target": "ip",
            "value": "198.51.100.4",
        },
        direction="desc",
        mode="challenge",
        notes="my note",
        order="mode")
    ```


    :param builtins.str account_id: The Account ID to use for this endpoint. Mutually exclusive with the Zone ID.
    :param builtins.str direction: Defines the direction used to sort returned rules.
           Available values: "asc", "desc".
    :param builtins.str match: Defines the search requirements. When set to `all`, all the search requirements must match. When set to `any`, only one of the search requirements has to match.
           Available values: "any", "all".
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str mode: The action to apply to a matched request.
           Available values: "block", "challenge", "whitelist", "js*challenge", "managed*challenge".
    :param builtins.str notes: Defines the string to search for in the notes of existing IP Access rules.
           Notes: For example, the string 'attack' would match IP Access rules with notes 'Attack 26/02' and 'Attack 27/02'. The search is case insensitive.
    :param builtins.str order: Defines the field used to sort returned rules.
           Available values: "configuration.target", "configuration.value", "mode".
    :param builtins.str zone_id: The Zone ID to use for this endpoint. Mutually exclusive with the Account ID.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['configuration'] = configuration
    __args__['direction'] = direction
    __args__['match'] = match
    __args__['maxItems'] = max_items
    __args__['mode'] = mode
    __args__['notes'] = notes
    __args__['order'] = order
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccessRules:getAccessRules', __args__, opts=opts, typ=GetAccessRulesResult)
    return __ret__.apply(lambda __response__: GetAccessRulesResult(
        account_id=pulumi.get(__response__, 'account_id'),
        configuration=pulumi.get(__response__, 'configuration'),
        direction=pulumi.get(__response__, 'direction'),
        id=pulumi.get(__response__, 'id'),
        match=pulumi.get(__response__, 'match'),
        max_items=pulumi.get(__response__, 'max_items'),
        mode=pulumi.get(__response__, 'mode'),
        notes=pulumi.get(__response__, 'notes'),
        order=pulumi.get(__response__, 'order'),
        results=pulumi.get(__response__, 'results'),
        zone_id=pulumi.get(__response__, 'zone_id')))
