# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccountApiTokenPermissionGroupsResult',
    'AwaitableGetAccountApiTokenPermissionGroupsResult',
    'get_account_api_token_permission_groups',
    'get_account_api_token_permission_groups_output',
]

@pulumi.output_type
class GetAccountApiTokenPermissionGroupsResult:
    """
    A collection of values returned by getAccountApiTokenPermissionGroups.
    """
    def __init__(__self__, account_id=None, id=None, name=None, scopes=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Public ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Permission Group Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scopes(self) -> Sequence[builtins.str]:
        """
        Resources to which the Permission Group is scoped
        """
        return pulumi.get(self, "scopes")


class AwaitableGetAccountApiTokenPermissionGroupsResult(GetAccountApiTokenPermissionGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountApiTokenPermissionGroupsResult(
            account_id=self.account_id,
            id=self.id,
            name=self.name,
            scopes=self.scopes)


def get_account_api_token_permission_groups(account_id: Optional[builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountApiTokenPermissionGroupsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_api_token_permission_groups = cloudflare.get_account_api_token_permission_groups(account_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Account identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountApiTokenPermissionGroups:getAccountApiTokenPermissionGroups', __args__, opts=opts, typ=GetAccountApiTokenPermissionGroupsResult).value

    return AwaitableGetAccountApiTokenPermissionGroupsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        scopes=pulumi.get(__ret__, 'scopes'))
def get_account_api_token_permission_groups_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountApiTokenPermissionGroupsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_api_token_permission_groups = cloudflare.get_account_api_token_permission_groups(account_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Account identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountApiTokenPermissionGroups:getAccountApiTokenPermissionGroups', __args__, opts=opts, typ=GetAccountApiTokenPermissionGroupsResult)
    return __ret__.apply(lambda __response__: GetAccountApiTokenPermissionGroupsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        scopes=pulumi.get(__response__, 'scopes')))
