# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAccountDnsSettingsResult',
    'AwaitableGetAccountDnsSettingsResult',
    'get_account_dns_settings',
    'get_account_dns_settings_output',
]

@pulumi.output_type
class GetAccountDnsSettingsResult:
    """
    A collection of values returned by getAccountDnsSettings.
    """
    def __init__(__self__, account_id=None, id=None, zone_defaults=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if zone_defaults and not isinstance(zone_defaults, dict):
            raise TypeError("Expected argument 'zone_defaults' to be a dict")
        pulumi.set(__self__, "zone_defaults", zone_defaults)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="zoneDefaults")
    def zone_defaults(self) -> 'outputs.GetAccountDnsSettingsZoneDefaultsResult':
        return pulumi.get(self, "zone_defaults")


class AwaitableGetAccountDnsSettingsResult(GetAccountDnsSettingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountDnsSettingsResult(
            account_id=self.account_id,
            id=self.id,
            zone_defaults=self.zone_defaults)


def get_account_dns_settings(account_id: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountDnsSettingsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_dns_settings = cloudflare.get_account_dns_settings(account_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountDnsSettings:getAccountDnsSettings', __args__, opts=opts, typ=GetAccountDnsSettingsResult).value

    return AwaitableGetAccountDnsSettingsResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        zone_defaults=pulumi.get(__ret__, 'zone_defaults'))
def get_account_dns_settings_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountDnsSettingsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_dns_settings = cloudflare.get_account_dns_settings(account_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountDnsSettings:getAccountDnsSettings', __args__, opts=opts, typ=GetAccountDnsSettingsResult)
    return __ret__.apply(lambda __response__: GetAccountDnsSettingsResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        zone_defaults=pulumi.get(__response__, 'zone_defaults')))
