# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccountDnsSettingsInternalViewResult',
    'AwaitableGetAccountDnsSettingsInternalViewResult',
    'get_account_dns_settings_internal_view',
    'get_account_dns_settings_internal_view_output',
]

@pulumi.output_type
class GetAccountDnsSettingsInternalViewResult:
    """
    A collection of values returned by getAccountDnsSettingsInternalView.
    """
    def __init__(__self__, account_id=None, created_time=None, filter=None, id=None, modified_time=None, name=None, view_id=None, zones=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified_time and not isinstance(modified_time, str):
            raise TypeError("Expected argument 'modified_time' to be a str")
        pulumi.set(__self__, "modified_time", modified_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if view_id and not isinstance(view_id, str):
            raise TypeError("Expected argument 'view_id' to be a str")
        pulumi.set(__self__, "view_id", view_id)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> builtins.str:
        """
        When the view was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetAccountDnsSettingsInternalViewFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> builtins.str:
        """
        When the view was last modified.
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the view.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="viewId")
    def view_id(self) -> Optional[builtins.str]:
        """
        Identifier.
        """
        return pulumi.get(self, "view_id")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[builtins.str]:
        """
        The list of zones linked to this view.
        """
        return pulumi.get(self, "zones")


class AwaitableGetAccountDnsSettingsInternalViewResult(GetAccountDnsSettingsInternalViewResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountDnsSettingsInternalViewResult(
            account_id=self.account_id,
            created_time=self.created_time,
            filter=self.filter,
            id=self.id,
            modified_time=self.modified_time,
            name=self.name,
            view_id=self.view_id,
            zones=self.zones)


def get_account_dns_settings_internal_view(account_id: Optional[builtins.str] = None,
                                           filter: Optional[Union['GetAccountDnsSettingsInternalViewFilterArgs', 'GetAccountDnsSettingsInternalViewFilterArgsDict']] = None,
                                           view_id: Optional[builtins.str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountDnsSettingsInternalViewResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_dns_settings_internal_view = cloudflare.get_account_dns_settings_internal_view(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        view_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str view_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['viewId'] = view_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountDnsSettingsInternalView:getAccountDnsSettingsInternalView', __args__, opts=opts, typ=GetAccountDnsSettingsInternalViewResult).value

    return AwaitableGetAccountDnsSettingsInternalViewResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        created_time=pulumi.get(__ret__, 'created_time'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        modified_time=pulumi.get(__ret__, 'modified_time'),
        name=pulumi.get(__ret__, 'name'),
        view_id=pulumi.get(__ret__, 'view_id'),
        zones=pulumi.get(__ret__, 'zones'))
def get_account_dns_settings_internal_view_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                                                  filter: Optional[pulumi.Input[Optional[Union['GetAccountDnsSettingsInternalViewFilterArgs', 'GetAccountDnsSettingsInternalViewFilterArgsDict']]]] = None,
                                                  view_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountDnsSettingsInternalViewResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_dns_settings_internal_view = cloudflare.get_account_dns_settings_internal_view(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        view_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str account_id: Identifier.
    :param builtins.str view_id: Identifier.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['viewId'] = view_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountDnsSettingsInternalView:getAccountDnsSettingsInternalView', __args__, opts=opts, typ=GetAccountDnsSettingsInternalViewResult)
    return __ret__.apply(lambda __response__: GetAccountDnsSettingsInternalViewResult(
        account_id=pulumi.get(__response__, 'account_id'),
        created_time=pulumi.get(__response__, 'created_time'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        modified_time=pulumi.get(__response__, 'modified_time'),
        name=pulumi.get(__response__, 'name'),
        view_id=pulumi.get(__response__, 'view_id'),
        zones=pulumi.get(__response__, 'zones')))
