# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAccountRoleResult',
    'AwaitableGetAccountRoleResult',
    'get_account_role',
    'get_account_role_output',
]

@pulumi.output_type
class GetAccountRoleResult:
    """
    A collection of values returned by getAccountRole.
    """
    def __init__(__self__, account_id=None, description=None, id=None, name=None, permissions=None, role_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if permissions and not isinstance(permissions, dict):
            raise TypeError("Expected argument 'permissions' to be a dict")
        pulumi.set(__self__, "permissions", permissions)
        if role_id and not isinstance(role_id, str):
            raise TypeError("Expected argument 'role_id' to be a str")
        pulumi.set(__self__, "role_id", role_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of role's permissions.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Role identifier tag.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Role name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def permissions(self) -> 'outputs.GetAccountRolePermissionsResult':
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> builtins.str:
        """
        Role identifier tag.
        """
        return pulumi.get(self, "role_id")


class AwaitableGetAccountRoleResult(GetAccountRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountRoleResult(
            account_id=self.account_id,
            description=self.description,
            id=self.id,
            name=self.name,
            permissions=self.permissions,
            role_id=self.role_id)


def get_account_role(account_id: Optional[builtins.str] = None,
                     role_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountRoleResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_role = cloudflare.get_account_role(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        role_id="3536bcfad5faccb999b47003c79917fb")
    ```


    :param builtins.str account_id: Account identifier tag.
    :param builtins.str role_id: Role identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountRole:getAccountRole', __args__, opts=opts, typ=GetAccountRoleResult).value

    return AwaitableGetAccountRoleResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        permissions=pulumi.get(__ret__, 'permissions'),
        role_id=pulumi.get(__ret__, 'role_id'))
def get_account_role_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                            role_id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountRoleResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_role = cloudflare.get_account_role(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        role_id="3536bcfad5faccb999b47003c79917fb")
    ```


    :param builtins.str account_id: Account identifier tag.
    :param builtins.str role_id: Role identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountRole:getAccountRole', __args__, opts=opts, typ=GetAccountRoleResult)
    return __ret__.apply(lambda __response__: GetAccountRoleResult(
        account_id=pulumi.get(__response__, 'account_id'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        permissions=pulumi.get(__response__, 'permissions'),
        role_id=pulumi.get(__response__, 'role_id')))
