# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccountTokenResult',
    'AwaitableGetAccountTokenResult',
    'get_account_token',
    'get_account_token_output',
]

@pulumi.output_type
class GetAccountTokenResult:
    """
    A collection of values returned by getAccountToken.
    """
    def __init__(__self__, account_id=None, condition=None, expires_on=None, filter=None, id=None, issued_on=None, last_used_on=None, modified_on=None, name=None, not_before=None, policies=None, status=None, token_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if condition and not isinstance(condition, dict):
            raise TypeError("Expected argument 'condition' to be a dict")
        pulumi.set(__self__, "condition", condition)
        if expires_on and not isinstance(expires_on, str):
            raise TypeError("Expected argument 'expires_on' to be a str")
        pulumi.set(__self__, "expires_on", expires_on)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issued_on and not isinstance(issued_on, str):
            raise TypeError("Expected argument 'issued_on' to be a str")
        pulumi.set(__self__, "issued_on", issued_on)
        if last_used_on and not isinstance(last_used_on, str):
            raise TypeError("Expected argument 'last_used_on' to be a str")
        pulumi.set(__self__, "last_used_on", last_used_on)
        if modified_on and not isinstance(modified_on, str):
            raise TypeError("Expected argument 'modified_on' to be a str")
        pulumi.set(__self__, "modified_on", modified_on)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if not_before and not isinstance(not_before, str):
            raise TypeError("Expected argument 'not_before' to be a str")
        pulumi.set(__self__, "not_before", not_before)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if token_id and not isinstance(token_id, str):
            raise TypeError("Expected argument 'token_id' to be a str")
        pulumi.set(__self__, "token_id", token_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GetAccountTokenConditionResult':
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> builtins.str:
        """
        The expiration time on or after which the JWT MUST NOT be accepted for processing.
        """
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetAccountTokenFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Token identifier tag.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="issuedOn")
    def issued_on(self) -> builtins.str:
        """
        The time on which the token was created.
        """
        return pulumi.get(self, "issued_on")

    @property
    @pulumi.getter(name="lastUsedOn")
    def last_used_on(self) -> builtins.str:
        """
        Last time the token was used.
        """
        return pulumi.get(self, "last_used_on")

    @property
    @pulumi.getter(name="modifiedOn")
    def modified_on(self) -> builtins.str:
        """
        Last time the token was modified.
        """
        return pulumi.get(self, "modified_on")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Token name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> builtins.str:
        """
        The time before which the token MUST NOT be accepted for processing.
        """
        return pulumi.get(self, "not_before")

    @property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetAccountTokenPolicyResult']:
        """
        List of access policies assigned to the token.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the token.
        Available values: "active", "disabled", "expired".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> Optional[builtins.str]:
        """
        Token identifier tag.
        """
        return pulumi.get(self, "token_id")


class AwaitableGetAccountTokenResult(GetAccountTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountTokenResult(
            account_id=self.account_id,
            condition=self.condition,
            expires_on=self.expires_on,
            filter=self.filter,
            id=self.id,
            issued_on=self.issued_on,
            last_used_on=self.last_used_on,
            modified_on=self.modified_on,
            name=self.name,
            not_before=self.not_before,
            policies=self.policies,
            status=self.status,
            token_id=self.token_id)


def get_account_token(account_id: Optional[builtins.str] = None,
                      filter: Optional[Union['GetAccountTokenFilterArgs', 'GetAccountTokenFilterArgsDict']] = None,
                      token_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountTokenResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_token = cloudflare.get_account_token(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        token_id="ed17574386854bf78a67040be0a770b0")
    ```


    :param builtins.str account_id: Account identifier tag.
    :param builtins.str token_id: Token identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['tokenId'] = token_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAccountToken:getAccountToken', __args__, opts=opts, typ=GetAccountTokenResult).value

    return AwaitableGetAccountTokenResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        condition=pulumi.get(__ret__, 'condition'),
        expires_on=pulumi.get(__ret__, 'expires_on'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        issued_on=pulumi.get(__ret__, 'issued_on'),
        last_used_on=pulumi.get(__ret__, 'last_used_on'),
        modified_on=pulumi.get(__ret__, 'modified_on'),
        name=pulumi.get(__ret__, 'name'),
        not_before=pulumi.get(__ret__, 'not_before'),
        policies=pulumi.get(__ret__, 'policies'),
        status=pulumi.get(__ret__, 'status'),
        token_id=pulumi.get(__ret__, 'token_id'))
def get_account_token_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                             filter: Optional[pulumi.Input[Optional[Union['GetAccountTokenFilterArgs', 'GetAccountTokenFilterArgsDict']]]] = None,
                             token_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountTokenResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_account_token = cloudflare.get_account_token(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        token_id="ed17574386854bf78a67040be0a770b0")
    ```


    :param builtins.str account_id: Account identifier tag.
    :param builtins.str token_id: Token identifier tag.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['filter'] = filter
    __args__['tokenId'] = token_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAccountToken:getAccountToken', __args__, opts=opts, typ=GetAccountTokenResult)
    return __ret__.apply(lambda __response__: GetAccountTokenResult(
        account_id=pulumi.get(__response__, 'account_id'),
        condition=pulumi.get(__response__, 'condition'),
        expires_on=pulumi.get(__response__, 'expires_on'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        issued_on=pulumi.get(__response__, 'issued_on'),
        last_used_on=pulumi.get(__response__, 'last_used_on'),
        modified_on=pulumi.get(__response__, 'modified_on'),
        name=pulumi.get(__response__, 'name'),
        not_before=pulumi.get(__response__, 'not_before'),
        policies=pulumi.get(__response__, 'policies'),
        status=pulumi.get(__response__, 'status'),
        token_id=pulumi.get(__response__, 'token_id')))
