# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAddressMapResult',
    'AwaitableGetAddressMapResult',
    'get_address_map',
    'get_address_map_output',
]

@pulumi.output_type
class GetAddressMapResult:
    """
    A collection of values returned by getAddressMap.
    """
    def __init__(__self__, account_id=None, address_map_id=None, can_delete=None, can_modify_ips=None, created_at=None, default_sni=None, description=None, enabled=None, id=None, ips=None, memberships=None, modified_at=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if address_map_id and not isinstance(address_map_id, str):
            raise TypeError("Expected argument 'address_map_id' to be a str")
        pulumi.set(__self__, "address_map_id", address_map_id)
        if can_delete and not isinstance(can_delete, bool):
            raise TypeError("Expected argument 'can_delete' to be a bool")
        pulumi.set(__self__, "can_delete", can_delete)
        if can_modify_ips and not isinstance(can_modify_ips, bool):
            raise TypeError("Expected argument 'can_modify_ips' to be a bool")
        pulumi.set(__self__, "can_modify_ips", can_modify_ips)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if default_sni and not isinstance(default_sni, str):
            raise TypeError("Expected argument 'default_sni' to be a str")
        pulumi.set(__self__, "default_sni", default_sni)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ips and not isinstance(ips, list):
            raise TypeError("Expected argument 'ips' to be a list")
        pulumi.set(__self__, "ips", ips)
        if memberships and not isinstance(memberships, list):
            raise TypeError("Expected argument 'memberships' to be a list")
        pulumi.set(__self__, "memberships", memberships)
        if modified_at and not isinstance(modified_at, str):
            raise TypeError("Expected argument 'modified_at' to be a str")
        pulumi.set(__self__, "modified_at", modified_at)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Identifier of a Cloudflare account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="addressMapId")
    def address_map_id(self) -> Optional[builtins.str]:
        """
        Identifier of an Address Map.
        """
        return pulumi.get(self, "address_map_id")

    @property
    @pulumi.getter(name="canDelete")
    def can_delete(self) -> builtins.bool:
        """
        If set to false, then the Address Map cannot be deleted via API. This is true for Cloudflare-managed maps.
        """
        return pulumi.get(self, "can_delete")

    @property
    @pulumi.getter(name="canModifyIps")
    def can_modify_ips(self) -> builtins.bool:
        """
        If set to false, then the IPs on the Address Map cannot be modified via the API. This is true for Cloudflare-managed maps.
        """
        return pulumi.get(self, "can_modify_ips")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="defaultSni")
    def default_sni(self) -> builtins.str:
        """
        If you have legacy TLS clients which do not send the TLS server name indicator, then you can specify one default SNI on the map. If Cloudflare receives a TLS handshake from a client without an SNI, it will respond with the default SNI on those IPs. The default SNI can be any valid zone or subdomain owned by the account.
        """
        return pulumi.get(self, "default_sni")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        An optional description field which may be used to describe the types of IPs or zones on the map.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether the Address Map is enabled or not. Cloudflare's DNS will not respond with IP addresses on an Address Map until the map is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier of an Address Map.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.GetAddressMapIpResult']:
        """
        The set of IPs on the Address Map.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def memberships(self) -> Sequence['outputs.GetAddressMapMembershipResult']:
        """
        Zones and Accounts which will be assigned IPs on this Address Map. A zone membership will take priority over an account membership.
        """
        return pulumi.get(self, "memberships")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> builtins.str:
        return pulumi.get(self, "modified_at")


class AwaitableGetAddressMapResult(GetAddressMapResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressMapResult(
            account_id=self.account_id,
            address_map_id=self.address_map_id,
            can_delete=self.can_delete,
            can_modify_ips=self.can_modify_ips,
            created_at=self.created_at,
            default_sni=self.default_sni,
            description=self.description,
            enabled=self.enabled,
            id=self.id,
            ips=self.ips,
            memberships=self.memberships,
            modified_at=self.modified_at)


def get_address_map(account_id: Optional[builtins.str] = None,
                    address_map_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressMapResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_address_map = cloudflare.get_address_map(account_id="258def64c72dae45f3e4c8516e2111f2",
        address_map_id="055817b111884e0227e1be16a0be6ee0")
    ```


    :param builtins.str account_id: Identifier of a Cloudflare account.
    :param builtins.str address_map_id: Identifier of an Address Map.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['addressMapId'] = address_map_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAddressMap:getAddressMap', __args__, opts=opts, typ=GetAddressMapResult).value

    return AwaitableGetAddressMapResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        address_map_id=pulumi.get(__ret__, 'address_map_id'),
        can_delete=pulumi.get(__ret__, 'can_delete'),
        can_modify_ips=pulumi.get(__ret__, 'can_modify_ips'),
        created_at=pulumi.get(__ret__, 'created_at'),
        default_sni=pulumi.get(__ret__, 'default_sni'),
        description=pulumi.get(__ret__, 'description'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        ips=pulumi.get(__ret__, 'ips'),
        memberships=pulumi.get(__ret__, 'memberships'),
        modified_at=pulumi.get(__ret__, 'modified_at'))
def get_address_map_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                           address_map_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddressMapResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_address_map = cloudflare.get_address_map(account_id="258def64c72dae45f3e4c8516e2111f2",
        address_map_id="055817b111884e0227e1be16a0be6ee0")
    ```


    :param builtins.str account_id: Identifier of a Cloudflare account.
    :param builtins.str address_map_id: Identifier of an Address Map.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['addressMapId'] = address_map_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAddressMap:getAddressMap', __args__, opts=opts, typ=GetAddressMapResult)
    return __ret__.apply(lambda __response__: GetAddressMapResult(
        account_id=pulumi.get(__response__, 'account_id'),
        address_map_id=pulumi.get(__response__, 'address_map_id'),
        can_delete=pulumi.get(__response__, 'can_delete'),
        can_modify_ips=pulumi.get(__response__, 'can_modify_ips'),
        created_at=pulumi.get(__response__, 'created_at'),
        default_sni=pulumi.get(__response__, 'default_sni'),
        description=pulumi.get(__response__, 'description'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        ips=pulumi.get(__response__, 'ips'),
        memberships=pulumi.get(__response__, 'memberships'),
        modified_at=pulumi.get(__response__, 'modified_at')))
