# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetApiShieldResult',
    'AwaitableGetApiShieldResult',
    'get_api_shield',
    'get_api_shield_output',
]

@pulumi.output_type
class GetApiShieldResult:
    """
    A collection of values returned by getApiShield.
    """
    def __init__(__self__, auth_id_characteristics=None, id=None, properties=None, zone_id=None):
        if auth_id_characteristics and not isinstance(auth_id_characteristics, list):
            raise TypeError("Expected argument 'auth_id_characteristics' to be a list")
        pulumi.set(__self__, "auth_id_characteristics", auth_id_characteristics)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="authIdCharacteristics")
    def auth_id_characteristics(self) -> Sequence['outputs.GetApiShieldAuthIdCharacteristicResult']:
        return pulumi.get(self, "auth_id_characteristics")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Sequence[builtins.str]]:
        """
        Requests information about certain properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetApiShieldResult(GetApiShieldResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiShieldResult(
            auth_id_characteristics=self.auth_id_characteristics,
            id=self.id,
            properties=self.properties,
            zone_id=self.zone_id)


def get_api_shield(properties: Optional[Sequence[builtins.str]] = None,
                   zone_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiShieldResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_api_shield = cloudflare.get_api_shield(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        properties=["auth_id_characteristics"])
    ```


    :param Sequence[builtins.str] properties: Requests information about certain properties.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['properties'] = properties
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getApiShield:getApiShield', __args__, opts=opts, typ=GetApiShieldResult).value

    return AwaitableGetApiShieldResult(
        auth_id_characteristics=pulumi.get(__ret__, 'auth_id_characteristics'),
        id=pulumi.get(__ret__, 'id'),
        properties=pulumi.get(__ret__, 'properties'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_api_shield_output(properties: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                          zone_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiShieldResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_api_shield = cloudflare.get_api_shield(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        properties=["auth_id_characteristics"])
    ```


    :param Sequence[builtins.str] properties: Requests information about certain properties.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['properties'] = properties
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getApiShield:getApiShield', __args__, opts=opts, typ=GetApiShieldResult)
    return __ret__.apply(lambda __response__: GetApiShieldResult(
        auth_id_characteristics=pulumi.get(__response__, 'auth_id_characteristics'),
        id=pulumi.get(__response__, 'id'),
        properties=pulumi.get(__response__, 'properties'),
        zone_id=pulumi.get(__response__, 'zone_id')))
