# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetApiShieldOperationsResult',
    'AwaitableGetApiShieldOperationsResult',
    'get_api_shield_operations',
    'get_api_shield_operations_output',
]

@pulumi.output_type
class GetApiShieldOperationsResult:
    """
    A collection of values returned by getApiShieldOperations.
    """
    def __init__(__self__, direction=None, endpoint=None, features=None, hosts=None, id=None, max_items=None, methods=None, order=None, results=None, zone_id=None):
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if features and not isinstance(features, list):
            raise TypeError("Expected argument 'features' to be a list")
        pulumi.set(__self__, "features", features)
        if hosts and not isinstance(hosts, list):
            raise TypeError("Expected argument 'hosts' to be a list")
        pulumi.set(__self__, "hosts", hosts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if methods and not isinstance(methods, list):
            raise TypeError("Expected argument 'methods' to be a list")
        pulumi.set(__self__, "methods", methods)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def direction(self) -> Optional[builtins.str]:
        """
        Direction to order results.
        Available values: "asc", "desc".
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        """
        Filter results to only include endpoints containing this pattern.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def features(self) -> Optional[Sequence[builtins.str]]:
        """
        Add feature(s) to the results. The feature name that is given here corresponds to the resulting feature object. Have a look at the top-level object description for more details on the specific meaning.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence[builtins.str]]:
        """
        Filter results to only include the specified hosts.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[builtins.str]]:
        """
        Filter results to only include the specified HTTP methods.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def order(self) -> Optional[builtins.str]:
        """
        Field to order by. When requesting a feature, the feature keys are available for ordering as well, e.g., `thresholds.suggested_threshold`.
        Available values: "method", "host", "endpoint", "thresholds.$key".
        """
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetApiShieldOperationsResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetApiShieldOperationsResult(GetApiShieldOperationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiShieldOperationsResult(
            direction=self.direction,
            endpoint=self.endpoint,
            features=self.features,
            hosts=self.hosts,
            id=self.id,
            max_items=self.max_items,
            methods=self.methods,
            order=self.order,
            results=self.results,
            zone_id=self.zone_id)


def get_api_shield_operations(direction: Optional[builtins.str] = None,
                              endpoint: Optional[builtins.str] = None,
                              features: Optional[Sequence[builtins.str]] = None,
                              hosts: Optional[Sequence[builtins.str]] = None,
                              max_items: Optional[builtins.int] = None,
                              methods: Optional[Sequence[builtins.str]] = None,
                              order: Optional[builtins.str] = None,
                              zone_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiShieldOperationsResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_api_shield_operations = cloudflare.get_api_shield_operations(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        direction="desc",
        endpoint="/api/v1",
        features=["thresholds"],
        hosts=["api.cloudflare.com"],
        methods=["GET"],
        order="method")
    ```


    :param builtins.str direction: Direction to order results.
           Available values: "asc", "desc".
    :param builtins.str endpoint: Filter results to only include endpoints containing this pattern.
    :param Sequence[builtins.str] features: Add feature(s) to the results. The feature name that is given here corresponds to the resulting feature object. Have a look at the top-level object description for more details on the specific meaning.
    :param Sequence[builtins.str] hosts: Filter results to only include the specified hosts.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param Sequence[builtins.str] methods: Filter results to only include the specified HTTP methods.
    :param builtins.str order: Field to order by. When requesting a feature, the feature keys are available for ordering as well, e.g., `thresholds.suggested_threshold`.
           Available values: "method", "host", "endpoint", "thresholds.$key".
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['direction'] = direction
    __args__['endpoint'] = endpoint
    __args__['features'] = features
    __args__['hosts'] = hosts
    __args__['maxItems'] = max_items
    __args__['methods'] = methods
    __args__['order'] = order
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getApiShieldOperations:getApiShieldOperations', __args__, opts=opts, typ=GetApiShieldOperationsResult).value

    return AwaitableGetApiShieldOperationsResult(
        direction=pulumi.get(__ret__, 'direction'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        features=pulumi.get(__ret__, 'features'),
        hosts=pulumi.get(__ret__, 'hosts'),
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        methods=pulumi.get(__ret__, 'methods'),
        order=pulumi.get(__ret__, 'order'),
        results=pulumi.get(__ret__, 'results'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_api_shield_operations_output(direction: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     endpoint: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     features: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                     hosts: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                     max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                     methods: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                     order: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                     zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiShieldOperationsResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_api_shield_operations = cloudflare.get_api_shield_operations(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        direction="desc",
        endpoint="/api/v1",
        features=["thresholds"],
        hosts=["api.cloudflare.com"],
        methods=["GET"],
        order="method")
    ```


    :param builtins.str direction: Direction to order results.
           Available values: "asc", "desc".
    :param builtins.str endpoint: Filter results to only include endpoints containing this pattern.
    :param Sequence[builtins.str] features: Add feature(s) to the results. The feature name that is given here corresponds to the resulting feature object. Have a look at the top-level object description for more details on the specific meaning.
    :param Sequence[builtins.str] hosts: Filter results to only include the specified hosts.
    :param builtins.int max_items: Max items to fetch, default: 1000
    :param Sequence[builtins.str] methods: Filter results to only include the specified HTTP methods.
    :param builtins.str order: Field to order by. When requesting a feature, the feature keys are available for ordering as well, e.g., `thresholds.suggested_threshold`.
           Available values: "method", "host", "endpoint", "thresholds.$key".
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['direction'] = direction
    __args__['endpoint'] = endpoint
    __args__['features'] = features
    __args__['hosts'] = hosts
    __args__['maxItems'] = max_items
    __args__['methods'] = methods
    __args__['order'] = order
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getApiShieldOperations:getApiShieldOperations', __args__, opts=opts, typ=GetApiShieldOperationsResult)
    return __ret__.apply(lambda __response__: GetApiShieldOperationsResult(
        direction=pulumi.get(__response__, 'direction'),
        endpoint=pulumi.get(__response__, 'endpoint'),
        features=pulumi.get(__response__, 'features'),
        hosts=pulumi.get(__response__, 'hosts'),
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        methods=pulumi.get(__response__, 'methods'),
        order=pulumi.get(__response__, 'order'),
        results=pulumi.get(__response__, 'results'),
        zone_id=pulumi.get(__response__, 'zone_id')))
