# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAuthenticatedOriginPullsCertificateResult',
    'AwaitableGetAuthenticatedOriginPullsCertificateResult',
    'get_authenticated_origin_pulls_certificate',
    'get_authenticated_origin_pulls_certificate_output',
]

@pulumi.output_type
class GetAuthenticatedOriginPullsCertificateResult:
    """
    A collection of values returned by getAuthenticatedOriginPullsCertificate.
    """
    def __init__(__self__, certificate=None, certificate_id=None, enabled=None, expires_on=None, id=None, issuer=None, private_key=None, signature=None, status=None, uploaded_on=None, zone_id=None):
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if expires_on and not isinstance(expires_on, str):
            raise TypeError("Expected argument 'expires_on' to be a str")
        pulumi.set(__self__, "expires_on", expires_on)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if private_key and not isinstance(private_key, str):
            raise TypeError("Expected argument 'private_key' to be a str")
        pulumi.set(__self__, "private_key", private_key)
        if signature and not isinstance(signature, str):
            raise TypeError("Expected argument 'signature' to be a str")
        pulumi.set(__self__, "signature", signature)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if uploaded_on and not isinstance(uploaded_on, str):
            raise TypeError("Expected argument 'uploaded_on' to be a str")
        pulumi.set(__self__, "uploaded_on", uploaded_on)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def certificate(self) -> builtins.str:
        """
        The zone's leaf certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Indicates whether zone-level authenticated origin pulls is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expiresOn")
    def expires_on(self) -> builtins.str:
        """
        When the certificate from the authority expires.
        """
        return pulumi.get(self, "expires_on")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        The certificate authority that issued the certificate.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> builtins.str:
        """
        The zone's private key.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def signature(self) -> builtins.str:
        """
        The type of hash used for the certificate.
        """
        return pulumi.get(self, "signature")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the certificate activation.
        Available values: "initializing", "pending*deployment", "pending*deletion", "active", "deleted", "deployment*timed*out", "deletion*timed*out".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="uploadedOn")
    def uploaded_on(self) -> builtins.str:
        """
        This is the time the certificate was uploaded.
        """
        return pulumi.get(self, "uploaded_on")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetAuthenticatedOriginPullsCertificateResult(GetAuthenticatedOriginPullsCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthenticatedOriginPullsCertificateResult(
            certificate=self.certificate,
            certificate_id=self.certificate_id,
            enabled=self.enabled,
            expires_on=self.expires_on,
            id=self.id,
            issuer=self.issuer,
            private_key=self.private_key,
            signature=self.signature,
            status=self.status,
            uploaded_on=self.uploaded_on,
            zone_id=self.zone_id)


def get_authenticated_origin_pulls_certificate(certificate_id: Optional[builtins.str] = None,
                                               zone_id: Optional[builtins.str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthenticatedOriginPullsCertificateResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_authenticated_origin_pulls_certificate = cloudflare.get_authenticated_origin_pulls_certificate(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        certificate_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str certificate_id: Identifier.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getAuthenticatedOriginPullsCertificate:getAuthenticatedOriginPullsCertificate', __args__, opts=opts, typ=GetAuthenticatedOriginPullsCertificateResult).value

    return AwaitableGetAuthenticatedOriginPullsCertificateResult(
        certificate=pulumi.get(__ret__, 'certificate'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        enabled=pulumi.get(__ret__, 'enabled'),
        expires_on=pulumi.get(__ret__, 'expires_on'),
        id=pulumi.get(__ret__, 'id'),
        issuer=pulumi.get(__ret__, 'issuer'),
        private_key=pulumi.get(__ret__, 'private_key'),
        signature=pulumi.get(__ret__, 'signature'),
        status=pulumi.get(__ret__, 'status'),
        uploaded_on=pulumi.get(__ret__, 'uploaded_on'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_authenticated_origin_pulls_certificate_output(certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                                                      zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthenticatedOriginPullsCertificateResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_authenticated_origin_pulls_certificate = cloudflare.get_authenticated_origin_pulls_certificate(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        certificate_id="023e105f4ecef8ad9ca31a8372d0c353")
    ```


    :param builtins.str certificate_id: Identifier.
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getAuthenticatedOriginPullsCertificate:getAuthenticatedOriginPullsCertificate', __args__, opts=opts, typ=GetAuthenticatedOriginPullsCertificateResult)
    return __ret__.apply(lambda __response__: GetAuthenticatedOriginPullsCertificateResult(
        certificate=pulumi.get(__response__, 'certificate'),
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        enabled=pulumi.get(__response__, 'enabled'),
        expires_on=pulumi.get(__response__, 'expires_on'),
        id=pulumi.get(__response__, 'id'),
        issuer=pulumi.get(__response__, 'issuer'),
        private_key=pulumi.get(__response__, 'private_key'),
        signature=pulumi.get(__response__, 'signature'),
        status=pulumi.get(__response__, 'status'),
        uploaded_on=pulumi.get(__response__, 'uploaded_on'),
        zone_id=pulumi.get(__response__, 'zone_id')))
