# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCallsSfuAppResult',
    'AwaitableGetCallsSfuAppResult',
    'get_calls_sfu_app',
    'get_calls_sfu_app_output',
]

@pulumi.output_type
class GetCallsSfuAppResult:
    """
    A collection of values returned by getCallsSfuApp.
    """
    def __init__(__self__, account_id=None, app_id=None, created=None, id=None, modified=None, name=None, uid=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if modified and not isinstance(modified, str):
            raise TypeError("Expected argument 'modified' to be a str")
        pulumi.set(__self__, "modified", modified)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        The account identifier tag.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> builtins.str:
        """
        A Cloudflare-generated unique identifier for a item.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def created(self) -> builtins.str:
        """
        The date and time the item was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def modified(self) -> builtins.str:
        """
        The date and time the item was last modified.
        """
        return pulumi.get(self, "modified")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A short description of Calls app, not shown to end users.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uid(self) -> builtins.str:
        """
        A Cloudflare-generated unique identifier for a item.
        """
        return pulumi.get(self, "uid")


class AwaitableGetCallsSfuAppResult(GetCallsSfuAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCallsSfuAppResult(
            account_id=self.account_id,
            app_id=self.app_id,
            created=self.created,
            id=self.id,
            modified=self.modified,
            name=self.name,
            uid=self.uid)


def get_calls_sfu_app(account_id: Optional[builtins.str] = None,
                      app_id: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCallsSfuAppResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_calls_sfu_app = cloudflare.get_calls_sfu_app(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        app_id="2a95132c15732412d22c1476fa83f27a")
    ```


    :param builtins.str account_id: The account identifier tag.
    :param builtins.str app_id: A Cloudflare-generated unique identifier for a item.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['appId'] = app_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCallsSfuApp:getCallsSfuApp', __args__, opts=opts, typ=GetCallsSfuAppResult).value

    return AwaitableGetCallsSfuAppResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        app_id=pulumi.get(__ret__, 'app_id'),
        created=pulumi.get(__ret__, 'created'),
        id=pulumi.get(__ret__, 'id'),
        modified=pulumi.get(__ret__, 'modified'),
        name=pulumi.get(__ret__, 'name'),
        uid=pulumi.get(__ret__, 'uid'))
def get_calls_sfu_app_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                             app_id: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCallsSfuAppResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_calls_sfu_app = cloudflare.get_calls_sfu_app(account_id="023e105f4ecef8ad9ca31a8372d0c353",
        app_id="2a95132c15732412d22c1476fa83f27a")
    ```


    :param builtins.str account_id: The account identifier tag.
    :param builtins.str app_id: A Cloudflare-generated unique identifier for a item.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['appId'] = app_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCallsSfuApp:getCallsSfuApp', __args__, opts=opts, typ=GetCallsSfuAppResult)
    return __ret__.apply(lambda __response__: GetCallsSfuAppResult(
        account_id=pulumi.get(__response__, 'account_id'),
        app_id=pulumi.get(__response__, 'app_id'),
        created=pulumi.get(__response__, 'created'),
        id=pulumi.get(__response__, 'id'),
        modified=pulumi.get(__response__, 'modified'),
        name=pulumi.get(__response__, 'name'),
        uid=pulumi.get(__response__, 'uid')))
