# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCertificatePacksResult',
    'AwaitableGetCertificatePacksResult',
    'get_certificate_packs',
    'get_certificate_packs_output',
]

@pulumi.output_type
class GetCertificatePacksResult:
    """
    A collection of values returned by getCertificatePacks.
    """
    def __init__(__self__, id=None, max_items=None, results=None, status=None, zone_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_items and not isinstance(max_items, int):
            raise TypeError("Expected argument 'max_items' to be a int")
        pulumi.set(__self__, "max_items", max_items)
        if results and not isinstance(results, list):
            raise TypeError("Expected argument 'results' to be a list")
        pulumi.set(__self__, "results", results)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[builtins.int]:
        """
        Max items to fetch, default: 1000
        """
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter
    def results(self) -> Sequence['outputs.GetCertificatePacksResultResult']:
        """
        The items returned by the data source
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Include Certificate Packs of all statuses, not just active ones.
        Available values: "all".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> builtins.str:
        """
        Identifier.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetCertificatePacksResult(GetCertificatePacksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificatePacksResult(
            id=self.id,
            max_items=self.max_items,
            results=self.results,
            status=self.status,
            zone_id=self.zone_id)


def get_certificate_packs(max_items: Optional[builtins.int] = None,
                          status: Optional[builtins.str] = None,
                          zone_id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificatePacksResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_certificate_packs = cloudflare.get_certificate_packs(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        status="all")
    ```


    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str status: Include Certificate Packs of all statuses, not just active ones.
           Available values: "all".
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['maxItems'] = max_items
    __args__['status'] = status
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudflare:index/getCertificatePacks:getCertificatePacks', __args__, opts=opts, typ=GetCertificatePacksResult).value

    return AwaitableGetCertificatePacksResult(
        id=pulumi.get(__ret__, 'id'),
        max_items=pulumi.get(__ret__, 'max_items'),
        results=pulumi.get(__ret__, 'results'),
        status=pulumi.get(__ret__, 'status'),
        zone_id=pulumi.get(__ret__, 'zone_id'))
def get_certificate_packs_output(max_items: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                 status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificatePacksResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudflare as cloudflare

    example_certificate_packs = cloudflare.get_certificate_packs(zone_id="023e105f4ecef8ad9ca31a8372d0c353",
        status="all")
    ```


    :param builtins.int max_items: Max items to fetch, default: 1000
    :param builtins.str status: Include Certificate Packs of all statuses, not just active ones.
           Available values: "all".
    :param builtins.str zone_id: Identifier.
    """
    __args__ = dict()
    __args__['maxItems'] = max_items
    __args__['status'] = status
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudflare:index/getCertificatePacks:getCertificatePacks', __args__, opts=opts, typ=GetCertificatePacksResult)
    return __ret__.apply(lambda __response__: GetCertificatePacksResult(
        id=pulumi.get(__response__, 'id'),
        max_items=pulumi.get(__response__, 'max_items'),
        results=pulumi.get(__response__, 'results'),
        status=pulumi.get(__response__, 'status'),
        zone_id=pulumi.get(__response__, 'zone_id')))
